/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.wsdl.util.internal;

import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.jaxwshandler.utils.JAXWSToWSDLUtil;
import com.ibm.appscan.frameworks.jaxwshandler.utils.JAXWSUtils;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.TypeReference;
import java.util.HashMap;

public class ServiceReportingUtil {
    private static final HashMap<String, String> javaTypeToWsdlTypeMap = new HashMap();

    public static String convertJavaTypeToWSDL(F4FApp app, TypeReference type, String defaultTNS) {
        String javaType = type.getName().toString();
        return ServiceReportingUtil.convertJavaTypeToWSDL(app, javaType, defaultTNS);
    }

    public static String convertJavaTypeToWSDL(F4FApp app, String type, String defaultTNS) {
        String wsdlType = javaTypeToWsdlTypeMap.get(type);
        if (wsdlType != null) {
            return wsdlType;
        }
        String javaClassName = JAXWSUtils.convertToSimpleName(type);
        wsdlType = javaTypeToWsdlTypeMap.get(javaClassName);
        if (wsdlType != null) {
            return wsdlType;
        }
        IClass javaClazz = app.getIClass(javaClassName);
        if (javaClazz != null) {
            String namespace = JAXWSToWSDLUtil.getTargetNamespace(app, javaClazz);
            if (namespace == null) {
                if (defaultTNS != null) {
                    namespace = defaultTNS;
                } else {
                    return null;
                }
            }
            if (!namespace.endsWith("/")) {
                namespace = namespace + "/";
            }
            String qNClassName = javaClazz.getName().toString();
            String classNameOnly = qNClassName.substring(qNClassName.lastIndexOf("/") + 1);
            return namespace + ":" + classNameOnly;
        }
        return null;
    }

    static {
        javaTypeToWsdlTypeMap.put("java.lang.Boolean", "boolean");
        javaTypeToWsdlTypeMap.put("java.lang.Byte", "byte");
        javaTypeToWsdlTypeMap.put("java.lang.Double", "double");
        javaTypeToWsdlTypeMap.put("java.util.Float", "float");
        javaTypeToWsdlTypeMap.put("java.lang.Integer", "int");
        javaTypeToWsdlTypeMap.put("java.lang.Long", "long");
        javaTypeToWsdlTypeMap.put("java.lang.Short", "short");
        javaTypeToWsdlTypeMap.put("java.math.BigDecimal", "decimal");
        javaTypeToWsdlTypeMap.put("java.math.BigInteger", "integer");
        javaTypeToWsdlTypeMap.put("java.net.URI", "anyURI");
        javaTypeToWsdlTypeMap.put("java.util.Calendar", "dateTime");
        javaTypeToWsdlTypeMap.put("javax.xml.datatype.XMLGregorianCalendar", "dateTime");
        javaTypeToWsdlTypeMap.put("java.util.Date", "date");
        javaTypeToWsdlTypeMap.put("java.xml.QName", "QName");
        javaTypeToWsdlTypeMap.put("java.lang.String", "string");
        javaTypeToWsdlTypeMap.put("java.util.Date", "dateTime");
        javaTypeToWsdlTypeMap.put("[B", "base64Binary");
        javaTypeToWsdlTypeMap.put(TypeReference.BooleanName.toString(), "boolean");
        javaTypeToWsdlTypeMap.put(TypeReference.ByteName.toString(), "byte");
        javaTypeToWsdlTypeMap.put(TypeReference.DoubleName.toString(), "double");
        javaTypeToWsdlTypeMap.put(TypeReference.FloatName.toString(), "float");
        javaTypeToWsdlTypeMap.put(TypeReference.IntName.toString(), "int");
        javaTypeToWsdlTypeMap.put(TypeReference.LongName.toString(), "long");
        javaTypeToWsdlTypeMap.put(TypeReference.ShortName.toString(), "short");
        javaTypeToWsdlTypeMap.put(TypeReference.CharName.toString(), "unsignedShort");
    }
}

