/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config;

import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.internal.common.model.ScanFile;
import com.ibm.appscan.internal.config.Target;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class ReadXMLFile
extends XMLFileReader {
    private Target target;
    private List<Target> targets = new ArrayList<Target>();

    protected ReadXMLFile(File file) {
        super(file);
    }

    protected boolean process(StartElement element) {
        if (element.getName().toString().equals("Target") && this.target == null) {
            this.target = new Target();
            this.target.setType(this.getAttribute(element, "language_type"));
        } else if (element.getName().toString().equals("ScanFile")) {
            File analysis_path = new File(this.getAttribute(element, "analysis_path"));
            String final_path = analysis_path.getPath();
            if (!analysis_path.isAbsolute()) {
                analysis_path = new File(this.getFile().getParentFile(), analysis_path.getPath());
                try {
                    final_path = analysis_path.getCanonicalPath();
                }
                catch (IOException e) {
                    final_path = analysis_path.getAbsolutePath();
                }
            }
            ScanFile file = new ScanFile(final_path, this.getAttribute(element, "src_path"), this.getAttribute(element, "checksum"));
            if (this.getAttribute(element, "file_size") != null) {
                file.setFileSize(Double.parseDouble(this.getAttribute(element, "file_size")));
            }
            if (this.getAttribute(element, "file_version") != null) {
                file.setFileVersion(this.getAttribute(element, "file_version"));
            }
            this.target.addScanFile((IScanFile)file);
        }
        return super.process(element);
    }

    protected boolean process(EndElement element) {
        if (element.getName().toString().equals("Target")) {
            this.targets.add(this.target);
        }
        return super.process(element);
    }

    public void getTargetScans(Map<String, Set<IScanFile>> map) {
        if (!this.targets.isEmpty()) {
            for (Target targ : this.targets) {
                Set<IScanFile> str = targ.getScanFile();
                String language = targ.getLanguageType();
                if (language == null) continue;
                if (language.equalsIgnoreCase("thirdpartylib")) {
                    language = "Open Source";
                }
                if (!map.containsKey(language)) {
                    HashSet scanfiles = new HashSet();
                    map.put(language, scanfiles);
                }
                Set<IScanFile> clazzes = map.get(language);
                for (IScanFile f : str) {
                    clazzes.add(f);
                }
                map.put(language, clazzes);
            }
        }
    }

    public String getScanLanguage() {
        return this.target.getLanguageType();
    }
}

