/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config.model;

import com.ibm.appscan.common.model.IBuildInfoManager;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.ITransformable;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import java.io.File;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class TargetInfoWriter
extends ModelWriter
implements IModelXMLConstants {
    private File m_scanHome = null;
    private Deque<Object> m_targetInfos = new LinkedList<Object>();
    private boolean m_hasErrors = false;

    protected void initWriters(File directory) throws IOException {
    }

    private void beginTarget(DOMWriter writer, IScanTarget target, boolean isRootElement) {
        if (SystemUtil.isOpenSourceOnly() && !"ThirdPartyLib".equals(target.getName())) {
            return;
        }
        writer.beginElement("Target");
        String path = target.getPath();
        writer.setAttribute("path", path);
        if (isRootElement) {
            writer.setAttribute("working_directory", ".");
            writer.setAttribute("name", target.getName());
            writer.setAttribute("type", target.getType());
            writer.setAttribute("strategy", target.getStrategyClass());
            String lang = target.getLanguageType();
            if (lang != null) {
                writer.setAttribute("language_type", lang);
            }
        } else {
            writer.setAttribute("working_directory", target.getWorkingDirectoryName());
        }
    }

    private void writeBuildInfo(DOMWriter writer, IScanTarget target) {
        if (target.getBuildInfoManager() != null) {
            writer.beginElement("BuildInfo");
            IBuildInfoManager info = target.getBuildInfoManager();
            for (Map.Entry entry : info) {
                String key = (String)entry.getKey();
                String value = info.getDiscoveredProperty(key);
                if (value == null) continue;
                if ("classpath".equals(key)) {
                    value = ClasspathUtil.makeRelative((File)this.m_scanHome, (File)this.getWorkingDirectory(), (String)value);
                }
                writer.setAttribute(key, value);
            }
            writer.endElement();
        }
    }

    private void writeScanFiles(DOMWriter writer, IScanTarget target) {
        File workingDirectory = this.getWorkingDirectory();
        for (IScanFile file : target.getScanFiles()) {
            String version;
            String checksum;
            if (file.isExcluded()) continue;
            writer.beginElement("ScanFile");
            writer.setAttribute("analysis_path", PathUtil.replaceBackslashes((String)PathUtil.makeRelative((File)this.m_scanHome, (File)workingDirectory, (File)file.getFile()).getPath()));
            String sourcePath = file.getSourcePath();
            if (sourcePath != null) {
                writer.setAttribute("src_path", PathUtil.makeRelative((File)this.m_scanHome, (File)workingDirectory, (String)sourcePath));
            }
            if ((checksum = file.getChecksum()) != null) {
                writer.setAttribute("checksum", checksum);
            }
            if ((version = file.getFileVersion()) != null) {
                writer.setAttribute("file_version", version);
            }
            writer.setAttribute("file_size", String.format("%.1f", file.getFileSize()));
            writer.endElement();
        }
    }

    private void deleteFiles(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || file.getName().endsWith(".log") || file.getName().endsWith(".zip")) continue;
                file.delete();
            }
        }
    }

    public void visit(IScan scan) {
        SaveLocation location = scan.getSaveLocation();
        if (location != null) {
            this.m_scanHome = location.getWorkLocation();
        }
    }

    public void visit(IScanTarget target) {
        Object obj;
        if (SystemUtil.isOpenSourceOnly() && !"ThirdPartyLib".equals(target.getName())) {
            return;
        }
        if (target.getParent() != null && (obj = this.m_targetInfos.peek()) instanceof DOMWriter) {
            DOMWriter parent = (DOMWriter)obj;
            this.beginTarget(parent, target, false);
            parent.endElement();
        }
        if (target.getState() == ITransformable.State.TRANSFORMED) {
            this.m_targetInfos.push(new Object());
            return;
        }
        this.deleteFiles(this.getWorkingDirectory());
        try {
            DOMWriter current = new DOMWriter(this.getWorkingDirectory(), ".targetinfo", this.m_builder);
            this.beginTarget(current, target, true);
            this.writeBuildInfo(current, target);
            this.writeScanFiles(current, target);
            this.m_targetInfos.push(current);
        }
        catch (IOException e) {
            target.getErrorManager().reportError(e.getMessage(), (Throwable)e);
            this.m_hasErrors = true;
            this.m_targetInfos.push(new Object());
        }
    }

    public void postVisit(IScanTarget target) {
        if (SystemUtil.isOpenSourceOnly() && !"ThirdPartyLib".equals(target.getName())) {
            return;
        }
        Object obj = this.m_targetInfos.pop();
        if (obj instanceof DOMWriter) {
            DOMWriter writer = (DOMWriter)obj;
            writer.endElement();
            try {
                writer.write(this.m_transformer);
            }
            catch (TransformerException e) {
                target.getErrorManager().reportError(e.getMessage(), (Throwable)e);
                this.m_hasErrors = true;
            }
        }
    }

    public void write() throws TransformerException {
    }

    public boolean hasErrors() {
        return this.m_hasErrors;
    }
}

