/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.file.extension;

import com.ibm.appscan.file.extension.Extension;
import java.io.File;
import java.util.HashMap;

public class ExtensionGroup {
    private HashMap<String, Extension> m_extensions;
    private String m_name;
    private String m_display_name;

    public ExtensionGroup(String name, String display_name) {
        this.m_name = name;
        this.m_display_name = display_name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.m_display_name;
    }

    public HashMap<String, Extension> getExtensions() {
        if (this.m_extensions == null) {
            this.m_extensions = new HashMap();
        }
        return this.m_extensions;
    }

    public void addExtension(Extension e) {
        if (!this.getExtensions().containsKey(e.getExtension())) {
            this.getExtensions().put(e.getExtension(), e);
        }
    }

    public boolean regexApplies(File f) {
        for (Extension e : this.getExtensions().values()) {
            if (!e.regexApplies(f)) continue;
            return true;
        }
        return false;
    }

    public boolean assessApplies(File f) {
        for (Extension e : this.getExtensions().values()) {
            if (!e.assessApplies(f)) continue;
            return true;
        }
        return false;
    }
}

