/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.json;

import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.apache.wink.common.model.json.JSONArray;
import org.apache.wink.common.model.json.JSONException;
import org.apache.wink.common.model.json.JSONObject;
import org.apache.wink.common.model.json.JSONStringer;
import org.apache.wink.common.model.json.JSONWriter;

public abstract class JSONFactory {
    public static final JSONFactory newInstance() {
        String string = System.getProperty("org.apache.wink.common.model.json.factory.impl");
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                return (JSONFactory)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public abstract JSONArray createJSONArray();

    public abstract JSONArray createJSONArray(Collection var1) throws JSONException;

    public abstract JSONArray createJSONArray(Collection var1, boolean var2) throws JSONException;

    public abstract JSONArray createJSONArray(Reader var1) throws JSONException;

    public abstract JSONArray createJSONArray(Object var1) throws JSONException;

    public abstract JSONArray createJSONArray(Object var1, boolean var2) throws JSONException;

    public abstract JSONArray createJSONArray(String var1) throws JSONException;

    public abstract JSONObject createJSONObject();

    public abstract JSONObject createJSONObject(Reader var1) throws JSONException;

    public abstract JSONObject createJSONObject(Map var1) throws JSONException;

    public abstract JSONObject createJSONObject(Map var1, boolean var2) throws JSONException;

    public abstract JSONObject createJSONObject(Object var1) throws JSONException;

    public abstract JSONObject createJSONObject(Object var1, boolean var2) throws JSONException;

    public abstract JSONObject createJSONObject(Object var1, String[] var2) throws JSONException;

    public abstract JSONObject createJSONObject(String var1) throws JSONException;

    public abstract JSONStringer createJSONStringer();

    public abstract JSONWriter createJSONWriter(Writer var1);
}

