/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.cache;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.cache.BaseVdbCache;
import com.ibm.appscan.vdb.cache.CacheProvider;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.util.Date;

public class VdbFactoryCache
extends BaseVdbCache {
    public VdbFactoryCache(Language.LANGUAGE lang) {
        super(lang, VDBEnums.BUCKET.FACTORY);
    }

    @Override
    protected MethodProvider initializeMethodProvider() {
        return new MethodProvider(this.getLanguage(), VDBEnums.BUCKET.FACTORY);
    }

    @Override
    public int addVdb(Vdb v) throws VDBGeneralException {
        Vdb added = new Vdb(v.getLang());
        for (VdbPackage p : v.getPackageMap().values()) {
            Vdb new_vdb = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).getVdb(p.getPackageName());
            for (VdbClass c : p.getClassMap().values()) {
                for (Method method : c.getMethods()) {
                    try {
                        added.addMethod(method);
                        if (new_vdb == null) continue;
                        new_vdb.deleteMethod(method);
                    }
                    catch (BadMarkupException e) {
                        throw new VDBGeneralException(e);
                    }
                }
            }
            if (new_vdb != null) {
                CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).saveVdb(new_vdb);
            }
            CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).addVdb(added);
        }
        if (v.getNonClassFunctions().size() > 0) {
            Vdb ncf_new = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).getNonClassFuncsVdb();
            Vdb merge_added = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).getNonClassFuncsVdb();
            for (Method m : v.getNonClassFunctions().values()) {
                try {
                    ncf_new.deleteMethod(m.getSignature());
                    merge_added.addMethod(m);
                }
                catch (BadMarkupException e) {
                    throw new VDBGeneralException(e);
                }
            }
        }
        Date d = new Date();
        for (VdbPackage p : v.getPackageMap().values()) {
            try {
                Vdb current = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).getVdb(p.getPackageName());
                Vdb before = CacheProvider.getAuditCache(v.getLang()).getBeforeProvider(d).getVdb(p.getPackageName());
                Vdb after = CacheProvider.getAuditCache(v.getLang()).getAfterProvider(d).getVdb(p.getPackageName());
                if (before == null) {
                    before = new Vdb(p.getLang());
                }
                if (after == null) {
                    after = new Vdb(p.getLang());
                }
                if (current == null) {
                    for (VdbClass c : p.getClassMap().values()) {
                        for (Method m : c.getMethods()) {
                            after.addMethod(m);
                        }
                    }
                } else {
                    for (VdbClass c : p.getClassMap().values()) {
                        for (Method m : c.getMethods()) {
                            this.processNewMethod(m, current, before, after);
                        }
                    }
                }
                if (before.getMethods().size() > 0) {
                    CacheProvider.getAuditCache(v.getLang().toString()).getBeforeProvider(d).saveVdb(before);
                }
                if (after.getMethods().size() <= 0) continue;
                CacheProvider.getAuditCache(v.getLang().toString()).getAfterProvider(d).saveVdb(after);
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
        }
        if (v.getNonClassFunctions().size() > 0) {
            Vdb current = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.FACTORY).getNonClassFuncsVdb();
            Vdb before = CacheProvider.getAuditCache(v.getLang().toString()).getBeforeProvider(d).getNonClassFuncsVdb();
            Vdb after = CacheProvider.getAuditCache(v.getLang().toString()).getAfterProvider(d).getNonClassFuncsVdb();
            if (before == null) {
                before = new Vdb(v.getLang());
            }
            if (after == null) {
                after = new Vdb(v.getLang());
            }
            for (Method m : v.getNonClassFunctions().values()) {
                try {
                    if (current == null) {
                        if (!m.isMarkedUp()) continue;
                        after.addMethod(m);
                        continue;
                    }
                    this.processNewMethod(m, current, before, after);
                }
                catch (BadMarkupException badMarkupException) {
                    throw new VDBGeneralException(badMarkupException);
                }
            }
        }
        return super.addVdb(v);
    }

    private void processNewMethod(Method m, Vdb current, Vdb before, Vdb after) throws BadMarkupException {
        Method factory = current.getMethod(m.getSignature());
        if (m.isMarkedUp()) {
            if (factory == null) {
                after.addMethod(m);
            } else if (factory.isMarkedUp()) {
                before.addMethod(factory);
                after.addMethod(m);
            } else {
                after.addMethod(m);
            }
        } else if (factory != null && factory.isMarkedUp()) {
            before.addMethod(factory);
            after.addMethod(m);
        }
    }
}

