/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup;

import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.markup.MarkupBase;
import com.ibm.appscan.vdb.provider.VdbProvider;

public class Property
extends MarkupBase
implements Comparable<Property> {
    private int m_property_id = 0;

    public Property() {
    }

    public Property(String prop) throws BadMarkupException {
        this.setProperty(prop);
    }

    public Property(int id) throws BadMarkupException {
        this.setProperty(Integer.toString(id));
    }

    public void setProperty(String value) throws BadMarkupException {
        try {
            this.m_property_id = VdbProvider.getPropertyProvider().getPropertyId(value);
        }
        catch (VDBGeneralException e) {
            throw new BadMarkupException(e);
        }
        if (this.m_property_id == 0) {
            throw new BadMarkupException("Invalid property used:" + value, new Object[0]);
        }
    }

    public String getProperty() {
        try {
            return VdbProvider.getPropertyProvider().getPropertyFqn(this.m_property_id);
        }
        catch (VDBGeneralException e) {
            e.logException();
            return null;
        }
    }

    public int getPropertyId() {
        return this.m_property_id;
    }

    public boolean isMech() throws VDBGeneralException {
        return VdbProvider.getPropertyProvider().isMechanism(this.m_property_id);
    }

    public boolean isTech() throws VDBGeneralException {
        return VdbProvider.getPropertyProvider().isTechnology(this.m_property_id);
    }

    public boolean isVulnerability() throws VDBGeneralException {
        return VdbProvider.getPropertyProvider().isVulnerability(this.m_property_id);
    }

    public boolean isProperty() throws VDBGeneralException {
        return VdbProvider.getPropertyProvider().isProperty(this.m_property_id);
    }

    public boolean equals(Object obj) {
        Property p = (Property)obj;
        return this.compareTo(p) == 0;
    }

    @Override
    public int compareTo(Property o) {
        if (o == null) {
            return 1;
        }
        if (this.getPropertyId() > o.getPropertyId()) {
            return 1;
        }
        if (this.getPropertyId() < o.getPropertyId()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isValid() throws BadMarkupException {
        this.getProperty();
        return true;
    }

    @Override
    public void reset() {
        this.m_property_id = 0;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof Property) {
            Property p = (Property)artifact;
            this.setProperty(p.getProperty());
        }
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        return false;
    }
}

