/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.misc;

import com.ibm.appscan.vdb.exception.VDBGeneralException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;

public class VdbThreadPool {
    CompletionService<String> m_threadPool;
    private int m_size = Runtime.getRuntime().availableProcessors();
    private int m_submittedTasks;

    public VdbThreadPool() {
        this.init();
    }

    private void init() {
        this.m_threadPool = new ExecutorCompletionService<String>(Executors.newFixedThreadPool(this.m_size));
    }

    public void submit(Runnable runner) {
        this.m_threadPool.submit(runner, "pass");
        ++this.m_submittedTasks;
    }

    public void waitForThreads() throws VDBGeneralException {
        for (int i = 0; i < this.m_submittedTasks; ++i) {
            try {
                this.m_threadPool.take();
                continue;
            }
            catch (InterruptedException e) {
                throw new VDBGeneralException(e, "Error processing thread pool", new Object[0]);
            }
        }
    }
}

