/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.ValidationRoutine;
import com.ibm.appscan.vdb.misc.VDBConstants;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.DataProvider;
import com.ibm.appscan.vdb.provider.data.file.load.RuleReader;
import com.ibm.appscan.vdb.provider.data.file.load.ValidationRoutineHandler;
import com.ibm.appscan.vdb.provider.data.file.load.VdbReader;
import com.ibm.appscan.vdb.provider.data.file.save.PropertyWriter;
import com.ibm.appscan.vdb.provider.data.file.save.RuleFileWriter;
import com.ibm.appscan.vdb.provider.data.file.save.VdbWriter;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class FileDataProvider
extends DataProvider {
    private HashMap<VDBEnums.BUCKET, HashMap<String, String>> m_packages;
    private HashMap<VDBEnums.BUCKET, HashMap<String, String>> m_classes;
    private HashMap<VDBEnums.BUCKET, HashMap<String, String>> m_vdb_files;

    public FileDataProvider(Language.LANGUAGE lang) {
        super(lang);
    }

    @Override
    public Vdb getVdb(VDBEnums.BUCKET bucket, String package_name) throws VDBGeneralException {
        return this.getVdbFromFile(new File(this.getBaseDir(bucket) + this.getPackageFileDir(package_name), this.getPackageFileName(package_name)));
    }

    @Override
    public Vdb getAuditVdb(Date d, VDBEnums.BUCKET bucket, String package_name) throws VDBGeneralException {
        return this.getVdbFromFile(new File(this.getAuditBaseDir(d, bucket) + this.getPackageFileDir(package_name), this.getPackageFileName(package_name)));
    }

    @Override
    public String getPackageFileDir(String package_name) {
        return this.cleanseName(super.getPackageFileDir(this.getPackageName(package_name)));
    }

    protected String getPackageName(String package_name) {
        return package_name;
    }

    @Override
    public String getPackageFileName(String package_name) {
        String name = this.cleanseName(super.getPackageFileName(package_name));
        if (name.endsWith(".vdb")) {
            return name;
        }
        return name + ".vdb";
    }

    private Vdb getVdbFromFile(File f) throws VDBGeneralException {
        if (f.exists()) {
            VdbReader handler;
            try {
                handler = new VdbReader(new FileInputStream(f));
            }
            catch (FileNotFoundException e) {
                throw new VDBGeneralException(e);
            }
            handler.setLanguage(this.getLanguage());
            handler.parse();
            return handler.getVdb();
        }
        return null;
    }

    @Override
    public void saveVdb(VDBEnums.BUCKET bucket, Vdb v) throws VDBGeneralException {
        Vdb save;
        for (VdbPackage p : v.getPackages()) {
            save = new Vdb(v.getLang());
            try {
                save.addPackage(p);
                this.saveVdb(save, new File(this.getBaseDir(bucket) + this.getPackageFileDir(save.getVdbId()), this.getPackageFileName(save.getVdbId())));
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
        }
        for (VdbClass c : v.getClassMap().values()) {
            save = new Vdb(v.getLang());
            try {
                save.addClassVdb(c);
                this.saveVdb(save, new File(this.getBaseDir(bucket) + this.getPackageFileDir(save.getVdbId()), this.getPackageFileName(save.getVdbId())));
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
        }
        Vdb save2 = this.getNonClassFuncsVdb(bucket);
        for (Method m : v.getNonClassFunctions().values()) {
            try {
                save2.addMethod(m);
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
        }
        if (save2.getMethods().size() > 0) {
            this.saveVdb(save2, new File(this.getBaseDir(bucket) + this.getNonClassFuncString()));
        }
    }

    private String cleanseName(String name) {
        StringBuilder ret = new StringBuilder();
        block11: for (char c : name.toCharArray()) {
            switch (c) {
                case '+': {
                    ret.append("_");
                    continue block11;
                }
                case '<': {
                    ret.append("-");
                    continue block11;
                }
                case '>': {
                    ret.append("-");
                    continue block11;
                }
                case '*': {
                    ret.append("-star-");
                    continue block11;
                }
                case '$': {
                    ret.append("dol");
                    continue block11;
                }
                case '@': {
                    ret.append("_at_");
                    continue block11;
                }
                case '?': {
                    ret.append("_quest_");
                    continue block11;
                }
                case '/': {
                    ret.append(File.separator);
                    continue block11;
                }
                case '\\': {
                    ret.append(File.separator);
                    continue block11;
                }
                default: {
                    ret.append(c);
                }
            }
        }
        name = ret.toString();
        if (name.length() > 50) {
            name = name.substring(0, 50);
        }
        return name;
    }

    @Override
    public void saveVdb(VDBEnums.BUCKET bucket, Vdb v, String jobID) throws VDBGeneralException {
        File vdb_root = new File(CommonCore.getDirectoryLocator().getTemp() + File.separator + jobID + ".tmp" + File.separator + "vdb");
        try {
            this.saveProperties(vdb_root);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
        this.saveVdb(v, new File(vdb_root, this.getLanguage().toVdbString().toLowerCase()));
    }

    private void saveVdb(Vdb v, File file) throws VDBGeneralException {
        try {
            if (file.exists()) {
                Vdb orig = VdbProvider.getVdb(file);
                v.merge(orig);
                file.delete();
                file.createNewFile();
            } else {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            VdbWriter writer = new VdbWriter(new FileOutputStream(file));
            writer.writeVdb(v);
        }
        catch (FileNotFoundException e) {
            throw new VDBGeneralException(e);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
    }

    @Override
    public void saveProperties() throws VDBGeneralException {
        try {
            this.saveProperties(new File(CommonCore.getDirectoryLocator().getConfig()));
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
    }

    private void saveProperties(File directory) throws VDBGeneralException, BadMarkupException {
        PropertyWriter writer = new PropertyWriter(directory);
        writer.write();
    }

    @Override
    public void saveAuditVdb(Date d, VDBEnums.BUCKET bucket, Vdb v) throws VDBGeneralException {
        this.saveVdb(v, new File(this.getAuditBaseDir(d, bucket) + this.getPackageFileDir(v.getVdbId()), this.getPackageFileName(v.getVdbId())));
    }

    @Override
    public Vdb getNonClassFuncsVdb(VDBEnums.BUCKET bucket) throws VDBGeneralException {
        return this.getNonClassFuncsVdb(new File(this.getBaseDir(bucket) + this.getNonClassFuncString()));
    }

    @Override
    public Vdb getAuditNonClassFuncsVdb(Date d, VDBEnums.BUCKET bucket) throws VDBGeneralException {
        return this.getNonClassFuncsVdb(new File(this.getAuditBaseDir(d, bucket) + this.getNonClassFuncString()));
    }

    protected Vdb getNonClassFuncsVdb(File f) throws VDBGeneralException {
        if (f.exists()) {
            VdbReader handler;
            try {
                handler = new VdbReader(new FileInputStream(f));
            }
            catch (FileNotFoundException e) {
                throw new VDBGeneralException(e);
            }
            handler.setLanguage(this.getLanguage());
            handler.parse();
            return handler.getVdb();
        }
        return new Vdb(this.getLanguage());
    }

    @Override
    public boolean deletePackage(VDBEnums.BUCKET bucket, String p) {
        if (this.deletePackageFile(new File(this.getBaseDir(bucket) + this.getPackageFileDir(p), this.getPackageFileName(p)))) {
            this.cleanDir(new File(this.getBaseDir(bucket)));
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteAuditPackage(Date d, VDBEnums.BUCKET bucket, VdbPackage p) {
        if (this.deletePackageFile(new File(this.getAuditBaseDir(d, bucket) + this.getPackageFileDir(p.getPackageName()), this.getPackageFileName(p)))) {
            this.cleanDir(new File(this.getAuditBaseDir(d, bucket)));
            return true;
        }
        return false;
    }

    private boolean deletePackageFile(File f) {
        if (f.exists()) {
            f.delete();
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getPackages(VDBEnums.BUCKET bucket) throws VDBException {
        return this.getPackagesMap(bucket).keySet();
    }

    private HashMap<String, String> getPackagesMap(VDBEnums.BUCKET b) throws VDBException {
        if (this.m_packages == null) {
            this.m_packages = new HashMap();
        }
        if (!this.m_packages.containsKey((Object)b)) {
            this.m_packages.put(b, new HashMap());
            for (String key : this.getVdbFiles(b).keySet()) {
                String pack = Method.getPackage(key);
                if (pack == null || pack.length() <= 0) continue;
                this.m_packages.get((Object)b).put(pack, this.getVdbFiles(b).get(key));
            }
        }
        return this.m_packages.get((Object)b);
    }

    protected String getSig(String sig) {
        return sig;
    }

    @Override
    public Set<String> getAuditPackages(Date d, VDBEnums.BUCKET bucket) {
        HashMap packages = new HashMap();
        return packages.keySet();
    }

    @Override
    public Set<String> getClasses(VDBEnums.BUCKET bucket) throws VDBException {
        return this.getClassesMap(bucket).keySet();
    }

    private HashMap<String, String> getClassesMap(VDBEnums.BUCKET b) throws VDBException {
        if (this.m_classes == null) {
            this.m_classes = new HashMap();
        }
        if (!this.m_classes.containsKey((Object)b)) {
            this.m_classes.put(b, new HashMap());
            for (String key : this.getVdbFiles(b).keySet()) {
                String clazz = Method.getClass(key);
                if (clazz == null || clazz.length() <= 0) continue;
                this.m_classes.get((Object)b).put(clazz, this.getVdbFiles(b).get(key));
            }
        }
        return this.m_classes.get((Object)b);
    }

    @Override
    public ArrayList<String> getClassesForPackage(VDBEnums.BUCKET bucket, String package_name) throws VDBGeneralException {
        Vdb v = this.getVdb(bucket, package_name);
        ArrayList<String> classes = new ArrayList<String>();
        if (v != null) {
            for (VdbClass c : v.getClassesVdb()) {
                classes.add(c.getClassName());
            }
        }
        return classes;
    }

    @Override
    public ArrayList<String> getAuditClassesForPackage(Date d, VDBEnums.BUCKET bucket, String package_name) throws VDBGeneralException {
        return new ArrayList<String>();
    }

    @Override
    public ArrayList<String> getMethodsForClass(VDBEnums.BUCKET bucket, String package_name, String class_name) throws VDBGeneralException {
        Vdb v = this.getVdb(bucket, package_name);
        ArrayList<String> methods = new ArrayList<String>();
        if (v != null && v.getClassVdb(class_name) != null) {
            for (Method m : v.getClassVdb(class_name).getMethods()) {
                methods.add(m.getSignature());
            }
        }
        return methods;
    }

    @Override
    public Set<String> getMethods(VDBEnums.BUCKET bucket) throws VDBException {
        return this.getVdbFiles(bucket).keySet();
    }

    private HashMap<String, String> getVdbFiles(VDBEnums.BUCKET b) throws VDBException {
        block12: {
            File cache;
            block13: {
                if (this.m_vdb_files == null) {
                    this.m_vdb_files = new HashMap();
                }
                if (this.m_vdb_files.containsKey((Object)b)) break block12;
                this.m_vdb_files.put(b, new HashMap(300000));
                cache = new File(this.getBaseDir(b), "vdb_cache.oz");
                if (!cache.getParentFile().exists() || !cache.exists()) break block13;
                BufferedReader br = null;
                try {
                    String strLine;
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(cache)));
                    while ((strLine = br.readLine()) != null) {
                        String[] parts = strLine.split("\\|");
                        if (parts.length > 2) {
                            this.m_vdb_files.get((Object)b).put(parts[0], this.getAbsolute(b, parts[2]));
                            continue;
                        }
                        this.m_vdb_files.get((Object)b).put(parts[0], this.getAbsolute(b, parts[1]));
                    }
                }
                catch (IOException e) {
                    try {
                        throw new VDBException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(br);
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable)br);
                break block12;
            }
            this.m_vdb_files.put(b, new HashMap());
            this.processVdbFile(b, new File(this.getBaseDir(b)));
            PrintWriter p = null;
            try {
                cache.getParentFile().mkdirs();
                p = new PrintWriter(cache);
                for (String m : this.m_vdb_files.get((Object)b).keySet()) {
                    p.write(m + "|" + this.getRelativeDir(b, new File(this.m_vdb_files.get((Object)b).get(m))));
                    p.write(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e) {
                try {
                    throw new VDBException(e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(p);
                    throw throwable;
                }
            }
            IOUtil.close((Closeable)p);
        }
        return this.m_vdb_files.get((Object)b);
    }

    private void processVdbFile(VDBEnums.BUCKET b, File dir) throws VDBException {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                this.processVdbFile(b, f);
            }
        }
        if (dir.getPath().endsWith(".vdb")) {
            Vdb v = VdbProvider.getVdb(dir);
            for (Method m : v.getMethods()) {
                if (!m.isMarkedUp()) continue;
                this.m_vdb_files.get((Object)b).put(m.getSignature(), dir.getAbsolutePath());
            }
        }
    }

    private String getRelativeDir(VDBEnums.BUCKET b, File f) {
        return ".\\" + new File(this.getBaseDir(b)).toURI().relativize(f.toURI()).toString().replace("/", "\\");
    }

    private String getAbsolute(VDBEnums.BUCKET b, String file_path) throws VDBException {
        try {
            return PathUtil.getSanitizedFile((String)this.getBaseDir(b), (String)file_path).getAbsolutePath();
        }
        catch (IOException e) {
            throw new VDBException(e);
        }
    }

    @Override
    public ArrayList<String> getAuditMethodsForClass(Date d, VDBEnums.BUCKET bucket, String package_name, String class_name) throws VDBGeneralException {
        Vdb v = this.getAuditVdb(d, bucket, package_name);
        ArrayList<String> methods = new ArrayList<String>();
        if (v != null && v.getClassVdb(class_name) != null) {
            for (Method m : v.getClassVdb(class_name).getMethods()) {
                methods.add(m.getSignature());
            }
        }
        return methods;
    }

    @Override
    public Set<String> getNonClassFunctions(VDBEnums.BUCKET bucket) throws VDBGeneralException {
        Vdb v = this.getNonClassFuncsVdb(bucket);
        HashSet<String> methods = new HashSet<String>();
        if (v != null && v.getNonClassFunctions().size() > 0) {
            for (Method m : v.getNonClassFunctions().values()) {
                methods.add(m.getSignature());
            }
        }
        return methods;
    }

    @Override
    public Set<String> getAuditNonClassFunctions(Date d, VDBEnums.BUCKET bucket) throws VDBGeneralException {
        Vdb v = this.getAuditNonClassFuncsVdb(d, bucket);
        HashSet<String> methods = new HashSet<String>();
        if (v != null && v.getNonClassFunctions().size() > 0) {
            for (Method m : v.getNonClassFunctions().values()) {
                methods.add(m.getSignature());
            }
        }
        return methods;
    }

    @Override
    public void deleteNonClassFuncs(VDBEnums.BUCKET bucket) throws VDBGeneralException {
        this.deletePackageFile(new File(this.getBaseDir(bucket) + this.getNonClassFuncString()));
    }

    @Override
    public void deleteAuditNonClassFuncFile(Date d, VDBEnums.BUCKET bucket) throws VDBGeneralException {
        this.deletePackageFile(new File(this.getAuditBaseDir(d, bucket) + this.getNonClassFuncString()));
    }

    protected String getBaseDir(VDBEnums.BUCKET bucket) {
        return CommonCore.getDirectoryLocator().getVdb() + bucket.toString().toLowerCase() + File.separator + this.getLanguage().toVdbString() + File.separator;
    }

    private String getAuditBaseDir(Date d, VDBEnums.BUCKET bucket) {
        return CommonCore.getDirectoryLocator().getVdb() + "audit" + File.separator + this.getLanguage().toVdbString() + File.separator + VDBConstants.AUDIT_DATE_FORMAT.format(d) + File.separator + bucket.toString().toLowerCase() + File.separator;
    }

    private void cleanDir(File dir) {
        if (dir.isDirectory()) {
            if (dir.listFiles().length == 0) {
                dir.delete();
            } else {
                for (File f : dir.listFiles()) {
                    this.cleanDir(f);
                }
            }
        }
    }

    private String getRuleDir() {
        return CommonCore.getDirectoryLocator().getVdb() + "rules" + File.separator + this.getLanguage().toVdbString() + "_rules.xml";
    }

    @Override
    public Collection<Rule> getRules() throws VDBGeneralException {
        return this.loadRules(new File(this.getRuleDir()));
    }

    private Collection<Rule> loadRules(File file) throws VDBGeneralException {
        if (!file.exists()) {
            return new ArrayList<Rule>();
        }
        if (!file.getPath().endsWith("xml")) {
            return new ArrayList<Rule>();
        }
        RuleReader rh = new RuleReader(file);
        rh.parse();
        return rh.getRules();
    }

    @Override
    public void saveRules(Collection<Rule> rules) throws VDBGeneralException {
        this.saveRules(rules, new File(this.getRuleDir()));
    }

    public void saveRules(Collection<Rule> rules, File file) throws VDBGeneralException {
        RuleFileWriter writer = new RuleFileWriter(file);
        writer.writeRules(rules);
    }

    @Override
    protected void clearBucket_(VDBEnums.BUCKET b) throws VDBGeneralException {
        this.cleanFiles(new File(this.getBaseDir(b)));
    }

    private void cleanFiles(File dir) throws VDBGeneralException {
        if (dir.exists()) {
            if (dir.isDirectory() && dir.exists()) {
                for (File f : dir.listFiles()) {
                    this.cleanFiles(f);
                }
                dir.delete();
            } else if (!dir.delete()) {
                for (int i = 0; i < 10 && !dir.delete(); ++i) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new VDBGeneralException(e);
                    }
                }
            }
        }
    }

    @Override
    public HashMap<String, Vdb> getVdbs(VDBEnums.BUCKET b) throws VDBGeneralException {
        HashMap<String, Vdb> vdbs = new HashMap<String, Vdb>();
        File base = new File(this.getBaseDir(b));
        if (base == null || !base.exists()) {
            return vdbs;
        }
        for (File f : base.listFiles()) {
            try {
                this.cycleFile(f, vdbs, b);
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
        }
        return vdbs;
    }

    private void cycleFile(File d, HashMap<String, Vdb> vdbs, VDBEnums.BUCKET b) throws VDBGeneralException, BadMarkupException {
        block16: {
            Object v;
            VdbReader r;
            block15: {
                if (!d.isDirectory()) break block15;
                for (File f : d.listFiles()) {
                    this.cycleFile(f, vdbs, b);
                }
                break block16;
            }
            try {
                r = new VdbReader(new FileInputStream(d));
            }
            catch (FileNotFoundException e) {
                throw new VDBGeneralException(e);
            }
            r.parse();
            if (r.getVdb() == null) break block16;
            for (VdbPackage p : r.getVdb().getPackages()) {
                if (!vdbs.containsKey(p.getPackageName())) {
                    v = new Vdb(p.getLang());
                    ((Vdb)v).addPackage(p);
                    vdbs.put(p.getPackageName(), (Vdb)v);
                    continue;
                }
                for (Method m : p.getMethods()) {
                    vdbs.get(p.getPackageName()).addMethod(m);
                }
            }
            for (VdbClass c : r.getVdb().getClassMap().values()) {
                if (!vdbs.containsKey(c.getClassName())) {
                    v = new Vdb(c.getLang());
                    ((Vdb)v).addClassVdb(c);
                    vdbs.put(c.getClassName(), (Vdb)v);
                    continue;
                }
                for (Method m : c.getMethods()) {
                    vdbs.get(c.getClassName()).addMethod(m);
                }
            }
            if (r.getVdb().getNonClassFunctions().values().size() > 0) {
                Vdb v2 = null;
                for (Method m : r.getVdb().getMethods()) {
                    if (v2 == null) {
                        if (vdbs.get("nonClassFuncs") == null) {
                            if (this.getNonClassFuncsVdb(b) != null) {
                                vdbs.put("nonClassFuncs", this.getNonClassFuncsVdb(b));
                            } else {
                                v2 = new Vdb(m.getLang());
                                vdbs.put("nonClassFuncs", v2);
                            }
                        }
                        v2 = vdbs.get("nonClassFuncs");
                    }
                    v2.addMethod(m);
                }
            }
        }
    }

    @Override
    public HashMap<String, ValidationRoutine> loadValidationRoutines() {
        File validation_xml = new File(this.getBaseDir(VDBEnums.BUCKET.FACTORY), this.getLanguage().to90String() + "_validation.xml");
        if (validation_xml.exists() && validation_xml.isFile()) {
            try {
                ValidationRoutineHandler loader = new ValidationRoutineHandler(validation_xml, this.getLanguage());
                loader.parse();
                return loader.getValidationRoutines();
            }
            catch (VDBGeneralException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
            catch (FileNotFoundException e) {
                CommonCore.getLogManager().log((Exception)e);
            }
        }
        return new HashMap<String, ValidationRoutine>();
    }
}

