/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.load;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.EnumProvider;
import com.ibm.appscan.vdb.provider.data.file.load.BaseXmlStreamReader;
import com.ibm.appscan.vdb.provider.data.file.load.RuleHandler;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class RuleReader
extends BaseXmlStreamReader {
    private XMLInputFactory m_factory = XMLInputFactory.newInstance();
    private XMLEventReader m_xmlReader;
    private InputStream m_input_stream;
    private Language.LANGUAGE m_lang;
    private ArrayList<Rule> m_rules = new ArrayList();

    public RuleReader(File file) throws VDBGeneralException {
        try {
            this.m_input_stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new VDBGeneralException(e);
        }
    }

    public RuleReader(InputStream input) {
        this.m_input_stream = input;
        this.m_factory.setProperty("javax.xml.stream.supportDTD", false);
        this.m_factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    public void parse() throws VDBGeneralException {
        try {
            this.m_xmlReader = this.m_factory.createFilteredReader(this.m_factory.createXMLEventReader(this.m_input_stream), this);
            this.read(this.m_xmlReader);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new VDBGeneralException(e);
        }
        finally {
            if (this.m_xmlReader != null) {
                try {
                    this.m_xmlReader.close();
                }
                catch (XMLStreamException e) {
                    throw new VDBGeneralException(e);
                }
            }
        }
    }

    @Override
    protected boolean process(StartElement element) {
        if (element.getName().toString().equals("Rules")) {
            this.m_lang = Language.getLanguage((String)this.getAttribute(element, "language"));
        } else if (element.getName().toString().equals("Rule")) {
            RuleHandler handler = new RuleHandler(this.m_xmlReader);
            try {
                Rule r = new Rule(this.getAttribute(element, "name"));
                r.setType(EnumProvider.getRuleType(this.getAttribute(element, "type")));
                handler.setRule(r);
                handler.parse();
                this.m_rules.add(handler.getRule());
            }
            catch (BadRuleException e) {
                e.printStackTrace();
            }
        }
        return super.process(element);
    }

    public Collection<Rule> getRules() {
        return this.m_rules;
    }
}

