/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.method;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.AspMethod;
import com.ibm.appscan.vdb.method.DotNetMethod;
import com.ibm.appscan.vdb.method.JavaMethod;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.NonClassFunction;
import com.ibm.appscan.vdb.method.PhpMethod;
import com.ibm.appscan.vdb.method.UnKnownMethod;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.file.load.VdbReader;
import com.ibm.appscan.vdb.provider.data.file.save.VdbWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class MethodProvider {
    private Language.LANGUAGE m_lang;
    private VDBEnums.BUCKET m_bucket;

    public MethodProvider(Language.LANGUAGE lang, VDBEnums.BUCKET b) {
        this.m_lang = lang;
        this.m_bucket = b;
    }

    public static Method getMethod(Method m) throws VDBException {
        Method ret = MethodProvider.getMethod(m.getSignature(), m.getLang());
        ret.merge(m);
        return ret;
    }

    public static Method getMethod(String sig, Language.LANGUAGE lang) throws VDBException {
        Method m;
        try {
            if (lang == Language.LANGUAGE.UNKNOWN) {
                return new UnKnownMethod(sig);
            }
            m = lang == Language.LANGUAGE.JAVA ? new JavaMethod(sig) : (lang == Language.LANGUAGE.DOT_NET ? new DotNetMethod(sig) : (lang == Language.LANGUAGE.PHP ? new PhpMethod(sig) : (lang == Language.LANGUAGE.ASP ? new AspMethod(sig) : new NonClassFunction(sig, lang))));
        }
        catch (BadMarkupException bme) {
            try {
                m = new NonClassFunction(sig, lang);
            }
            catch (Exception e) {
                throw new VDBException(e);
            }
        }
        return m;
    }

    public void addMethod(Method m) throws VDBGeneralException, BadMarkupException {
        Vdb v = null;
        v = m.getPackageName() != null ? this.getVdb(m.getPackageName()) : this.getNonClassFuncsVdb();
        if (v == null) {
            v = new Vdb(m.getLang());
        }
        v.addMethod(m);
        this.saveVdb(v);
    }

    public VDBEnums.BUCKET getBucket() {
        return this.m_bucket;
    }

    public Language.LANGUAGE getLang() {
        return this.m_lang;
    }

    public Vdb getVdb(VdbPackage p) throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).getVdb(this.getBucket(), p.getPackageName());
    }

    public Vdb getVdbFromVdb(Vdb v) throws VDBGeneralException, BadMarkupException {
        Vdb bucket_vdb;
        Vdb ret = new Vdb(v.getLang());
        for (VdbPackage p : v.getPackageMap().values()) {
            bucket_vdb = VdbProvider.getDataProvider(v.getLang()).getVdb(this.getBucket(), p.getPackageName());
            if (bucket_vdb == null) continue;
            for (Method m : p.getMethods()) {
                if (bucket_vdb.getMethod(m.getSignature()) == null) continue;
                ret.addMethod(bucket_vdb.getMethod(m.getSignature()));
            }
        }
        for (VdbClass c : v.getClassMap().values()) {
            bucket_vdb = VdbProvider.getDataProvider(v.getLang()).getVdb(this.getBucket(), c.getClassName());
            if (bucket_vdb == null) continue;
            for (Method m : c.getMethods()) {
                if (bucket_vdb.getMethod(m.getSignature()) == null) continue;
                ret.addMethod(bucket_vdb.getMethod(m.getSignature()));
            }
        }
        Vdb bucket_vdb2 = VdbProvider.getDataProvider(v.getLang()).getNonClassFuncsVdb(this.getBucket());
        if (bucket_vdb2 != null) {
            for (Method m : v.getMethods()) {
                if (bucket_vdb2.getMethod(m.getSignature()) == null) continue;
                ret.addMethod(bucket_vdb2.getMethod(m.getSignature()));
            }
        }
        for (Method m : v.getMethods()) {
            Method rm = ret.getMethod(m.getSignature());
            if (rm == null) {
                ret.addMethod(m);
                continue;
            }
            rm.merge(m);
        }
        return ret;
    }

    public Vdb getVdb(String package_name) throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).getVdb(this.getBucket(), package_name);
    }

    public Vdb getVdbFromSignatureLog(File f) throws VDBGeneralException {
        if (f.exists()) {
            VdbReader reader;
            try {
                reader = new VdbReader(new FileInputStream(f));
            }
            catch (FileNotFoundException e) {
                throw new VDBGeneralException(e);
            }
            reader.parse();
            return reader.getVdb();
        }
        return null;
    }

    public String getVdbXml(File f) throws VDBGeneralException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            StringBuffer str = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                str.append(line);
                str.append(File.separator);
            }
            String string = str.toString();
            return string;
        }
        catch (IOException e1) {
            throw new VDBGeneralException(e1);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new VDBGeneralException(e);
            }
        }
    }

    public String getVdbXml(Vdb v) throws VDBGeneralException {
        BufferedReader reader = null;
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            VdbWriter writer = new VdbWriter(stream);
            writer.writeVdb(v);
            String string = stream.toString("UTF-8");
            return string;
        }
        catch (IOException e1) {
            throw new VDBGeneralException(e1);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new VDBGeneralException(e);
            }
        }
    }

    public void saveVdb(Vdb v) throws VDBGeneralException {
        VdbProvider.getDataProvider(this.getLang()).saveVdb(this.getBucket(), v);
    }

    public void saveVdb(Vdb v, String jobID) throws VDBGeneralException {
        VdbProvider.getDataProvider(this.getLang()).saveVdb(this.getBucket(), v, jobID);
    }

    public boolean deletePackage(VdbPackage p) throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).deletePackage(this.getBucket(), p.getPackageName());
    }

    public void deleteNcf() throws VDBGeneralException {
        VdbProvider.getDataProvider(this.getLang()).deleteNonClassFuncs(this.getBucket());
    }

    public Vdb getNonClassFuncsVdb() throws VDBGeneralException {
        return VdbProvider.getDataProvider(this.getLang()).getNonClassFuncsVdb(this.getBucket());
    }

    public synchronized void saveSingleVdb(Vdb v, File f) throws VDBGeneralException {
        VdbWriter writer;
        try {
            if (!f.exists() && f.getParentFile() != null) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            } else {
                Vdb current = VdbProvider.getVdb(f);
                if (current != null) {
                    v.merge(current);
                }
                f.delete();
                f.createNewFile();
            }
            writer = new VdbWriter(new FileOutputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new VDBGeneralException(e);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
        writer.writeVdb(v);
    }

    public Set<String> getPackages() throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getPackages(this.getBucket());
    }

    public ArrayList<String> getClassesForPackage(String package_name) throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getClassesForPackage(this.getBucket(), package_name);
    }

    public Set<String> getMethods() throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getMethods(this.getBucket());
    }

    public Set<String> getClasses() throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getClasses(this.getBucket());
    }

    public ArrayList<String> getMethodsForClass(String package_name, String class_name) throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getMethodsForClass(this.getBucket(), package_name, class_name);
    }

    public Set<String> getNonClassFunctions() throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getNonClassFunctions(this.getBucket());
    }

    public HashMap<String, Vdb> getVdbs(VDBEnums.BUCKET b) throws VDBException {
        return VdbProvider.getDataProvider(this.getLang()).getVdbs(b);
    }
}

