/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.analysis.typeInference.TypeVariable;
import com.ibm.wala.cast.analysis.typeInference.AstTypeInference;
import com.ibm.wala.cast.ir.ssa.CAstBinaryOp;
import com.ibm.wala.cast.java.ssa.AstJavaInstructionVisitor;
import com.ibm.wala.cast.java.ssa.AstJavaInvokeInstruction;
import com.ibm.wala.cast.java.ssa.EnclosingObjectReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixpoint.IVariable;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class AstJavaTypeInference
extends AstTypeInference {
    protected IClass stringClass;

    public AstJavaTypeInference(IR ir, IClassHierarchy cha, boolean doPrimitives) {
        super(ir, cha, (TypeAbstraction)JavaPrimitiveType.BOOLEAN, doPrimitives);
    }

    IClass getStringClass() {
        if (this.stringClass == null) {
            this.stringClass = this.cha.lookupClass(TypeReference.JavaLangString);
        }
        return this.stringClass;
    }

    protected void initialize() {
        this.init(this.ir, (SSAInference.VariableFactory)new AstJavaTypeVarFactory(), (SSAInference.OperatorFactory)new AstJavaTypeOperatorFactory());
    }

    public TypeAbstraction getConstantPrimitiveType(int valueNumber) {
        SymbolTable st = this.ir.getSymbolTable();
        if (st.isBooleanConstant(valueNumber)) {
            return this.language.getPrimitive(this.language.getConstantType((Object)Boolean.TRUE));
        }
        return super.getConstantPrimitiveType(valueNumber);
    }

    protected class PrimAndStringOp
    extends TypeInference.PrimitivePropagateOperator {
        private PrimAndStringOp() {
        }

        public byte evaluate(TypeVariable lhs, TypeVariable[] rhs) {
            PointType meet = null;
            for (int i = 0; i < rhs.length; ++i) {
                if (rhs[i] == null) continue;
                TypeVariable r = rhs[i];
                TypeAbstraction ta = r.getType();
                if (ta instanceof PointType) {
                    if (!ta.getType().equals(AstJavaTypeInference.this.getStringClass())) continue;
                    meet = new PointType(ta.getType());
                    break;
                }
                if (!(ta instanceof ConeType) || !ta.getType().equals(AstJavaTypeInference.this.getStringClass())) continue;
                meet = new PointType(ta.getType());
                break;
            }
            if (meet == null) {
                return super.evaluate(lhs, rhs);
            }
            TypeVariable L = lhs;
            TypeAbstraction lhsType = L.getType();
            if (lhsType.equals(meet)) {
                return 0;
            }
            L.setType(meet);
            return 1;
        }

        public int hashCode() {
            return 71292;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass().equals(((Object)((Object)this)).getClass());
        }
    }

    public class AstJavaTypeVarFactory
    extends TypeInference.TypeVarFactory {
        public AstJavaTypeVarFactory() {
            super((TypeInference)AstJavaTypeInference.this);
        }

        public IVariable makeVariable(int valueNumber) {
            SymbolTable st = AstJavaTypeInference.this.ir.getSymbolTable();
            if (st.isStringConstant(valueNumber)) {
                IClass klass = AstJavaTypeInference.this.cha.lookupClass(TypeReference.JavaLangString);
                PointType stringTypeAbs = new PointType(klass);
                return new TypeVariable((TypeAbstraction)stringTypeAbs);
            }
            return super.makeVariable(valueNumber);
        }
    }

    protected class AstJavaTypeOperatorFactory
    extends AstTypeInference.AstTypeOperatorFactory
    implements AstJavaInstructionVisitor {
        protected AstJavaTypeOperatorFactory() {
            super((AstTypeInference)AstJavaTypeInference.this);
        }

        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            if (AstJavaTypeInference.this.doPrimitives) {
                IBinaryOpInstruction.IOperator op = instruction.getOperator();
                this.result = op == CAstBinaryOp.EQ || op == CAstBinaryOp.NE || op == CAstBinaryOp.LT || op == CAstBinaryOp.GE || op == CAstBinaryOp.GT || op == CAstBinaryOp.LE ? new TypeInference.DeclaredTypeOperator((TypeAbstraction)AstJavaTypeInference.this.language.getPrimitive(AstJavaTypeInference.this.language.getConstantType((Object)Boolean.TRUE))) : new PrimAndStringOp();
            }
        }

        @Override
        public void visitEnclosingObjectReference(EnclosingObjectReference inst) {
            TypeReference type = inst.getEnclosingType();
            IClass klass = AstJavaTypeInference.this.cha.lookupClass(type);
            if (klass == null) {
                Assertions.UNREACHABLE();
            } else {
                this.result = new TypeInference.DeclaredTypeOperator((TypeAbstraction)new ConeType(klass));
            }
        }

        @Override
        public void visitJavaInvoke(AstJavaInvokeInstruction instruction) {
            IClass klass;
            TypeReference type = instruction.getDeclaredResultType();
            this.result = type.isReferenceType() ? ((klass = AstJavaTypeInference.this.cha.lookupClass(type)) == null ? new TypeInference.DeclaredTypeOperator(AstJavaTypeInference.this.BOTTOM) : new TypeInference.DeclaredTypeOperator((TypeAbstraction)new ConeType(klass))) : (AstJavaTypeInference.this.doPrimitives && type.isPrimitiveType() ? new TypeInference.DeclaredTypeOperator((TypeAbstraction)PrimitiveType.getPrimitive((TypeReference)type)) : null);
        }
    }
}

