/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common;

import java.util.ArrayList;

public class Language {
    public static LANGUAGE getLanguage(String lang) {
        if (lang != null) {
            for (LANGUAGE l : LANGUAGE.values()) {
                if (!l.getPossibleValues().contains(lang.toLowerCase())) continue;
                return l;
            }
        }
        return LANGUAGE.UNKNOWN;
    }

    public static ArrayList<LANGUAGE> getLanguageArray(String langs) {
        ArrayList<LANGUAGE> languages = new ArrayList<LANGUAGE>();
        if (langs == null) {
            return languages;
        }
        for (String lang : langs.split(";")) {
            if (lang.isEmpty()) continue;
            languages.add(Language.getLanguage(lang));
        }
        return languages;
    }

    public static boolean isDataFlowLang(LANGUAGE lang) {
        return lang == LANGUAGE.JAVA || lang == LANGUAGE.DOT_NET || lang == LANGUAGE.C_PLUS_PLUS;
    }

    public static enum LANGUAGE {
        JAVA{

            public String toString() {
                return "Java";
            }

            @Override
            public String toVdbString() {
                return "java";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(3);
                values.add("java");
                values.add("jsp");
                return values;
            }

            @Override
            public String to90String() {
                return "java";
            }
        }
        ,
        DOT_NET{

            public String toString() {
                return "DotNet";
            }

            @Override
            public String toVdbString() {
                return "dot_net";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(4);
                values.add("dot_net");
                values.add("c_sharp");
                values.add("j_sharp");
                values.add("vbnet");
                values.add(".net_assembly");
                values.add("dotnet");
                values.add(".net");
                return values;
            }

            @Override
            public String to90String() {
                return "c_sharp";
            }
        }
        ,
        COBOL{

            @Override
            public String toVdbString() {
                return "cobol";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("cobol");
                return values;
            }

            @Override
            public String to90String() {
                return "cobol";
            }
        }
        ,
        PHP{

            @Override
            public String toVdbString() {
                return "php";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(3);
                values.add("php");
                return values;
            }

            @Override
            public String to90String() {
                return "php";
            }
        }
        ,
        C_PLUS_PLUS{

            @Override
            public String toVdbString() {
                return "c_plusplus";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(4);
                values.add("c++");
                values.add("managed_c++");
                values.add("cpp");
                values.add("c_plusplus");
                values.add("cplusplus");
                values.add("c_plus_plus");
                return values;
            }

            @Override
            public String to90String() {
                return "c++";
            }
        }
        ,
        OBJECTIVE_C{

            @Override
            public String toVdbString() {
                return "objectivec";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("objectivec");
                values.add("objective_c");
                return values;
            }

            @Override
            public String to90String() {
                return "objectivec";
            }
        }
        ,
        ASP{

            @Override
            public String toVdbString() {
                return "asp";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(4);
                values.add("asp_jscript");
                values.add("asp_vbscript");
                values.add("aspclassic");
                values.add("asp_classic");
                values.add("asp");
                return values;
            }

            @Override
            public String to90String() {
                return "asp_jscript";
            }
        }
        ,
        PBSA{

            @Override
            public String toVdbString() {
                return "pbsa";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("pbsa");
                return values;
            }

            @Override
            public String to90String() {
                return "pbsa";
            }
        }
        ,
        UNKNOWN{

            @Override
            public String toVdbString() {
                return "unknown";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("unknown");
                values.add("general");
                return values;
            }

            @Override
            public String to90String() {
                return "unknown";
            }
        }
        ,
        CUSTOM{

            @Override
            public String toVdbString() {
                return "custom";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("custom");
                return values;
            }

            @Override
            public String to90String() {
                return "custom";
            }
        }
        ,
        JAVASCRIPT{

            @Override
            public String toVdbString() {
                return "javascript";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("javascript");
                values.add("worklight");
                values.add("backbone");
                return values;
            }

            @Override
            public String to90String() {
                return "javascript";
            }
        }
        ,
        NODE_JS{

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>(2);
                values.add("nodejs");
                values.add("node_js");
                return values;
            }

            @Override
            public String to90String() {
                return "nodejs";
            }

            @Override
            public String toVdbString() {
                return "nodejs";
            }
        }
        ,
        ABAP{

            public String toString() {
                return "ABAP";
            }

            @Override
            public String toVdbString() {
                return "abap";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("abap");
                return values;
            }

            @Override
            public String to90String() {
                return "abap";
            }
        }
        ,
        APEX{

            public String toString() {
                return "Apex";
            }

            @Override
            public String toVdbString() {
                return "apex";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("apex");
                return values;
            }

            @Override
            public String to90String() {
                return "apex";
            }
        }
        ,
        ASP_NET{

            public String toString() {
                return "ASP.NET";
            }

            @Override
            public String toVdbString() {
                return "asp.net";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("asp.net");
                return values;
            }

            @Override
            public String to90String() {
                return "asp.net";
            }
        }
        ,
        C{

            public String toString() {
                return "C";
            }

            @Override
            public String toVdbString() {
                return "c";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("c");
                return values;
            }

            @Override
            public String to90String() {
                return "c";
            }
        }
        ,
        COLD_FUSION{

            public String toString() {
                return "ColdFusion";
            }

            @Override
            public String toVdbString() {
                return "coldfusion";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("coldfusion");
                return values;
            }

            @Override
            public String to90String() {
                return "coldfusion";
            }
        }
        ,
        C_SHARP{

            public String toString() {
                return "C#";
            }

            @Override
            public String toVdbString() {
                return "c#";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("c#");
                values.add("csharp");
                values.add("c-sharp");
                return values;
            }

            @Override
            public String to90String() {
                return "c#";
            }
        }
        ,
        CSS{

            public String toString() {
                return "CSS";
            }

            @Override
            public String toVdbString() {
                return "css";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("css");
                return values;
            }

            @Override
            public String to90String() {
                return "css";
            }
        }
        ,
        DART{

            public String toString() {
                return "Dart";
            }

            @Override
            public String toVdbString() {
                return "dart";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("dart");
                return values;
            }

            @Override
            public String to90String() {
                return "dart";
            }
        }
        ,
        GO_LANG{

            public String toString() {
                return "Go";
            }

            @Override
            public String toVdbString() {
                return "GO";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("go");
                return values;
            }

            @Override
            public String to90String() {
                return "GO";
            }
        }
        ,
        GROOVY{

            public String toString() {
                return "Groovy";
            }

            @Override
            public String toVdbString() {
                return "Groovy";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("groovy");
                return values;
            }

            @Override
            public String to90String() {
                return "Groovy";
            }
        }
        ,
        IAC{

            public String toString() {
                return "Infrastructure-As-Code";
            }

            @Override
            public String toVdbString() {
                return "iac";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("iac");
                values.add("infrastructure-as-code");
                return values;
            }

            @Override
            public String to90String() {
                return "iac";
            }
        }
        ,
        IAC_DOCKER{

            public String toString() {
                return "Infrastructure-As-Code-Docker";
            }

            @Override
            public String toVdbString() {
                return "iac_docker";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("iac_docker");
                values.add("infrastructure-as-code-docker");
                return values;
            }

            @Override
            public String to90String() {
                return "iac_docker";
            }
        }
        ,
        IAC_KUBERNETES{

            public String toString() {
                return "Infrastructure-As-Code-Kubernetes";
            }

            @Override
            public String toVdbString() {
                return "iac_kubernetes";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("iac_kubernetes");
                values.add("infrastructure-as-code-kubernetes");
                return values;
            }

            @Override
            public String to90String() {
                return "iac_kubernetes";
            }
        }
        ,
        IAC_TERRAFORM{

            public String toString() {
                return "Infrastructure-As-Code-Terraform";
            }

            @Override
            public String toVdbString() {
                return "iac_terraform";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("iac_terraform");
                values.add("infrastructure-as-code-terraform");
                return values;
            }

            @Override
            public String to90String() {
                return "iac_terraform";
            }
        }
        ,
        ANDROID_JAVA{

            public String toString() {
                return "Android";
            }

            @Override
            public String toVdbString() {
                return "android-java";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("android-java");
                values.add("android");
                return values;
            }

            @Override
            public String to90String() {
                return "android-java";
            }
        }
        ,
        KOTLIN{

            public String toString() {
                return "Kotlin";
            }

            @Override
            public String toVdbString() {
                return "kotlin";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("kotlin");
                return values;
            }

            @Override
            public String to90String() {
                return "kotlin";
            }
        }
        ,
        PERL{

            public String toString() {
                return "Perl";
            }

            @Override
            public String toVdbString() {
                return "perl";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("perl");
                return values;
            }

            @Override
            public String to90String() {
                return "perl";
            }
        }
        ,
        PLSQL{

            public String toString() {
                return "PL/SQL";
            }

            @Override
            public String toVdbString() {
                return "plsql";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("plsql");
                values.add("pl/sql");
                return values;
            }

            @Override
            public String to90String() {
                return "plsql";
            }
        }
        ,
        PYTHON{

            public String toString() {
                return "Python";
            }

            @Override
            public String toVdbString() {
                return "python";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("python");
                return values;
            }

            @Override
            public String to90String() {
                return "python";
            }
        }
        ,
        RPG{

            public String toString() {
                return "RPG";
            }

            @Override
            public String toVdbString() {
                return "rpg";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("rpg");
                return values;
            }

            @Override
            public String to90String() {
                return "rpg";
            }
        }
        ,
        RUBY{

            public String toString() {
                return "Ruby";
            }

            @Override
            public String toVdbString() {
                return "ruby";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("ruby");
                return values;
            }

            @Override
            public String to90String() {
                return "ruby";
            }
        }
        ,
        RUST{

            public String toString() {
                return "Rust";
            }

            @Override
            public String toVdbString() {
                return "rust";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("rust");
                return values;
            }

            @Override
            public String to90String() {
                return "rust";
            }
        }
        ,
        SCALA{

            public String toString() {
                return "Scala";
            }

            @Override
            public String toVdbString() {
                return "scala";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("scala");
                return values;
            }

            @Override
            public String to90String() {
                return "scala";
            }
        }
        ,
        SWIFT{

            public String toString() {
                return "Swift";
            }

            @Override
            public String toVdbString() {
                return "swift";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("swift");
                return values;
            }

            @Override
            public String to90String() {
                return "swift";
            }
        }
        ,
        TSQL{

            public String toString() {
                return "T-SQL";
            }

            @Override
            public String toVdbString() {
                return "tsql";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("tsql");
                values.add("t-sql");
                return values;
            }

            @Override
            public String to90String() {
                return "tsql";
            }
        }
        ,
        ESQL{

            public String toString() {
                return "ESQL";
            }

            @Override
            public String toVdbString() {
                return "esql";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("esql");
                return values;
            }

            @Override
            public String to90String() {
                return "esql";
            }
        }
        ,
        TYPESCRIPT{

            public String toString() {
                return "TypeScript";
            }

            @Override
            public String toVdbString() {
                return "typescript";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("typescript");
                return values;
            }

            @Override
            public String to90String() {
                return "typescript";
            }
        }
        ,
        VB{

            public String toString() {
                return "Visual Basic";
            }

            @Override
            public String toVdbString() {
                return "vb";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("vb");
                values.add("visual basic");
                return values;
            }

            @Override
            public String to90String() {
                return "vb";
            }
        }
        ,
        VB_NET{

            public String toString() {
                return "VB.Net";
            }

            @Override
            public String toVdbString() {
                return "vb.net";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("vb.net");
                return values;
            }

            @Override
            public String to90String() {
                return "vb.net";
            }
        }
        ,
        XAMARIN{

            public String toString() {
                return "Xamarin";
            }

            @Override
            public String toVdbString() {
                return "xamarin";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("xamarin");
                return values;
            }

            @Override
            public String to90String() {
                return "xamarin";
            }
        }
        ,
        ANGULAR{

            public String toString() {
                return "Angular";
            }

            @Override
            public String toVdbString() {
                return "angular";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("angular");
                values.add("angularjs");
                return values;
            }

            @Override
            public String to90String() {
                return "angular";
            }
        }
        ,
        IONIC{

            public String toString() {
                return "Ionic";
            }

            @Override
            public String toVdbString() {
                return "ionic";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("ionic");
                return values;
            }

            @Override
            public String to90String() {
                return "ionic";
            }
        }
        ,
        JQUERY{

            public String toString() {
                return "Jquery";
            }

            @Override
            public String toVdbString() {
                return "jquery";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("jquery");
                return values;
            }

            @Override
            public String to90String() {
                return "jquery";
            }
        }
        ,
        MOOTOOLS{

            public String toString() {
                return "MooTools";
            }

            @Override
            public String toVdbString() {
                return "mootools";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("mootools");
                return values;
            }

            @Override
            public String to90String() {
                return "mootools";
            }
        }
        ,
        REACT{

            public String toString() {
                return "React";
            }

            @Override
            public String toVdbString() {
                return "react";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("react");
                values.add("reactjs");
                return values;
            }

            @Override
            public String to90String() {
                return "react";
            }
        }
        ,
        REACT_NATIVE{

            public String toString() {
                return "React-Native";
            }

            @Override
            public String toVdbString() {
                return "react_native";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("react_native");
                values.add("react-native");
                values.add("reactnative");
                return values;
            }

            @Override
            public String to90String() {
                return "react_native";
            }
        }
        ,
        VUE_JS{

            public String toString() {
                return "VueJS";
            }

            @Override
            public String toVdbString() {
                return "vue_js";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("vue_js");
                values.add("vuejs");
                values.add("vue.js");
                return values;
            }

            @Override
            public String to90String() {
                return "vue_js";
            }
        }
        ,
        SECRETS{

            public String toString() {
                return "Secrets";
            }

            @Override
            public String toVdbString() {
                return "secrets";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("secrets");
                return values;
            }

            @Override
            public String to90String() {
                return "secrets";
            }
        }
        ,
        HTML{

            public String toString() {
                return "HTML";
            }

            @Override
            public String toVdbString() {
                return "html";
            }

            @Override
            public ArrayList<String> getPossibleValues() {
                ArrayList<String> values = new ArrayList<String>();
                values.add("html");
                return values;
            }

            @Override
            public String to90String() {
                return "html";
            }
        };


        public abstract ArrayList<String> getPossibleValues();

        public abstract String to90String();

        public abstract String toVdbString();
    }
}

