/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.internal.common.model.BuildInfoProxy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Manifest;

public class ClasspathBuilder {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String CLASS_PATH = "Class-Path";
    private IScanTargetMinProxy m_proxy;
    private Set<String> m_paths = new LinkedHashSet<String>();
    private int m_size;

    public ClasspathBuilder(IScanTargetMinProxy proxy) {
        this.m_proxy = proxy;
        IBuildInfo info = this.m_proxy.getBuildInfo();
        if (info instanceof BuildInfoProxy) {
            info = ((BuildInfoProxy)info).getInnerBuildInfo();
        }
        this.appendToClasspath(info.getProperty("classpath"));
        this.m_size = this.m_paths.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest readManifest(File file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            Manifest manifest = new Manifest(is);
            IOUtil.close(is);
            return manifest;
        }
        catch (IOException e) {
            Manifest manifest = null;
            return manifest;
        }
        finally {
            IOUtil.close(is);
        }
    }

    private boolean appendToClasspath(Manifest manifest, String relativeTo) {
        boolean appended = false;
        String obj = manifest.getMainAttributes().getValue(CLASS_PATH);
        if (obj != null) {
            String[] paths;
            for (String relPath : paths = obj.toString().split("\\s+")) {
                if (relPath.isEmpty()) continue;
                this.m_paths.add(PathUtil.makeAbsolute(relPath, relativeTo));
                appended = true;
            }
        }
        return appended;
    }

    public boolean appendToClasspath(File directory, String relativeTo) {
        Manifest manifest;
        File manifestFile = new File(directory, MANIFEST_PATH);
        if (manifestFile.exists() && (manifest = this.readManifest(manifestFile)) != null) {
            return this.appendToClasspath(manifest, relativeTo);
        }
        return false;
    }

    public void appendToClasspath(String value, boolean prepend) {
        if (value == null) {
            return;
        }
        Set<String> paths = ClasspathBuilder.resolve(null, value);
        if (paths.isEmpty()) {
            return;
        }
        if (prepend) {
            paths.addAll(this.m_paths);
            this.m_paths = paths;
        } else {
            this.m_paths.addAll(paths);
        }
    }

    public void appendToClasspath(String value) {
        this.appendToClasspath(value, false);
    }

    public void commit() {
        int size = this.m_paths.size();
        if (this.m_size < size) {
            LinkedHashSet<String> userJars = new LinkedHashSet<String>();
            LinkedHashSet<String> deprecatedEEJars = new LinkedHashSet<String>();
            for (String path : this.m_paths) {
                if (ClasspathBuilder.isDeprecatedEEJar(path)) {
                    deprecatedEEJars.add(path);
                    continue;
                }
                userJars.add(path);
            }
            userJars.addAll(deprecatedEEJars);
            this.m_proxy.getBuildInfo().setProperty("classpath", ClasspathBuilder.combine(userJars).substring(1));
            this.m_size = size;
        }
    }

    private static boolean isDeprecatedEEJar(String path) {
        String normalized = path.replace(File.separator, "/").toLowerCase();
        return normalized.contains("/jre/ee/");
    }

    static Set<String> resolve(String relativeTo, String ... values) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String value : values) {
            if (value == null) continue;
            for (String path : value.split(File.pathSeparator)) {
                String parentPath;
                if ((path = path.trim()).isEmpty()) continue;
                if (!path.endsWith("*")) {
                    parentPath = PathUtil.makeAbsolute(path, relativeTo);
                    set.add(parentPath);
                } else {
                    parentPath = PathUtil.makeAbsolute(path.substring(0, path.length() - 1), relativeTo);
                }
                File[] files = new File(parentPath).listFiles();
                if (files == null) continue;
                for (File file : files) {
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    set.add(file.getAbsolutePath());
                }
            }
        }
        return set;
    }

    static StringBuffer combine(Set<String> paths) {
        StringBuffer buffer = new StringBuffer();
        for (String path : paths) {
            buffer.append(File.pathSeparator).append(path);
        }
        return buffer;
    }
}

