/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.functional.ThrowableBox;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DirectoryUtil {
    private Set<String> m_directories = new LinkedHashSet<String>();

    private DirectoryUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalWalk(File directory, TreeVisitor visitor) throws IOException {
        if (!this.m_directories.add(directory.getCanonicalPath()) || !visitor.preVisitDirectory(directory)) {
            return true;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            CommonCore.getLogManager().log(new Message(2, directory.getName() + " is not readable."));
            files = new File[]{};
        }
        for (File file : files) {
            if (file.isDirectory()) {
                visitor.m_segments.push(file.getName());
                try {
                    if (this.internalWalk(file, visitor)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    visitor.m_segments.pop();
                }
            }
            if (visitor.internalVisitFile(file)) continue;
            return false;
        }
        return visitor.postVisitDirectory(directory);
    }

    public static void walk(File input, TreeVisitor visitor) throws IOException {
        if (input.isDirectory()) {
            new DirectoryUtil().internalWalk(input, visitor);
        } else {
            visitor.internalVisitFile(input);
        }
    }

    public static void delete(File input) throws IOException {
        final ThrowableBox firstException = new ThrowableBox();
        DirectoryUtil.walk(input, new TreeVisitor(){

            private void deleteIt(File target) throws IOException {
                if (!target.delete()) {
                    IOException e = new IOException(Messages.getMessage("failed.to.delete", target));
                    CommonCore.getLogManager().log(e);
                    firstException.setIfEmpty(e);
                }
            }

            @Override
            protected boolean visitFile(File file) throws IOException {
                this.deleteIt(file);
                return true;
            }

            @Override
            protected boolean postVisitDirectory(File directory) throws IOException {
                this.deleteIt(directory);
                return true;
            }
        });
        firstException.throwIfPresent();
    }

    public static File[] getFiles(File directory, String dotExtension) {
        final String ext = dotExtension.toLowerCase();
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(ext);
            }
        });
        return files == null ? new File[]{} : files;
    }

    public static File[] getMatchingFiles(File directory, String filename) {
        final String searchString = filename;
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(searchString);
            }
        });
        return files == null ? new File[]{} : files;
    }

    public static List<File> listFiles(File root) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    fileList.addAll(DirectoryUtil.listFiles(files[i]));
                    continue;
                }
                fileList.add(files[i]);
            }
        }
        return fileList;
    }

    public static class TreeVisitor {
        private LinkedList<String> m_segments = new LinkedList();
        private String m_currentFile = "";

        protected final String getCurrentPath() {
            StringBuffer buffer = new StringBuffer();
            for (int i = this.m_segments.size() - 1; i >= 0; --i) {
                buffer.append(this.m_segments.get(i)).append('/');
            }
            return buffer.append(this.m_currentFile).toString();
        }

        protected boolean preVisitDirectory(File directory) throws IOException {
            return true;
        }

        protected boolean visitFile(File file) throws IOException {
            return true;
        }

        protected boolean postVisitDirectory(File directory) throws IOException {
            return true;
        }

        private boolean internalVisitFile(File file) throws IOException {
            this.m_currentFile = file.getName();
            try {
                boolean bl = this.visitFile(file);
                return bl;
            }
            finally {
                this.m_currentFile = "";
            }
        }
    }
}

