/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.security.annotation.ValidatorMethod;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String SUFFIX = "...";
    private static final Pattern ESCAPED_UNICODE = Pattern.compile("\\\\u(\\p{XDigit}{4})");
    private static final Pattern UUID = Pattern.compile("^[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}$");
    public static final String S_OZINFO = "<ozinfo>";
    public static final String S_OZWARN = "<ozwarn>";
    public static final String S_OZTRACE = "<oztrace>";
    public static final String S_OZERROR = "<ozerr>";
    public static final String S_OZDEBUG = "<ozdebug>";
    public static final String S_OZIPVA = "<ozipva>";
    public static final String S_OZSCAN = "<ozscan>";
    public static final String S_OZMSG = "<ozmsg>";
    public static final String E_OZINFO = "</ozinfo>";
    public static final String E_OZWARN = "</ozwarn>";
    public static final String E_OZTRACE = "</oztrace>";
    public static final String E_OZERROR = "</ozerr>";
    public static final String E_OZDEBUG = "</ozdebug>";
    public static final String E_OZIPVA = "</ozipva>";
    public static final String E_OZSCAN = "</ozscan>";
    public static final String E_OZMSG = "</ozmsg>";
    public static final String[] S_TAGS = new String[]{"<ozinfo>", "<ozwarn>", "<oztrace>", "<ozerr>", "<ozdebug>", "<ozipva>", "<ozscan>", "<ozmsg>"};
    public static final String[] E_TAGS = new String[]{"</ozinfo>", "</ozwarn>", "</oztrace>", "</ozerr>", "</ozdebug>", "</ozipva>", "</ozscan>", "</ozmsg>"};

    public static String shortenString(String str, int length, String suffix) {
        if (str.length() > length) {
            str = str.substring(0, length - suffix.length()) + suffix;
        }
        return str;
    }

    public static String shortenString(String str, int length) {
        return StringUtil.shortenString(str, length, SUFFIX);
    }

    public static String unescapeUnicode(String str) {
        StringBuffer sb = new StringBuffer();
        Matcher m = ESCAPED_UNICODE.matcher(str);
        while (m.find()) {
            m.appendReplacement(sb, (char)Integer.parseInt(m.group(1), 16) + "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @ValidatorMethod
    public static String getCleanXml(String string) {
        StringBuffer str = new StringBuffer();
        block7: for (char c : string.toCharArray()) {
            switch (c) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block7;
                }
                default: {
                    str.append(c);
                }
            }
        }
        return str.toString();
    }

    public static char[] getCharsFromStringBuilder(StringBuilder str) {
        char[] ret = new char[str.length()];
        str.getChars(0, str.length(), ret, 0);
        return ret;
    }

    @ValidatorMethod
    public static String getCleanUuid(String uuid) throws AppScanException {
        if (UUID.matcher(uuid.toLowerCase()).matches()) {
            return uuid;
        }
        throw new AppScanException(Messages.getMessage("err.invalid.uuid", uuid));
    }

    public static boolean containsTags(String message) {
        for (String tag : S_TAGS) {
            if (!message.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public static String normalizeMessage(String message) {
        if (message != null) {
            message = message.replaceAll("\f", "\n");
        }
        return message;
    }

    public static String tagMessage(String message, int severity) {
        if (message != null && SystemUtil.isCommonEngine() && !StringUtil.containsTags(message = StringUtil.normalizeMessage(message))) {
            if (message.endsWith("\n")) {
                message = message.substring(0, message.length() - 1);
            }
            message = severity == 2 ? S_OZWARN + message + E_OZWARN : (severity == 4 ? S_OZERROR + message + E_OZERROR : (severity == 5 ? S_OZIPVA + message + E_OZIPVA : (severity == 6 ? S_OZSCAN + message + E_OZSCAN : S_OZMSG + message + E_OZMSG)));
        }
        return message;
    }

    public static String untagMessage(String message) {
        if (message != null && SystemUtil.isCommonEngine()) {
            message = StringUtil.normalizeMessage(message);
            message = message.replace(S_OZINFO, "").replace(E_OZINFO, "");
            message = message.replace(S_OZWARN, "").replace(E_OZWARN, "");
            message = message.replace(S_OZERROR, "").replace(E_OZERROR, "");
            message = message.replace(S_OZTRACE, "").replace(E_OZTRACE, "");
            message = message.replace(S_OZDEBUG, "").replace(E_OZDEBUG, "");
            message = message.replace(S_OZIPVA, "").replace(E_OZIPVA, "");
            message = message.replace(S_OZSCAN, "").replace(E_OZSCAN, "");
            message = message.replace(S_OZMSG, "").replace(E_OZMSG, "");
        }
        return message;
    }
}

