/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.FipsUtil;
import com.ibm.appscan.common.utils.ServerUtil;
import com.ibm.appscan.common.utils.VersionUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.Scanner;

public class SystemUtil {
    public static final String PROP_DEV_DEBUG = "devDebug";
    public static final String PROP_DEBUG = "DEBUG";
    public static final String PROP_DELETE_IRX = "DELETE_IRX";
    public static final String PROP_DISPLAY_ASMNT = "DISPLAY_ASMNT";
    public static final String PROP_IPVA_FORMAT = "IPVA_FORMAT";
    public static final String PROP_JDK = "alternateJDK";
    public static final String PROP_NOCLEANING = "noCleaning";
    public static final String PROP_NOENCRYPT = "NO_ENCRYPT";
    public static final String PROP_DISABLE_SECRETS = "DISABLE_SECRETS";
    public static final String PROP_ENABLE_SECRETS = "ENABLE_SECRETS";
    public static final String PROP_SECRETS_ONLY = "SECRETS_ONLY";
    public static final String PROP_NO_CONFIG_FILES = "NO_CONFIG_FILES";
    public static final String PROP_DISABLE_GIT_DISCOVERY = "DISABLE_GIT_DISCOVERY";
    public static final String PROP_SHOW_PROGRESS = "show-progress";
    public static final String PROP_THIRDPARTY = "thirdParty";
    public static final String PROP_DRYRUN = "dryRun";
    public static final String PROP_INTERNAL_SERVER = "INTERNAL_SERVER";
    public static final String PROP_BLUEMIX_SERVER = "BLUEMIX_SERVER";
    public static final String PROP_SCAN_HOME = "scanHomeDirectory";
    public static final String PROP_SCAN_SPEED = "scan_speed";
    public static final String APPSCAN_OPTS = "APPSCAN_OPTS";
    public static final String PROP_NODEJS = "NODEJS";
    public static final String PROP_WHATSNEW = "WHATSNEW";
    public static final String USE_STAGER = "USE_STAGER";
    public static final String USE_SLICER = "USE_SLICER";
    public static final String DISABLE_CACHE = "DISABLE_CACHE";
    public static final String APPSCAN_IRGEN_CLIENT = "APPSCAN_IRGEN_CLIENT";
    public static final String APPSCAN_CLIENT_VERSION = "APPSCAN_CLIENT_VERSION";
    public static final String IRGEN_CLIENT_PLUGIN_VERSION = "IRGEN_CLIENT_PLUGIN_VERSION";
    public static final String PROP_OPEN_SOURCE_ENGINE = "openSourceEngine";
    public static final String PROP_SEND_TO_SCA = "sendToSCA";
    public static final String PROP_SCA_API_IP = "SCA_api_ip";
    public static final String PROP_SCA_WS_API_IP = "SCA_ws_api_ip";
    public static final String PROP_SCA_SUBSCRIPTION_KEY = "SCA_subscription_key";
    public static final String PROP_WS_DUMP_JSON_TO_FILE = "ws_dump_json_to_file";
    public static final String PROP_WS_JSON_FILE_LOCATION = "ws_json_file_location";
    public static final String PROP_ACCEPTSSL = "acceptssl";
    public static final String PROP_APPSCAN_AGENT_JOBID = "APPSCAN_AGENT_JOBID";
    public static final String PROP_SAST_AGENT = "SASTAGENT";
    public static final String UNKNOWN_PROPERTY = "unknown";
    public static final String PROP_USE_NEW_FRONTEND = "NewDotNetEngine";
    public static final String PROP_CLOUD_ENGINE = "cloudEngine";
    public static final String PROP_CLOUD_ENGINE_URL = "cloudEngineUrl";
    public static final String PROP_CLOUD_ENGINE_LANGUAGES = "cloudEngineLanguages";
    public static final String PROP_CLOUD_ENGINE_SLEEP = "cloudEngineSleep";
    public static final String PROP_CLOUD_ENGINE_RETRIES = "cloudEngineRetries";
    public static final String PROP_CLOUD_ENGINE_CHAINING = "cloudEngineChaining";
    public static final String PROP_CLOUD_ENGINE_ENABLE_BETA = "cloudEngineBeta";
    public static final String PROP_CLOUD_ENGINE_BETA_URL = "cloudEngineBetaUrl";
    public static final String PROP_CLOUD_ENGINE_BETA_LANGUAGES = "cloudEngineBetaLanguages";
    public static final String PROP_CLOUD_IRGEN = "CLOUD_IRGEN";
    public static final String ML_SERVICES_NAMESPACE = "ML_SERVICES_NAMESPACE";
    public static final String ML_SERVICES_DEBUG_ENDPOINT = "ML_SERVICES_DEBUG_ENDPOINT";
    public static final String DISABLE_IFA = "DISABLE_IFA";
    public static final String IFA_TRACE_ENDPOINT = "IFA_TRACE_ENDPOINT";
    public static final String DISABLE_ICA = "DISABLE_ICA";
    public static final String ENABLE_ICA2 = "ENABLE_ICA2";
    public static final String ENABLE_ICA2_LIVE_MON = "ENABLE_ICA2_LIVE_MON";
    private static final String SERIAL_NUMBER = "Serial Number";
    private static final String UUID = "UUID";
    private static final String REGKEY_MACHINE_GUID = "MachineGuid";
    private static final String[] CMD_MAC_SYSTEM_PROFILER = new String[]{"/usr/sbin/system_profiler", "SPHardwareDataType"};
    private static final String CMD_LINUX_LSHAL_SERIALNUMBER = "lshal | grep -i system.hardware.serial";
    private static final String CMD_LINUX_LSHAL_UUID = "lshal | grep -i system.hardware.uuid";
    public static final String PROP_OPENSOURCE_ONLY = "OPENSOURCE_ONLY";
    public static final String PROP_SOURCE_CODE_ONLY = "SOURCE_CODE_ONLY";
    public static final String PROP_STATIC_ANALYSIS_ONLY = "STATIC_ANALYSIS_ONLY";
    private static final String WINDOWS = "windows";
    private static final String MAC = "mac";
    private static final String LINUX = "linux";
    private static final String UNKNOWN_OS = "unknown";
    private static String m_irGenClientName = "";
    public static final String UNZIP_DIR = "unzipDir";
    public static final String IRX_LOCATION = "IRX_LOCATION";
    public static final String IRX_NAME = "IRX_NAME";
    public static final String[] SUPPORTED_ARCHIVES = new String[]{"zip", "war", "ear", "jar"};
    private static final String EXEC_ENV = "SAST_EXECUTION_ENV";
    public static final String APPSCAN360 = "AppScan360";
    public static final String UPDATE_INTERVAL = "UPDATE_SERVER_INTERVAL";
    private static boolean FIPS_ENABLED = false;

    public static boolean doCloudEngine() {
        return SystemUtil.isPropertyPopulated(PROP_CLOUD_ENGINE_URL) && SystemUtil.defaultFalseProperty(PROP_CLOUD_ENGINE);
    }

    public static boolean doCloudEngineBeta() {
        return SystemUtil.defaultFalseProperty(PROP_CLOUD_ENGINE_ENABLE_BETA) && SystemUtil.isPropertyPopulated(PROP_CLOUD_ENGINE_BETA_URL) && SystemUtil.isPropertyPopulated(PROP_CLOUD_ENGINE_BETA_LANGUAGES);
    }

    public static boolean isSupportedArchive(String file) {
        return Arrays.asList(SUPPORTED_ARCHIVES).contains(FileUtil.getFileExtension(file));
    }

    public static boolean isIfaEnabled() {
        return SystemUtil.isDisablePropertyNotSet(DISABLE_IFA);
    }

    public static Optional<String> getIfaTraceEndpoint() {
        return Optional.ofNullable(System.getProperty(IFA_TRACE_ENDPOINT));
    }

    public static boolean isIcaEnabled() {
        return SystemUtil.isDisablePropertyNotSet(DISABLE_ICA);
    }

    public static boolean isSupportedArchive(File file) {
        return Arrays.asList(SUPPORTED_ARCHIVES).contains(FileUtil.getFileExtension(file));
    }

    public static boolean shouldDeleteFiles() {
        return !SystemUtil.isPropertySet(PROP_NOCLEANING);
    }

    public static boolean shouldDeleteScanFile() {
        return SystemUtil.isPropertySet(PROP_DELETE_IRX);
    }

    public static boolean shouldDisplayAsmnt() {
        return SystemUtil.isPropertySet(PROP_DISPLAY_ASMNT);
    }

    public static boolean shouldAcceptSSL() {
        return SystemUtil.isPropertySet(PROP_ACCEPTSSL);
    }

    public static boolean isCloudIRGen() {
        return SystemUtil.isPropertySet(PROP_CLOUD_IRGEN) && SystemUtil.defaultTrueProperty(PROP_CLOUD_IRGEN);
    }

    public static boolean isOpenSourceOnly() {
        return SystemUtil.isPropertySet(PROP_OPENSOURCE_ONLY);
    }

    public static boolean isSourceCodeOnly() {
        return SystemUtil.isPropertySet(PROP_SOURCE_CODE_ONLY) || SystemUtil.isSecretsOnly();
    }

    public static boolean isStaticAnalysisOnly() {
        return SystemUtil.isPropertySet(PROP_STATIC_ANALYSIS_ONLY) || SystemUtil.isPropertySet(PROP_SECRETS_ONLY);
    }

    public static void setSourceCodeOnly() {
        System.setProperty(PROP_SOURCE_CODE_ONLY, "true");
    }

    public static void setStaticAnalysisOnly() {
        System.setProperty(PROP_STATIC_ANALYSIS_ONLY, "true");
    }

    public static void disableProcessingConfigFiles() {
        System.setProperty(PROP_NO_CONFIG_FILES, "true");
    }

    public static void enableSecretsScanning() {
        System.setProperty(PROP_ENABLE_SECRETS, "true");
        System.clearProperty(PROP_DISABLE_SECRETS);
    }

    public static void disableSecretsScanning() {
        System.setProperty(PROP_DISABLE_SECRETS, "true");
        System.clearProperty(PROP_ENABLE_SECRETS);
    }

    public static boolean isSecretsScanningDisabled() {
        return SystemUtil.isPropertySet(PROP_DISABLE_SECRETS);
    }

    public static boolean isSecretsScanningEnabled() {
        return SystemUtil.isPropertySet(PROP_ENABLE_SECRETS);
    }

    public static boolean isSecretsOnly() {
        return System.getProperty(PROP_SECRETS_ONLY) != null;
    }

    public static void setSecretsOnly() {
        System.setProperty(PROP_SECRETS_ONLY, "true");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isDevDebug() {
        return SystemUtil.isPropertySet(PROP_DEV_DEBUG);
    }

    public static boolean isDebug() {
        return SystemUtil.isPropertySet(PROP_DEBUG);
    }

    public static boolean shouldEncrypt() {
        return !SystemUtil.isPropertySet(PROP_NOENCRYPT);
    }

    public static boolean shouldShowProgress() {
        return SystemUtil.isPropertySet(PROP_SHOW_PROGRESS);
    }

    public static boolean isThirdParty() {
        return SystemUtil.isPropertySet(PROP_THIRDPARTY) && SystemUtil.defaultTrueProperty(PROP_THIRDPARTY);
    }

    public static boolean isDryRun() {
        return SystemUtil.isPropertySet(PROP_DRYRUN);
    }

    public static boolean isDevelopment() {
        return SystemUtil.isPropertySet(PROP_INTERNAL_SERVER);
    }

    public static boolean useStagerForJavaFiles() {
        return SystemUtil.defaultTrueProperty(USE_STAGER);
    }

    public static boolean useSlicerForJavaFiles() {
        return SystemUtil.useStagerForJavaFiles() && CommonCore.getConfiguration().getSettingValueBooleanDefaultTrue(USE_SLICER) && SystemUtil.defaultTrueProperty(USE_SLICER);
    }

    public static boolean useCacheForSlicer() {
        return SystemUtil.isDisablePropertyNotSet(DISABLE_CACHE);
    }

    public static boolean is360() {
        return !ServerUtil.getServerUrl().startsWith("https://cloud.appscan.com");
    }

    public static boolean isCommonEngine() {
        String _val = System.getenv("CE");
        return _val != null && _val.equalsIgnoreCase("true");
    }

    public static String getInternalServer() {
        return System.getProperty(PROP_INTERNAL_SERVER);
    }

    public static String getExternalServer() {
        return System.getProperty(PROP_BLUEMIX_SERVER);
    }

    public static String getIPVAFormat() {
        return System.getProperty(PROP_IPVA_FORMAT);
    }

    public static void setIRGenClient(String client) {
        m_irGenClientName = client;
    }

    public static String getDefaultScanHome() {
        return System.getProperty(PROP_SCAN_HOME);
    }

    public static String getIRGenClient() {
        if (System.getenv(APPSCAN_IRGEN_CLIENT) != null) {
            m_irGenClientName = System.getenv(APPSCAN_IRGEN_CLIENT);
        }
        for (IRGenClient client : IRGenClient.values()) {
            if (!client.name().equalsIgnoreCase(m_irGenClientName)) continue;
            return client.toString();
        }
        return IRGenClient.CLI.name();
    }

    public static char[] getClientType() {
        StringBuilder sb = new StringBuilder();
        sb.append(SystemUtil.getIRGenClient().toLowerCase());
        sb.append("-");
        if (SystemUtil.isWindows()) {
            sb.append(WINDOWS);
        } else if (SystemUtil.isMac()) {
            sb.append(MAC);
        } else if (SystemUtil.isLinux()) {
            sb.append(LINUX);
        } else {
            sb.append("unknown");
        }
        String version = SystemUtil.getClientVersion();
        if (version != null) {
            sb.append("-" + version.replaceAll("[^A-Za-z0-9\\.]", ""));
        }
        return sb.toString().toCharArray();
    }

    public static String getClientVersion() {
        String version = null;
        if (IRGenClient.AppScanGo.name().equalsIgnoreCase(System.getenv(APPSCAN_IRGEN_CLIENT))) {
            version = System.getenv(APPSCAN_CLIENT_VERSION);
        } else if (IRGenClient.CLI.name().equalsIgnoreCase(System.getenv(APPSCAN_IRGEN_CLIENT))) {
            version = VersionUtil.getLocalToolsVersion();
        } else if (System.getenv(IRGEN_CLIENT_PLUGIN_VERSION) != null) {
            version = System.getenv(IRGEN_CLIENT_PLUGIN_VERSION);
        }
        return version;
    }

    public static String getSastExecutionEnv() {
        return System.getenv(EXEC_ENV);
    }

    public static int getUpdateServerInterval() {
        if (System.getenv(UPDATE_INTERVAL) != null && !System.getenv(UPDATE_INTERVAL).isEmpty()) {
            return Integer.parseInt(System.getenv(UPDATE_INTERVAL));
        }
        return 60;
    }

    @SuppressSecurityTrace
    public static void setSystemProperties() {
        String opts = System.getenv(APPSCAN_OPTS);
        if (opts != null && !opts.isEmpty()) {
            String[] properties;
            for (String property : properties = opts.split(" ")) {
                String[] prop;
                if (property == null || property.trim().length() == 0) continue;
                if (property.startsWith("-D")) {
                    property = property.substring(2);
                }
                if ((prop = property.split("=")).length == 2) {
                    System.setProperty(prop[0], prop[1]);
                    continue;
                }
                System.setProperty(property, "");
            }
        }
        if (System.getProperty(PROP_BLUEMIX_SERVER) == null) {
            System.setProperty(PROP_BLUEMIX_SERVER, "https://cloud.appscan.com");
        }
    }

    public static boolean analyzeNodejs() {
        return SystemUtil.isPropertySet(PROP_NODEJS);
    }

    public static boolean displayWhatsNew() {
        return SystemUtil.isPropertySet(PROP_WHATSNEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressSecurityTrace
    public static String getMachineSerialNumber() {
        String serialNumber;
        block11: {
            serialNumber = "";
            try (Scanner sc = null;){
                if (SystemUtil.isWindows()) {
                    Process process = Runtime.getRuntime().exec(new String[]{"wmic", "bios", "get", "serialnumber"});
                    sc = new Scanner(process.getInputStream());
                    if (sc.hasNext()) {
                        serialNumber = sc.next();
                    }
                    if (sc.hasNext()) {
                        serialNumber = sc.next();
                    }
                    break block11;
                }
                if (SystemUtil.isMac()) {
                    Process process = Runtime.getRuntime().exec(CMD_MAC_SYSTEM_PROFILER);
                    sc = new Scanner(process.getInputStream());
                    sc.useDelimiter(System.getProperty("line.separator"));
                    while (sc.hasNextLine()) {
                        String line = sc.nextLine();
                        if (!line.contains(SERIAL_NUMBER)) continue;
                        serialNumber = line.split(":")[1].trim();
                        break block11;
                    }
                    break block11;
                }
                Process process = Runtime.getRuntime().exec(CMD_LINUX_LSHAL_SERIALNUMBER);
                sc = new Scanner(process.getInputStream());
                if (sc.hasNext()) {
                    serialNumber = sc.next();
                }
            }
        }
        return serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressSecurityTrace
    public static String getMachineUID() throws IOException {
        String UID;
        block10: {
            UID = "";
            try (Scanner sc = null;){
                if (SystemUtil.isWindows()) {
                    String regPath = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Cryptography";
                    Process process = Runtime.getRuntime().exec(new String[]{"reg", "query", regPath, "/v", REGKEY_MACHINE_GUID, "/reg:64"});
                    sc = new Scanner(process.getInputStream());
                    while (sc.hasNext()) {
                        String line = sc.next();
                        if (!line.contains(REGKEY_MACHINE_GUID) || !sc.hasNext()) continue;
                        sc.next();
                        if (!sc.hasNext()) continue;
                        UID = sc.next().trim();
                        break block10;
                    }
                    break block10;
                }
                if (SystemUtil.isMac()) {
                    Process process = Runtime.getRuntime().exec(CMD_MAC_SYSTEM_PROFILER);
                    sc = new Scanner(process.getInputStream());
                    sc.useDelimiter(System.getProperty("line.separator"));
                    while (sc.hasNextLine()) {
                        String line = sc.nextLine();
                        if (!line.contains(UUID)) continue;
                        UID = line.split(":")[1].trim();
                        break block10;
                    }
                    break block10;
                }
                Process process = Runtime.getRuntime().exec(CMD_LINUX_LSHAL_UUID);
                sc = new Scanner(process.getInputStream());
                if (sc.hasNext()) {
                    UID = sc.next();
                }
            }
        }
        return UID;
    }

    public static String getStackTrace() {
        StringBuffer str = new StringBuffer();
        str.append(System.getProperty("line.separator"));
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            str.append(MessageFormat.format("\t\t {0}", e.getClassName() + "." + e.getMethodName() + "(" + e.getFileName() + ":" + e.getLineNumber() + ")"));
            str.append(System.getProperty("line.separator"));
        }
        return str.toString();
    }

    public static String calculateChecksumBase64(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        byte[] mdbytes = SystemUtil.getChecksumBytes(new FileInputStream(file), algorithm);
        return Base64.getEncoder().encodeToString(mdbytes);
    }

    public static String calculateChecksum(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        return SystemUtil.calculateChecksum(new FileInputStream(file), algorithm);
    }

    public static String calculateChecksum(InputStream is, String algorithm) throws IOException, NoSuchAlgorithmException {
        byte[] mdbytes = SystemUtil.getChecksumBytes(is, algorithm);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String calculateSHA1(File file) throws IOException, NoSuchAlgorithmException {
        return SystemUtil.calculateSHA1(new FileInputStream(file));
    }

    public static String calculateSHA1(InputStream is) throws IOException, NoSuchAlgorithmException {
        return SystemUtil.calculateChecksum(is, "SHA1");
    }

    public static String calculateSHA1(String string) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(string.getBytes());
        byte[] mdbytes = md.digest();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getChecksumBytes(InputStream is, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        try {
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = is.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
        }
        finally {
            is.close();
        }
        return md.digest();
    }

    public static void setPropIfNull(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    public static boolean defaultTrueProperty(String key) {
        return !"false".equalsIgnoreCase(System.getProperty(key));
    }

    public static boolean isDisablePropertyNotSet(String key) {
        String v = System.getProperty(key);
        return v == null || "false".equalsIgnoreCase(v);
    }

    public static boolean defaultFalseProperty(String key) {
        return "true".equalsIgnoreCase(System.getProperty(key));
    }

    public static boolean isPropertySet(String key) {
        return System.getProperty(key) != null;
    }

    public static boolean isPropertyPopulated(String key) {
        return System.getProperty(key) != null && !System.getProperty(key).isEmpty();
    }

    public static boolean enableFIPS() {
        if (FIPS_ENABLED) {
            return true;
        }
        FIPS_ENABLED = CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("fips_enabled");
        if (FIPS_ENABLED) {
            Message message;
            try {
                FipsUtil.enableFIPS();
                message = new Message(1, Messages.getMessage("fips.enabled", new Object[0]));
            }
            catch (ReflectiveOperationException | SecurityException | GeneralSecurityException e) {
                message = new Message(Messages.getMessage("err.fips", new Object[0]), e);
                FIPS_ENABLED = false;
            }
            CommonCore.getLogManager().log(message);
            CommonCore.getIOConsole().println(message);
        }
        return FIPS_ENABLED;
    }

    public static boolean useNewDotNetFrontend() {
        return SystemUtil.isPropertySet(PROP_USE_NEW_FRONTEND);
    }

    public static enum IRGenClient {
        CLI,
        Eclipse,
        IntelliJ,
        VisualStudio,
        Maven,
        Jenkins,
        Gradle,
        UrbanCode,
        AppScanGo,
        AzureDevOps,
        VSCode,
        GitHubSast{

            public String toString() {
                return "GitHub-SAST";
            }
        }
        ,
        GitHubCodeSweep{

            public String toString() {
                return "GitHub-CodeSweep";
            }
        };

    }
}

