/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.utils.StateUtil;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.model.xml.ModelWriter;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.internal.common.model.TransientStringPattern;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class ConfiguredScanWriter
extends ModelWriter
implements IModelXMLConstants {
    private Map<String, CustomTargetInfo> m_customTargetInfos;
    private DOMWriter m_scan;
    private DOMWriter m_targets;
    private DOMWriter m_customTargetInfo;

    ConfiguredScanWriter(Map<String, CustomTargetInfo> customTargetInfos) {
        this.m_customTargetInfos = customTargetInfos;
    }

    @Override
    protected void initWriters(File directory) throws IOException {
        this.m_scan = new DOMWriter(directory, ".scan", this.m_builder);
        this.m_targets = new DOMWriter(directory, ".targets", this.m_builder);
        this.m_customTargetInfo = new DOMWriter(directory, ".customtargetinfo", this.m_builder);
    }

    private void writeCustomTargetInfos() {
        for (Map.Entry<String, CustomTargetInfo> targetInfo : this.m_customTargetInfos.entrySet()) {
            String path = targetInfo.getKey();
            CustomTargetInfo info = targetInfo.getValue();
            if (!info.hasContent()) continue;
            this.m_customTargetInfo.beginElement("Target");
            this.m_customTargetInfo.setAttribute("path", path);
            Map<String, String> map = info.getBuildInfos();
            if (!map.isEmpty()) {
                this.m_customTargetInfo.beginElement("BuildInfo");
                for (Map.Entry entry : map.entrySet()) {
                    this.m_customTargetInfo.setAttribute((String)entry.getKey(), (String)entry.getValue());
                }
                this.m_customTargetInfo.endElement();
            }
            for (StringPattern stringPattern : info.getIncludes()) {
                if (stringPattern instanceof TransientStringPattern) continue;
                this.m_customTargetInfo.beginElement("Include");
                this.m_customTargetInfo.endElement(stringPattern.toString());
            }
            for (StringPattern stringPattern : info.getExcludes()) {
                if (stringPattern instanceof TransientStringPattern) continue;
                this.m_customTargetInfo.beginElement("Exclude");
                this.m_customTargetInfo.endElement(stringPattern.toString());
            }
            this.m_customTargetInfo.endElement();
        }
    }

    @Override
    public void visit(IScan scan) {
        this.m_scan.beginElement("Scan");
        this.m_scan.setAttribute("state", "ConfiguredScan");
        this.m_targets.beginElement("Targets");
        this.m_customTargetInfo.beginElement("CustomTargetInfo");
        if (this.m_customTargetInfos != null) {
            this.writeCustomTargetInfos();
        }
        this.m_customTargetInfo.endElement();
    }

    @Override
    public void visit(IScanTarget target) {
        if (SystemUtil.isOpenSourceOnly() && !"ThirdPartyLib".equals(target.getName())) {
            return;
        }
        String path = target.getPath();
        if (target.getParent() == null) {
            this.m_targets.beginElement("Target");
            this.m_targets.setAttribute("path", path);
            this.m_targets.setAttribute("working_directory", target.getWorkingDirectoryName());
            if (target.isDirectoryTarget()) {
                this.m_targets.setAttribute("dir", "true");
            }
            this.m_targets.endElement();
        }
        StateUtil.updateStateMarker(this.getWorkingDirectory(), target);
    }

    @Override
    public void write() throws TransformerException {
        this.m_scan.write(this.m_transformer);
        this.m_targets.write(this.m_transformer);
        this.m_customTargetInfo.write(this.m_transformer);
    }
}

