/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.common.xml.XMLStreamReader;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class CustomTargetInfoReader
extends XMLFileReader
implements IModelXMLConstants {
    private Map<String, CustomTargetInfo> m_map;
    private CustomTargetInfo m_current = null;

    CustomTargetInfoReader(File file, Map<String, CustomTargetInfo> map) {
        super(file);
        this.m_map = map;
    }

    @Override
    protected boolean process(StartElement element, XMLStreamReader.ElementValue value) throws XMLStreamException {
        String name = element.getName().getLocalPart();
        if ("Target".equals(name)) {
            String path = this.getAttribute(element, "path");
            if (path != null) {
                this.m_current = new CustomTargetInfo();
                this.m_map.put(path, this.m_current);
            } else {
                this.m_current = null;
            }
        } else if (this.m_current != null) {
            if ("BuildInfo".equals(name)) {
                Iterator<Attribute> iter = element.getAttributes();
                while (iter.hasNext()) {
                    Attribute attribute = iter.next();
                    this.m_current.getBuildInfos().put(attribute.getName().getLocalPart(), attribute.getValue());
                }
            } else if ("Include".equals(name)) {
                this.m_current.getIncludes().add(new StringPattern(value.getText()));
            } else if ("Exclude".equals(name)) {
                this.m_current.getExcludes().add(new StringPattern(value.getText()));
            }
        }
        return true;
    }
}

