/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.hcl.appscan.common.scm.ScmUtil;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;

public final class ScanFile
implements IScanFile {
    private File m_file = null;
    private String m_analysisPath = null;
    private String m_sourcePath = null;
    private String m_checksum = null;
    private boolean m_excluded = false;
    private String m_fileVersion = null;
    private double m_fileSize = 0.0;

    public ScanFile(File f) {
        this.m_file = f;
        this.m_analysisPath = f.getPath();
        this.setFileDetails(f);
    }

    public ScanFile(String filePath) {
        this(new File(filePath));
    }

    public ScanFile(File file, String checksum) {
        this(file);
        this.m_checksum = checksum;
    }

    public ScanFile(String analysisPath, String sourcePath, String checksum) {
        this(new File(analysisPath));
        this.m_sourcePath = sourcePath;
        this.m_checksum = checksum;
    }

    public ScanFile(File file, File physicalFile) {
        this.m_file = file;
        this.setFileDetails(physicalFile);
    }

    @Override
    public File getFile() {
        return this.m_file;
    }

    @Override
    public void setSourcePath(String path) {
        if (SystemUtil.isCommonEngine()) {
            this.m_sourcePath = path;
        } else {
            path = this.cleanSourcePath(path);
            this.m_sourcePath = ScmUtil.getRepositoryRelativePath(path);
        }
    }

    @Override
    public String getSourcePath() {
        return this.m_sourcePath;
    }

    @Override
    public void setChecksum(String checksum) {
        this.m_checksum = checksum;
    }

    @Override
    public String getChecksum() {
        return this.m_checksum;
    }

    @Override
    public String getFileVersion() {
        return this.m_fileVersion;
    }

    @Override
    public void setFileVersion(String version) {
        this.m_fileVersion = version;
    }

    @Override
    public double getFileSize() {
        return this.m_fileSize;
    }

    @Override
    public void setFileSize(double size) {
        this.m_fileSize = size;
    }

    @Override
    public String getFileId() {
        try {
            return SystemUtil.calculateSHA1(this.m_sourcePath);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            return null;
        }
    }

    public String toString() {
        return this.m_analysisPath;
    }

    @Override
    public String getAnalysisPath() {
        return this.m_analysisPath;
    }

    @Override
    public void setFile(String filename) {
        this.m_file = new File(filename);
    }

    @Override
    public void setExcluded(boolean excluded) {
        this.m_excluded = excluded;
    }

    @Override
    public boolean isExcluded() {
        return this.m_excluded;
    }

    private String cleanSourcePath(String path) {
        String[] parts = path.split(Pattern.quote(File.separator));
        String root = parts[0];
        String stageDir = File.separator + "stage" + File.separator;
        String analyzeDir = File.separator + "analyze" + File.separator;
        switch (root) {
            case "unzip": {
                if (!SystemUtil.isCloudIRGen()) break;
                path = path.substring(6);
                break;
            }
            case "fallback": {
                if (!SystemUtil.isWindows() || !path.endsWith(".c") && !path.endsWith(".cpp")) break;
                path = path.substring(9);
                break;
            }
            case "analyze": {
                if (!SystemUtil.useStagerForJavaFiles()) break;
                path = path.substring(8);
                break;
            }
            default: {
                if (path.contains(stageDir) && path.contains(analyzeDir)) {
                    int index = path.indexOf(analyzeDir);
                    path = path.substring(index + analyzeDir.length());
                }
                if (!SystemUtil.isCloudIRGen() || parts.length <= 2 || !"unzip".equalsIgnoreCase(parts[1])) break;
                path = path.substring(parts[0].length() + parts[1].length() + 2);
            }
        }
        return path;
    }

    private void setFileDetails(File file) {
        if (file.exists()) {
            try {
                this.m_fileVersion = SystemUtil.calculateChecksum(file, "SHA256");
            }
            catch (IOException | NoSuchAlgorithmException exception) {
                // empty catch block
            }
            this.m_fileSize = (double)file.length() / 1024.0;
        }
    }
}

