/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.translator.java;

import com.ibm.wala.samso.translator.IMethodEncoder;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import java.util.Arrays;
import java.util.Collection;

public class JavaMethodEncoder
implements IMethodEncoder {
    static final Collection<String> stringishClass = Arrays.asList("java.lang.String", "java.lang.StringBuffer", "java.lang.StringBuilder");
    static final Collection<String> stringishInit = Arrays.asList("java.lang.String.<init>(Ljava/lang/String;)V", "java.lang.StringBuffer.<init>(Ljava/lang/String;)V", "java.lang.StringBuilder.<init>(Ljava/lang/String;)V");

    public String getMethodName(SSAAbstractInvokeInstruction invoke) {
        return invoke.getDeclaredTarget().getSignature();
    }

    public int[] getParameters(SSAAbstractInvokeInstruction invoke) {
        int len = invoke.getNumberOfUses();
        int[] params = new int[len];
        for (int i = 0; i < len; ++i) {
            params[i] = invoke.getUse(i);
        }
        if (stringishInit.contains(this.getMethodName(invoke))) {
            return Arrays.copyOfRange(params, 1, params.length);
        }
        return params;
    }

    public int getDef(SSAAbstractInvokeInstruction invoke) {
        if (stringishInit.contains(this.getMethodName(invoke))) {
            return invoke.getReceiver();
        }
        return invoke.getDef();
    }

    public boolean isBuiltin(SSAAbstractInvokeInstruction invoke) {
        String signature = invoke.getDeclaredTarget().getSignature();
        return signature.startsWith("java.") || signature.startsWith("javax.");
    }

    public String getMethodName(SSANewInstruction invoke) {
        return invoke.getConcreteType().getName().toString();
    }

    public int[] getParameters(SSANewInstruction invoke) {
        int len = invoke.getNumberOfUses();
        int[] params = new int[len];
        for (int i = 0; i < len; ++i) {
            params[i] = invoke.getUse(i);
        }
        return params;
    }

    public int getDef(SSANewInstruction invoke) {
        if (stringishClass.contains(this.getMethodName(invoke))) {
            return 0;
        }
        return invoke.getDef();
    }
}

