/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecificationVersionRange;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class ContainsValidator
extends BaseKeywordValidator {
    private static final String CONTAINS_MAX = "contains.max";
    private static final String CONTAINS_MIN = "contains.min";
    private final Schema schema;
    private final boolean isMinV201909;
    private final Integer min;
    private final Integer max;

    public ContainsValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.CONTAINS, schemaNode, schemaLocation, parentSchema, schemaContext);
        this.isMinV201909 = SpecificationVersionRange.MIN_DRAFT_2019_09.getVersions().contains((Object)this.schemaContext.getDialect().getSpecificationVersion());
        Integer currentMax = null;
        Integer currentMin = null;
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            Optional<JsonNode> minNode;
            this.schema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
            JsonNode parentSchemaNode = parentSchema.getSchemaNode();
            Optional<JsonNode> maxNode = Optional.ofNullable(parentSchemaNode.get(KeywordType.MAX_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral);
            if (maxNode.isPresent()) {
                currentMax = maxNode.get().intValue();
            }
            if ((minNode = Optional.ofNullable(parentSchemaNode.get(KeywordType.MIN_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral)).isPresent()) {
                currentMin = minNode.get().intValue();
            }
        } else {
            this.schema = null;
        }
        this.max = currentMax;
        this.min = currentMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        int actual = 0;
        int i = 0;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (null != this.schema && node.isArray()) {
            boolean failFast = executionContext.isFailFast();
            List<Error> existingErrors = executionContext.getErrors();
            try {
                executionContext.setFailFast(false);
                ArrayList<Error> test = new ArrayList<Error>();
                executionContext.setErrors(test);
                for (JsonNode n : node) {
                    NodePath path = instanceLocation.append(i);
                    this.schema.validate(executionContext, n, rootNode, path);
                    if (test.isEmpty()) {
                        ++actual;
                        indexes.add(i);
                    } else {
                        test.clear();
                    }
                    ++i;
                }
            }
            finally {
                executionContext.setFailFast(failFast);
                executionContext.setErrors(existingErrors);
            }
            int m = 1;
            if (this.min != null) {
                m = this.min;
            }
            if (actual < m) {
                this.boundsViolated(executionContext, this.isMinV201909 ? KeywordType.MIN_CONTAINS : KeywordType.CONTAINS, executionContext.getExecutionConfig().getLocale(), node, instanceLocation, m);
            }
            if (this.max != null && actual > this.max) {
                this.boundsViolated(executionContext, this.isMinV201909 ? KeywordType.MAX_CONTAINS : KeywordType.CONTAINS, executionContext.getExecutionConfig().getLocale(), node, instanceLocation, this.max);
            }
        }
        boolean collectAnnotations = this.hasUnevaluatedItemsInEvaluationPath(executionContext);
        if (this.schema != null) {
            if (collectAnnotations || this.collectAnnotations(executionContext, "contains")) {
                if (actual == i) {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword("contains").value(true).build());
                } else {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword("contains").value(indexes).build());
                }
            }
            if (this.min != null) {
                String minContainsKeyword = "minContains";
                if (collectAnnotations || this.collectAnnotations(executionContext, minContainsKeyword)) {
                    executionContext.evaluationPathAddLast(minContainsKeyword);
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation.append(minContainsKeyword)).keyword(minContainsKeyword).value(this.min).build());
                    executionContext.evaluationPathRemoveLast();
                }
            }
            if (this.max != null) {
                String maxContainsKeyword = "maxContains";
                if (collectAnnotations || this.collectAnnotations(executionContext, maxContainsKeyword)) {
                    executionContext.evaluationPathAddLast(maxContainsKeyword);
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation.append(maxContainsKeyword)).keyword(maxContainsKeyword).value(this.max).build());
                    executionContext.evaluationPathRemoveLast();
                }
            }
        }
    }

    @Override
    public void preloadSchema() {
        Optional.ofNullable(this.schema).ifPresent(Schema::initializeValidators);
    }

    private void boundsViolated(ExecutionContext executionContext, KeywordType validatorTypeCode, Locale locale, JsonNode instanceNode, NodePath instanceLocation, int bounds) {
        String messageKey = "contains";
        if (KeywordType.MIN_CONTAINS.equals(validatorTypeCode)) {
            messageKey = CONTAINS_MIN;
        } else if (KeywordType.MAX_CONTAINS.equals(validatorTypeCode)) {
            messageKey = CONTAINS_MAX;
        }
        executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(instanceNode)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).messageKey(messageKey)).locale(locale)).arguments(String.valueOf(bounds), this.schema.getSchemaNode().toString())).keyword(validatorTypeCode.getValue())).build());
    }
}

