/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.JsonNodeTypes;
import java.math.BigDecimal;

public class MultipleOfValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final BigDecimal divisor;

    public MultipleOfValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.MULTIPLE_OF, schemaNode, schemaLocation, parentSchema, schemaContext);
        this.divisor = this.getDivisor(schemaNode);
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        BigDecimal dividend;
        if (this.divisor != null && (dividend = this.getDividend(node)) != null && dividend.divideAndRemainder(this.divisor)[1].abs().compareTo(BigDecimal.ZERO) > 0) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.divisor.toString())).build());
        }
    }

    protected BigDecimal getDivisor(JsonNode schemaNode) {
        double divisor;
        if (schemaNode.isNumber() && (divisor = schemaNode.doubleValue()) != 0.0) {
            return schemaNode.isBigDecimal() ? schemaNode.decimalValue().stripTrailingZeros() : BigDecimal.valueOf(divisor).stripTrailingZeros();
        }
        return null;
    }

    protected BigDecimal getDividend(JsonNode node) {
        if (node.isNumber()) {
            return node.isBigDecimal() ? node.decimalValue() : BigDecimal.valueOf(node.doubleValue());
        }
        if (this.schemaContext.getSchemaRegistryConfig().isTypeLoose() && JsonNodeTypes.isNumber(node, this.schemaContext.getSchemaRegistryConfig())) {
            return new BigDecimal(node.textValue());
        }
        return null;
    }
}

