/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class GetLogsHandler
extends SAHandler {
    private File m_destination = null;
    private AuthenticationProvider m_authProvider = AuthenticationProvider.getInstance();

    public void getLogs(String scanId, String saveLocation) throws AppScanException {
        scanId = StringUtil.getCleanUuid((String)scanId);
        IConsole console = CommonCLICore.getIOConsole();
        this.setProgressAdapter((IProgress)new ProgressAdapter());
        try {
            if (this.m_authProvider.isTokenExpired()) {
                return;
            }
        }
        catch (SSLHandshakeException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.ssl", this.m_authProvider.getServer())));
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
        this.m_destination = saveLocation != null ? new File(saveLocation) : new File(System.getProperty("user.dir"));
        if (this.m_destination.isDirectory()) {
            this.m_destination = new File(this.m_destination, "logs.zip");
        } else if (!this.m_destination.getName().toLowerCase().endsWith(".zip")) {
            this.m_destination = new File(this.m_destination.getParentFile(), "logs.zip");
        }
        if (!FileUtil.isValidFilename((String)this.m_destination.getName())) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.invalid.characters", saveLocation)));
            return;
        }
        try {
            this.m_destination = this.setDownloadLocation(this.m_destination, "zip");
            this.downloadLogs(scanId, this.m_destination);
            if (this.m_destination.exists()) {
                console.println(Messages.getMessage("job.getlogs.success", new Object[0]));
                console.println(Messages.getMessage("job.getlogs.location", this.m_destination.getCanonicalPath()));
                this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getlogs.success", new Object[0])));
                this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getlogs.location", this.m_destination.getCanonicalPath())));
            } else {
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getlogs.error", new Object[0])));
            }
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getlogs.error", new Object[0])));
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
        catch (JSONException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getlogs.error", new Object[0])));
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
        }
    }

    private void downloadLogs(String scanId, File destination) throws IOException, JSONException {
        String path = String.format("/api/v4/Scans/ScanLogs/%s", scanId);
        String requestUrl = this.m_authProvider.getServer() + path;
        HashMap headers = new HashMap();
        headers.putAll(this.m_authProvider.getAuthorizationHeader());
        HttpResponse response = new HttpClient().get(requestUrl, headers, null);
        if (!response.isSuccess()) {
            this.processFailedResponse(response);
        }
        response.getResponseBodyAsFile(destination);
    }

    private void processFailedResponse(HttpResponse response) throws IOException {
        try {
            JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
            if (obj != null && obj.has("Message")) {
                throw new IOException(obj.getString("Message"));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        throw new IOException("error.getting.issues");
    }
}

