/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.cloud.handlers.ReportHandler;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.cloud.reports.IReportConfig;
import com.ibm.appscan.cli.cloud.reports.SbomReport;
import com.ibm.appscan.cli.cloud.reports.SecurityReport;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONException;

public class GetReportHandler
extends SAHandler {
    private String m_scope = null;
    private String m_type = null;
    private String m_format = null;
    private File m_destination = null;
    private String m_reportTitle = null;
    private String m_reportLocale = "en";
    private String m_regReportType = null;
    private boolean m_applyPolicies = false;
    private boolean m_tableOfContent = true;
    private boolean m_summary = true;
    private static final String REG_REPORT_PATTERN = "^[a-zA-z0-9_]*$";
    private static final String REPORT_TITLE_PATTERN = "^[a-zA-z0-9_\\s]*$";
    private static final String REPORT_LOCALE_PATTERN = "^[a-zA-z_]*$";
    private static final String[] REPORT_TYPES = new String[]{"issues", "security", "regulation", "license", "sbom"};
    private static final String[] REPORT_SCOPES = new String[]{"application", "scan", "scanexecution"};
    private static final String[] REPORT_FORMATS = new String[]{"pdf", "html", "xml", "csv", "sarif", "spdx_json", "spdx_text"};
    private AuthenticationProvider m_authProvider = AuthenticationProvider.getInstance();

    public void setApplyPolicies(boolean applyPolicies) {
        this.m_applyPolicies = applyPolicies;
    }

    private boolean validateString(String stringToValidate, String pattern) {
        return stringToValidate.matches(pattern);
    }

    public void setTableOfContent(boolean tableOfContent) {
        this.m_tableOfContent = tableOfContent;
    }

    public void setSummary(boolean summary) {
        this.m_summary = summary;
    }

    public void getResult(String scanId, String reportType, String reportScope, String saveLocation, String reportFormat, String regReportType, String reportTitle, String reportLocale) throws AppScanException, JSONException {
        SaaSConstants reportJSONOptions;
        this.setProgressAdapter((IProgress)new ProgressAdapter());
        scanId = StringUtil.getCleanUuid((String)scanId);
        if (!(this.validateAuthentication() && this.validateAndSetReportScope(reportScope) && this.validateAndSetReportFormat(reportType, reportFormat))) {
            return;
        }
        this.m_reportTitle = reportTitle != null ? this.validateAndSetReportTitle(reportTitle) : null;
        this.m_reportLocale = reportLocale != null ? this.validateAndSetReportLocale(reportLocale) : "en";
        this.m_destination = saveLocation != null ? this.validateAndSetDestination(saveLocation) : new File(System.getProperty("user.dir"));
        this.m_regReportType = regReportType != null ? this.validateAndSetRegulationReportType(regReportType) : null;
        this.m_type = reportType != null ? this.validateAndSetReportType(reportType) : null;
        SaaSConstants saaSConstants = reportJSONOptions = !"sbom".equalsIgnoreCase(reportType) ? new SecurityReport(this.m_format, this.m_applyPolicies, this.m_reportTitle, this.m_reportLocale, this.m_regReportType, this.m_type, this.m_tableOfContent, this.m_summary) : new SbomReport(this.m_format, this.m_reportTitle);
        if (!FileUtil.getFileExtension((File)this.m_destination).isEmpty() && !FileUtil.getFileExtension((File)this.m_destination).equals(reportJSONOptions.getFormat())) {
            this.m_destination = new File(this.m_destination.getPath().substring(0, this.m_destination.getPath().length() - FileUtil.getFileExtension((File)this.m_destination).length()) + reportJSONOptions.getFormat());
        }
        try {
            String reportJobID = this.queueReportJob(scanId, this.m_type, this.m_scope, reportJSONOptions.options().toString(), this.m_regReportType);
            if (reportJobID == null) {
                throw new IOException(Messages.getMessage("err.report.id.null", new Object[0]));
            }
            this.processReportJob(reportJobID, (IReportConfig)reportJSONOptions);
        }
        catch (IOException | JSONException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.error", e.getMessage())));
        }
    }

    private void processReportJob(String reportJobID, IReportConfig reportConfig) throws IOException, JSONException {
        ReportHandler reportUtil = new ReportHandler();
        this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.queuesuccess", reportJobID)));
        this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.waiting", new Object[0])));
        String jobStatus = null;
        int loop = 30;
        int timeToSleep = 10000;
        for (int i = 0; i < loop; ++i) {
            try {
                jobStatus = reportUtil.getReportStatus(reportJobID).get("Status").toString();
                switch (jobStatus.toUpperCase()) {
                    case "READY": {
                        i = loop;
                        break;
                    }
                    case "FAILED": 
                    case "DELETED": {
                        throw new IOException(Messages.getMessage("err.report.generation", new Object[0]));
                    }
                    default: {
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException e) {
                            this.getProgressAdapter().setStatus(new Message(1, "Unable to Sleep"));
                        }
                        break;
                    }
                }
                continue;
            }
            catch (IOException e) {
                this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("err.checking.status", e.getMessage())));
                break;
            }
        }
        reportUtil.downloadReport(reportJobID, this.setDownloadLocation(this.m_destination, reportConfig.getFormat()));
        if (!this.m_destination.exists()) {
            throw new IOException(Messages.getMessage("err.report.download", new Object[0]));
        }
        this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.success", new Object[0])));
        this.getProgressAdapter().setStatus(new Message(1, Messages.getMessage("job.getreport.location", this.m_destination.getCanonicalPath())));
    }

    private boolean validateAuthentication() {
        try {
            return !this.m_authProvider.isTokenExpired();
        }
        catch (SSLHandshakeException e) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.ssl", this.m_authProvider.getServer())));
            return false;
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
            return false;
        }
    }

    private boolean validateAndSetReportScope(String reportScope) {
        ArrayList<String> validOptions = new ArrayList<String>(Arrays.asList(REPORT_SCOPES));
        if (reportScope != null && validOptions.contains(reportScope.toLowerCase())) {
            this.m_scope = reportScope;
            return true;
        }
        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.scope", reportScope)));
        return false;
    }

    private boolean validateAndSetReportFormat(String reportType, String reportFormat) {
        if ("issues".equalsIgnoreCase(reportType)) {
            this.m_format = "json";
            return true;
        }
        if (reportFormat == null) {
            this.m_format = "pdf";
            return true;
        }
        ArrayList<String> validOptions = new ArrayList<String>(Arrays.asList(REPORT_FORMATS));
        if (validOptions.contains(reportFormat.toLowerCase())) {
            this.m_format = reportFormat;
            return true;
        }
        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.format", reportFormat)));
        return false;
    }

    private String validateAndSetRegulationReportType(String regReportType) {
        if (regReportType != null && this.validateString(regReportType, REG_REPORT_PATTERN)) {
            return regReportType;
        }
        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.regformat", regReportType)));
        return null;
    }

    private String validateAndSetReportTitle(String reportTitle) {
        if (this.validateString(reportTitle = reportTitle.replace("\"", ""), REPORT_TITLE_PATTERN)) {
            return reportTitle;
        }
        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.invalid.reporttitle", reportTitle)));
        return "AppScan Security Report";
    }

    private String validateAndSetReportLocale(String reportLocale) {
        if (this.validateString(reportLocale, REPORT_LOCALE_PATTERN)) {
            return reportLocale;
        }
        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.invalid.reportlocale", reportLocale)));
        return "en";
    }

    private File validateAndSetDestination(String saveLocation) {
        this.m_destination = new File(saveLocation);
        if (!FileUtil.isValidFilename((String)this.m_destination.getName())) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.invalid.characters", saveLocation)));
            return new File(System.getProperty("user.dir"));
        }
        return this.m_destination;
    }

    private String validateAndSetReportType(String reportType) {
        ArrayList<String> validOptions = new ArrayList<String>(Arrays.asList(REPORT_TYPES));
        if (reportType != null && validOptions.contains(reportType.toLowerCase())) {
            return reportType.toLowerCase();
        }
        this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.type", reportType)));
        return null;
    }
}

