/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.File;
import java.io.IOException;
import java.net.HttpRetryException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SAHandler
implements SaaSConstants {
    private static final String DEFAULT_RESULTS_FILE = "appscan_results";
    private static final String DEFAULT_TAG = "default";
    String m_appID = "0";
    protected IProgress m_progress;
    protected AuthenticationProvider m_authProvider;
    private HttpClient m_httpClient = null;
    private HttpResponse m_response = null;
    public JSONArray m_applicationArray = new JSONArray();

    public SAHandler() {
        this.m_authProvider = AuthenticationProvider.getInstance();
        this.m_httpClient = new HttpClient();
    }

    public IProgress getProgressAdapter() {
        if (this.m_progress == null) {
            return new NullProgress();
        }
        return this.m_progress;
    }

    public void setProgressAdapter(IProgress progress) {
        this.m_progress = progress;
    }

    public JSONObject getScanDetails(String scanId) throws IOException, JSONException {
        String request_url = this.m_authProvider.getServer() + "/api/v4/Scans" + "?%24filter=Id%20eq%20" + scanId;
        Map request_headers = this.m_authProvider.getAuthorizationHeader();
        this.m_response = this.m_httpClient.get(request_url, request_headers, null);
        if (this.m_response.getResponseCode() == 200 || this.m_response.getResponseCode() == 201) {
            JSONObject res = (JSONObject)this.m_response.getResponseBodyAsJSON();
            return res.getJSONArray("Items").getJSONObject(0);
        }
        if (this.m_response.getResponseCode() == 400) {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.invalid.jobid", new Object[0])));
        }
        return null;
    }

    public JSONArtifact getScanList() throws IOException, JSONException {
        String request_url = this.m_authProvider.getServer() + "/api/v4/Scans";
        Map request_headers = this.m_authProvider.getAuthorizationHeader();
        this.m_response = this.m_httpClient.get(request_url, request_headers, null);
        if (this.m_response.getResponseCode() == 200) {
            return this.m_response.getResponseBodyAsJSON();
        }
        return null;
    }

    public JSONObject createAndExecuteSastScan(String fileId, String scanName, String emailNotification, String locale, String personal, String comment, boolean interventionDisabled) throws IOException, JSONException {
        String url = this.m_authProvider.getServer() + "/api/v4/Scans/Sast";
        return this.createAndExecuteScan(url, fileId, scanName, emailNotification, locale, personal, comment, interventionDisabled);
    }

    public JSONObject createAndExecuteScaScan(String fileId, String scanName, String emailNotification, String locale, String personal, String comment, boolean interventionDisabled) throws IOException, JSONException {
        String url = this.m_authProvider.getServer() + "/api/v4/Scans/Sca";
        return this.createAndExecuteScan(url, fileId, scanName, emailNotification, locale, personal, comment, interventionDisabled);
    }

    private JSONObject createAndExecuteScan(String url, String fileId, String scanName, String emailNotification, String locale, String personal, String comment, boolean interventionDisabled) throws IOException, JSONException {
        Map request_headers = this.m_authProvider.getAuthorizationHeader();
        request_headers.put("Content-Type", "application/json");
        JSONObject payload = new JSONObject();
        payload.put("AppId", (Object)this.m_appID);
        payload.put("ApplicationFileId", (Object)fileId);
        payload.put("ScanName", (Object)scanName);
        payload.put("EnableMailNotification", Boolean.parseBoolean(emailNotification));
        payload.put("Locale", (Object)locale);
        payload.put("Personal", Boolean.parseBoolean(personal));
        payload.put("Execute", true);
        payload.put("ClientType", (Object)new String(SystemUtil.getClientType()));
        payload.put("FullyAutomatic", interventionDisabled);
        if (comment != null) {
            payload.put("comment", (Object)comment);
        }
        this.m_response = this.m_httpClient.post(url, request_headers, payload.toString().toCharArray());
        JSONObject json = (JSONObject)this.m_response.getResponseBodyAsJSON();
        if (this.m_response.isSuccess()) {
            return json;
        }
        if (json != null && json.has("Message")) {
            this.getProgressAdapter().setStatus(new Message(4, this.getFormattedMessage(json)));
        } else {
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.submit.failed", scanName, this.m_response.getResponseCode())));
        }
        return null;
    }

    protected String getFormattedMessage(JSONObject json) throws JSONException {
        String message = json.getString("Message");
        JSONArray arrayObject = json.optJSONArray("FormatParams");
        if (arrayObject != null) {
            for (int i = 0; i < arrayObject.length(); ++i) {
                message = message.replaceAll("\\{" + i + "\\}", arrayObject.get(i).toString());
            }
        }
        return message;
    }

    public int deleteScan(String scanId) throws IOException {
        String request_url = this.m_authProvider.getServer() + String.format("/api/v4/Scans/%s", scanId);
        Map request_headers = this.m_authProvider.getAuthorizationHeader();
        this.m_response = this.m_httpClient.delete(request_url, request_headers, null);
        return this.m_response.getResponseCode();
    }

    protected boolean getRawResult(String scanId, String type, File destination) throws IOException, JSONException {
        String executionId = null;
        String request_url = this.m_authProvider.getServer() + String.format("/api/v4/Scans/Executions/%s", scanId);
        Map request_headers = this.m_authProvider.getAuthorizationHeader();
        request_headers.put("Content-Length", "0");
        this.m_response = this.m_httpClient.get(request_url, request_headers, null);
        if (this.m_response.getResponseCode() != 200) {
            this.handleBadReportRequest(this.m_response, null, null);
            return false;
        }
        JSONArray data = (JSONArray)this.m_response.getResponseBodyAsJSON();
        executionId = data.getJSONObject(0).getString("Id");
        request_url = this.m_authProvider.getServer() + String.format("/api/v4/Scans/ExecutionRawResults/%s", executionId);
        this.m_response = this.m_httpClient.get(request_url, request_headers, null);
        if (this.m_response.getResponseCode() == 200) {
            this.m_response.getResponseBodyAsFile(this.setDownloadLocation(destination, type));
            if (destination.exists()) {
                IConsole console = CommonCLICore.getIOConsole();
                console.println(Messages.getMessage("job.getresults.success", new Object[0]));
                console.println(Messages.getMessage("job.getresults.location", destination.getCanonicalPath()));
                return true;
            }
        } else {
            this.handleBadReportRequest(this.m_response, null, null);
        }
        return false;
    }

    public String queueReportJob(String scanId, String reportType, String reportScope, String requestBody, String regulationReportType) throws IOException, JSONException {
        String request_url = null;
        switch (reportType) {
            case "issues": {
                request_url = this.m_authProvider.getServer() + String.format("/api/v4/Reports/Issues/%s/%s", reportScope, scanId);
                break;
            }
            case "security": {
                request_url = this.m_authProvider.getServer() + String.format("/api/v4/Reports/Security/%s/%s", reportScope, scanId);
                break;
            }
            case "regulation": {
                request_url = this.m_authProvider.getServer() + String.format("/api/v4/Reports/Regulation/%s/%s", reportScope, scanId);
                break;
            }
            case "license": {
                request_url = this.m_authProvider.getServer() + String.format("/api/v4/Reports/License/%s/%s", reportScope, scanId);
                break;
            }
            case "sbom": {
                request_url = this.m_authProvider.getServer() + String.format("/api/v4/Reports/Sbom/%s", scanId);
                break;
            }
            default: {
                return null;
            }
        }
        Map request_headers = this.m_authProvider.getAuthorizationHeader();
        request_headers.put("Content-Length", "0");
        request_headers.put("Content-Type", "application/json");
        request_headers.put("Accept", "application/json");
        this.m_response = this.m_httpClient.post(request_url, request_headers, requestBody.toCharArray());
        if (this.m_response.getResponseCode() == 200) {
            JSONObject reportJobInfo = (JSONObject)this.m_response.getResponseBodyAsJSON();
            return reportJobInfo.getString("Id");
        }
        this.handleBadReportRequest(this.m_response, reportType, regulationReportType);
        return null;
    }

    public File setDownloadLocation(File passedDestination, String fileFormat) throws IOException {
        String rawFileName;
        String fileName = null;
        String string = rawFileName = this.m_response != null ? this.m_response.getHeaderField("Content-Disposition") : null;
        if (rawFileName != null && rawFileName.indexOf("=") != -1) {
            Pattern p = Pattern.compile("=.*;");
            Matcher m = p.matcher(rawFileName);
            if (m.find()) {
                fileName = m.group();
                fileName = fileName.substring(1, fileName.length() - 1);
            }
        } else {
            fileName = "appscan_results." + fileFormat;
        }
        if (passedDestination.isDirectory()) {
            passedDestination = PathUtil.getSanitizedFile((String)passedDestination.getPath(), (String)fileName);
        } else if (passedDestination.getName().lastIndexOf(46) == -1) {
            if (!passedDestination.exists()) {
                passedDestination.mkdirs();
            }
            passedDestination = PathUtil.getSanitizedFile((String)passedDestination.getPath(), (String)fileName);
        } else if (passedDestination.getName().lastIndexOf(46) > 0) {
            fileName = passedDestination.getName();
            if (!(passedDestination = passedDestination.getCanonicalFile().getParentFile()).exists()) {
                passedDestination.mkdirs();
            }
            passedDestination = PathUtil.getSanitizedFile((String)passedDestination.getPath(), (String)fileName);
        }
        int g = 0;
        String targetPath = passedDestination.getCanonicalPath();
        while (passedDestination.exists()) {
            String extension = "";
            if (targetPath.lastIndexOf(".") > 0) {
                extension = targetPath.substring(targetPath.lastIndexOf("."));
            }
            String newLocation = targetPath.substring(0, targetPath.lastIndexOf(".")) + "(" + ++g + ")" + extension;
            passedDestination = new File(newLocation);
        }
        return passedDestination;
    }

    private void handleBadReportRequest(HttpResponse response, String reportType, String regulationReportType) throws JSONException, IOException {
        JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
        if (object.has("Message")) {
            IConsole console = CommonCLICore.getIOConsole();
            if (response.getResponseCode() == 400) {
                if (reportType.equalsIgnoreCase("regulation")) {
                    console.println(Messages.getMessage("job.getreport.unknown.regformat", regulationReportType));
                    this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.unknown.regformat", regulationReportType)));
                } else {
                    console.println(Messages.getMessage("err.invalid.jobid", new Object[0]));
                    this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.invalid.jobid", new Object[0])));
                }
            } else if (response.getResponseCode() == 403 && object.has("FormatParams") && !object.isNull("FormatParams")) {
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.getreport.report.limit.exceeded", object.getJSONArray("FormatParams").getString(1))));
            } else {
                console.println(object.getString("Message"));
                this.getProgressAdapter().setStatus(new Message(4, object.getString("Message")));
            }
        }
    }

    public boolean isTokenExpired() throws IOException {
        try {
            if (this.m_authProvider.isTokenExpired()) {
                this.getProgressAdapter().setStatus(new Message(4, com.ibm.appscan.cli.cloud.auth.Messages.getMessage((String)"login.token.expired", (Object[])new Object[0])));
                return true;
            }
        }
        catch (SSLHandshakeException e) {
            throw new IOException(Messages.getMessage("err.ssl", this.m_authProvider.getServer()));
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
            return true;
        }
        return false;
    }

    public void setAppId(String id) {
        this.m_appID = id;
    }

    private HttpResponse getAppsV4(String queryParams) throws IOException, JSONException {
        String url = this.m_authProvider.getServer() + "/api/v4/Apps" + queryParams;
        Map headers = this.m_authProvider.getAuthorizationHeader();
        headers.put("Content-Type", "application/json");
        return this.m_httpClient.get(url, headers, null);
    }

    public JSONArray getApps() throws IOException, JSONException {
        return this.getApps("?select=Name,Id&orderby=Name&top=5000&count=true&skip=", 0, 1);
    }

    private JSONArray getApps(String api_command, int skip, int iter) throws IOException, JSONException {
        HttpResponse response = this.getAppsV4(api_command = api_command + Integer.toString(skip));
        if (response.isSuccess()) {
            JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
            for (int i = 0; i < obj.getJSONArray("Items").size(); ++i) {
                this.m_applicationArray.add(obj.getJSONArray("Items").get(i));
            }
            if (Integer.parseInt(obj.getString("Count")) - iter * 5000 >= 0) {
                this.getApps("?select=Name,Id&orderby=Name&top=5000&count=true&skip=", skip + 5000, iter + 1);
            }
            return this.m_applicationArray;
        }
        return new JSONArray();
    }

    protected boolean hasApp(String appId) throws IOException, JSONException {
        JSONArray apps = this.getApps();
        for (int i = 0; i < apps.length(); ++i) {
            JSONObject app = apps.getJSONObject(i);
            if (!appId.equals(app.getString("Id"))) continue;
            return true;
        }
        return false;
    }

    private JSONObject getDefaultApp() throws IOException, JSONException {
        JSONArray apps;
        HttpResponse response = this.getAppsV4("?select=Name&filter=tags eq 'default'");
        if (response.isSuccess() && !(apps = (JSONArray)response.getResponseBodyAsJSON()).isEmpty()) {
            return apps.getJSONObject(0);
        }
        return null;
    }

    private JSONObject createApp(String name, JSONObject attributes) throws IOException, JSONException {
        String url = this.m_authProvider.getServer() + "/api/v4/Apps";
        Map headers = this.m_authProvider.getAuthorizationHeader();
        headers.put("Content-Type", "application/json");
        JSONObject body = new JSONObject();
        body.put("Name", (Object)name);
        body.put("Attributes", (Map)attributes);
        HttpResponse response = this.m_httpClient.post(url, headers, body.write().toCharArray());
        if (response.isSuccess()) {
            return (JSONObject)response.getResponseBodyAsJSON();
        }
        String error = Messages.getMessage("err.create.app", name);
        int status = response.getResponseCode();
        if (status == 409) {
            throw new HttpRetryException(error, status);
        }
        throw new IOException(error);
    }

    public JSONObject createApp(String name) throws IOException, JSONException {
        return this.createApp(name, new JSONObject());
    }

    @SuppressSecurityTrace
    private JSONObject createDefaultApp(String name) throws IOException, JSONException {
        String appName = name;
        JSONArray tags = new JSONArray();
        tags.put((Object)DEFAULT_TAG);
        JSONObject attributes = new JSONObject();
        attributes.put("tags", (Collection)tags);
        int i = 0;
        while (true) {
            try {
                return this.createApp(appName, attributes);
            }
            catch (HttpRetryException e) {
                JSONObject app = this.getDefaultApp();
                if (app != null) {
                    return app;
                }
                if (i++ == 10) {
                    throw e;
                }
                appName = name + i;
                continue;
            }
            break;
        }
    }

    public String initDefaultApp(String name) throws IOException, JSONException {
        String env = this.m_authProvider.getApiEnvironment();
        if (env != null && "SCX".equalsIgnoreCase(env)) {
            JSONObject app = this.getDefaultApp();
            if (app == null) {
                app = this.createDefaultApp(name);
            }
            this.m_appID = app.getString("Id");
        }
        return this.m_appID;
    }
}

