/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.reports;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.reports.IReportConfig;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.logging.Message;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SbomReport
implements IReportConfig,
SaaSConstants {
    private String m_format;
    private String m_fileName;
    private String m_orgName = "";
    private IProgress m_progress = new ProgressAdapter();

    public SbomReport(String format, String fileName) {
        this.m_format = this.getReportFormat(format);
        this.m_fileName = fileName;
    }

    @Override
    public JSONObject options() throws JSONException {
        JSONObject reportOptions = new JSONObject();
        reportOptions.put("FileName", (Object)this.m_fileName);
        reportOptions.put("SbomFormat", (Object)this.m_format);
        reportOptions.put("OrganizationName", (Object)this.m_orgName);
        return reportOptions;
    }

    @Override
    public String getFormat() throws JSONException {
        return this.m_format;
    }

    private String getReportFormat(String format) {
        if (!"spdx_json".equalsIgnoreCase(format) & !"spdx_text".equalsIgnoreCase(format)) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("sbom.report.changed.format", new Object[0])));
            return "spdx_json";
        }
        return format;
    }
}

