/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.FileUtil;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SAConstants;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SALogger;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SAConfig {
    private final Map<Key, Object> M = new HashMap<Key, Object>();
    private static final Logger logger = SALogger.logger;

    public SAConfig() {
        this.setDefault();
    }

    public void setDefault() {
        this.putValue(Key.SAType, (Object)SAType.valueOf(SAConstants.DEFAULT_SA_TYPE));
        this.putValue(Key.Lang, Language.JAVA);
        this.putValue(Key.ExclusionFile, this.parseFileName("resource://exclusions.java.dat"));
        this.putValue(Key.OutputDir, SAConstants.TMPDIR);
        this.putValue(Key.Log4JConfigFile, this.parseFileName("resource://log4j.xml"));
        this.putValue(Key.OutputFormat, (Object)OutputFormat.valueOf(SAConstants.DEFAULT_OUTPUT_FORMAT));
        this.putValue(Key.TimeLimit, 60L);
    }

    public void printUsage(PrintStream w) {
        this.printUsage(w, null);
    }

    public void printUsage(PrintStream w, String msg) {
        if (msg != null) {
            w.println(msg);
        }
        w.println("Options:");
        w.println("  -scopeFile <scope-file>");
        w.println("  -output <output-file>");
        w.println("  -outputDir <output-dir>");
        w.println("  -pattern <regex-pattern> [:<name>]");
        w.println("  -lang [JAVA|DOTNET]");
        w.println("  -type [CFG|REG|M2L]");
        w.println("  -appName <application-name>");
        w.println("  -candidate <signature>");
        w.println("  -exclusionFile <file>");
        w.println("  -log4jConfigFile <file>");
        w.println("  -outputFormat [XML|CSV]");
        w.println("  -timeLimit <sec>");
    }

    public void printUsageAndExit(PrintStream w, String msg) {
        this.printUsage(w, msg);
        System.exit(0);
    }

    public String[] convertOldFormat(String[] args) {
        String[] keys = new String[]{"-scopeFile", "-pattern", "-lang", "-outputDir", "-candidate"};
        String[] args2 = new String[args.length * 2];
        for (int i = 0; i < args.length; ++i) {
            int j = i * 2;
            args2[j] = keys[i];
            args2[j + 1] = args[i];
        }
        return args2;
    }

    public void parseCommandLine(String[] args) {
        if (args.length == 0) {
            this.printUsageAndExit(System.err, "");
        }
        if (!args[0].startsWith("-")) {
            args = this.convertOldFormat(args);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-scopeFile")) {
                this.putValue(Key.ScopeFile, this.parseFileName(args[++i]));
                continue;
            }
            if (args[i].equals("-pattern")) {
                String name = "user-defined";
                String pat = args[++i];
                if (args[i + 1].startsWith(":")) {
                    name = args[++i].substring(1);
                }
                this.addValue(Key.Pattern, new SASpec(pat, name));
                continue;
            }
            if (args[i].equals("-lang")) {
                if (args[++i].equalsIgnoreCase("JAVA")) {
                    this.putValue(Key.Lang, Language.JAVA);
                    this.putValue(Key.ExclusionFile, this.parseFileName("resource://exclusions.java.dat"));
                    continue;
                }
                if (args[i].equalsIgnoreCase("DOTNET")) {
                    this.putValue(Key.Lang, CLRLanguage.lang);
                    this.putValue(Key.ExclusionFile, this.parseFileName("resource://exclusions.dotnet.dat"));
                    continue;
                }
                this.printUsageAndExit(System.err, "unknown language: " + args[i]);
                continue;
            }
            if (args[i].equals("-type")) {
                this.putValue(Key.SAType, (Object)SAType.valueOf(args[++i]));
                continue;
            }
            if (args[i].equals("-outputDir")) {
                File file;
                if ((file = new File(args[++i])).isDirectory()) {
                    this.putValue(Key.OutputDir, file.getAbsoluteFile());
                    continue;
                }
                this.printUsageAndExit(System.err, file.getName() + " should be a directory.");
                continue;
            }
            if (args[i].equals("-appName")) {
                this.putValue(Key.AppName, args[++i]);
                continue;
            }
            if (args[i].equals("-candidate")) {
                this.addValue(Key.Candidate, args[++i]);
                continue;
            }
            if (args[i].equals("-exclusionFile")) {
                this.putValue(Key.ExclusionFile, this.parseFileName(args[++i]));
                continue;
            }
            if (args[i].equals("-log4jConfigFile")) {
                this.putValue(Key.Log4JConfigFile, this.parseFileName(args[++i]));
                continue;
            }
            if (args[i].equals("-outputFormat")) {
                this.putValue(Key.OutputFormat, (Object)OutputFormat.valueOf(args[++i]));
                continue;
            }
            if (args[i].equals("-outputFile")) {
                this.putValue(Key.OutputFile, new File(args[++i]));
                continue;
            }
            if (args[i].equals("-timeLimit")) {
                this.putValue(Key.TimeLimit, Long.parseLong(args[++i]));
                continue;
            }
            this.printUsageAndExit(System.err, "unknown option: " + args[i]);
        }
        this.postProcess();
    }

    protected void postProcess() {
        if (this.getValue(Key.AppName) == null) {
            String name = this.getScopeFile().getName();
            this.putValue(Key.AppName, name.substring(0, name.lastIndexOf(46)));
        }
        if (this.getValue(Key.OutputFile) == null) {
            String filename = this.getOutputDir().getAbsolutePath() + File.separator + this.getApplicationName() + "." + this.getOutputFormat().toString().toLowerCase();
            this.putValue(Key.OutputFile, new File(filename));
        }
    }

    protected Object getValue(Key key) {
        return this.M.get((Object)key);
    }

    protected void putValue(Key key, Object obj) {
        this.M.put(key, obj);
    }

    protected void addValue(Key key, Object obj) {
        ArrayList o = this.M.get((Object)key);
        if (o == null) {
            o = new ArrayList();
            this.putValue(key, o);
        }
        if (!(o instanceof Collection)) {
            throw new IllegalArgumentException("the value of " + (Object)((Object)key) + " must be a collection, but it is " + o.getClass() + ".");
        }
        Collection c = o;
        c.add(obj);
    }

    protected File parseFileName(String name) {
        if (name.startsWith("resource://")) {
            try {
                return FileUtil.createTempFileForResource(name.replaceFirst("resource://", ""));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.startsWith("file://")) {
            return new File(name.replaceFirst("file://", ""));
        }
        return new File(name);
    }

    public File getExclusionFile() {
        return (File)this.getValue(Key.ExclusionFile);
    }

    public File getOutputDir() {
        return (File)this.getValue(Key.OutputDir);
    }

    public File getOutputFile() {
        return (File)this.getValue(Key.OutputFile);
    }

    public OutputFormat getOutputFormat() {
        return (OutputFormat)((Object)this.getValue(Key.OutputFormat));
    }

    public String getApplicationName() {
        return (String)this.getValue(Key.AppName);
    }

    public Collection<String> getCandidates() {
        return (Collection)this.getValue(Key.Candidate);
    }

    public ILangServices getLangServices() {
        if (this.getValue(Key.Lang).toString().equalsIgnoreCase("JAVA")) {
            return ILangServices.JAVA;
        }
        if (this.getValue(Key.Lang).toString().equalsIgnoreCase("DOTNET")) {
            return ILangServices.DOTNET;
        }
        logger.warn((Object)"String Analysis can only handle Java and DotNet now");
        return null;
    }

    public Collection<SASpec> getPatterns() {
        return (Collection)this.getValue(Key.Pattern);
    }

    public SAType getSAType() {
        return (SAType)((Object)this.getValue(Key.SAType));
    }

    public File getScopeFile() {
        return (File)this.getValue(Key.ScopeFile);
    }

    public File getLog4JConfigFile() {
        return (File)this.getValue(Key.Log4JConfigFile);
    }

    public long getTimeLimit() {
        return (Long)this.getValue(Key.TimeLimit);
    }

    public static enum OutputFormat {
        CSV("csv"),
        XML("xml");

        private final String ext;

        private OutputFormat(String ext) {
            this.ext = ext;
        }

        public String toString() {
            return this.ext;
        }
    }

    public static enum SAType {
        REG,
        CFG,
        M2L;

    }

    public static enum Key {
        ScopeFile,
        Pattern,
        Lang,
        SAType,
        OutputDir,
        AppName,
        Candidate,
        ExclusionFile,
        Log4JConfigFile,
        OutputFormat,
        OutputFile,
        TimeLimit;

    }
}

