/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.wafl;

import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.waflschema.ObjectFactory;
import com.ibm.waflschema.ValidatorMethodType;
import com.ibm.waflschema.ValidatorMethodsType;
import com.ibm.waflschema.ValidatorsType;
import com.ibm.waflschema.WAFLType;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ApplicationResult;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SanitizerKind;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class WAFLMarshaller {
    public static void marshal(ApplicationResult r, OutputStream out) throws JAXBException {
        ObjectFactory f = new ObjectFactory();
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{WAFLType.class});
        WAFLType wafl = f.createWAFLType();
        ValidatorsType validators = f.createValidatorsType();
        ValidatorMethodsType validatorMethods = f.createValidatorMethodsType();
        ValidatorsType.DescriptorDefinitions descriptors = f.createValidatorsTypeDescriptorDefinitions();
        wafl.setValidators(validators);
        validators.setValidatorMethods(validatorMethods);
        validators.setDescriptorDefinitions(descriptors);
        for (String sig : r.getMethods()) {
            ValidatorMethodType validator = f.createValidatorMethodType();
            String vdbsig = VDBJavaUtil.jvmToVDBSignature((String)sig).replace("&lt;", "<").replace("&gt;", ">");
            validator.setSignature(vdbsig);
            List<ValidatorMethodType.DescriptorRef> descs = validator.getDescriptorRef();
            Map<SASpec, SanitizerKind> m = r.getMethodInfo(sig);
            for (Map.Entry<SASpec, SanitizerKind> e : m.entrySet()) {
                SASpec spec = e.getKey();
                SanitizerKind kind = e.getValue();
                if (!kind.isSanitizerOrValidator()) continue;
                ValidatorMethodType.DescriptorRef desc = new ValidatorMethodType.DescriptorRef();
                desc.setName(spec.getName());
                descs.add(desc);
            }
            if (descs.isEmpty()) continue;
            validatorMethods.getMethod().add(validator);
        }
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(f.createWafl(wafl), out);
    }
}

