/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.handlers;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.handlers.JAXAbstractLocalHandler;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.handlers.JAXRSRestAPIMethodsHandler;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.JAXUtils;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.JAXApp;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.JaxRSResource;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class JAXHandler
extends F4FHandler {
    final Logger logger = TaintLogger.i().getLogger();

    public void handleApp(F4FApp app, F4FActions actions) {
        IClass pathClass = app.getIClass("javax.ws.rs.Path");
        if (pathClass == null) {
            pathClass = this.findPathAnnotationClass(app);
        }
        if (pathClass == null) {
            this.logger.info((Object)Messages.getString((String)"framework.missing", (Object[])new Object[]{"javax.ws.rs.Path"}));
            this.logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JAX-RS"}));
            return;
        }
        this.logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"JAX-RS", "handleApp()"}));
        JAXApp jaxApp = JAXUtils.constructJAXApp(app);
        FrameworksInput input = this.getFrameworksInput();
        String scopeFileName = input.getFileLocs().getScopeFileName();
        ArrayList<JAXRSRestAPIMethodsHandler> firstLevelHandlers = new ArrayList<JAXRSRestAPIMethodsHandler>();
        firstLevelHandlers.add(new JAXRSRestAPIMethodsHandler(scopeFileName));
        for (JAXAbstractLocalHandler jAXAbstractLocalHandler : firstLevelHandlers) {
            for (JaxRSResource rootResoruce : jaxApp.getRootResources()) {
                IClass clazz = rootResoruce.getIClass();
                if (!jAXAbstractLocalHandler.provides(jaxApp, clazz).booleanValue()) continue;
                this.logger.info((Object)Messages.getString((String)"framework.processing.class", (Object[])new Object[]{clazz.getName().toString()}));
                jAXAbstractLocalHandler.handleClass(clazz, jaxApp, actions);
            }
        }
        this.logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JAX-RS"}));
    }

    public boolean isApplicable() {
        this.logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"JAX-RS", "isApplicable()"}));
        FrameworksInput input = this.getFrameworksInput();
        if (input.getType().equals("Java")) {
            this.logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
            return true;
        }
        this.logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
        this.logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JAX-RS"}));
        return false;
    }

    private IClass findPathAnnotationClass(F4FApp app) {
        Collection appClazzList = app.getAllApplicationClasses();
        for (IClass clazz : appClazzList) {
            Collection annotationList = app.getClassAnnotations(clazz);
            for (Annotation annotation : annotationList) {
                if (!annotation.getType().getName().toString().equals("Ljavax/ws/rs/Path")) continue;
                return clazz;
            }
        }
        return null;
    }
}

