/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.handlers;

import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.handlers.JAXAbstractLocalHandler;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.JAXUtils;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.ContextResolverProvider;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.JAXApp;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.JaxRSResource;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.MessageBodyReaderProvider;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.MessageBodyWriterProvider;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.generics.ClassTypeSignature;
import com.ibm.wala.types.generics.MethodTypeSignature;
import com.ibm.wala.types.generics.TypeArgument;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class JAXRSRestAPIMethodsHandler
extends JAXAbstractLocalHandler {
    private static final String PARAM_NAME = "param";
    private static int paramIndex;
    private String scopeFileName;
    private ArrayList<String> sourceDirectoryList = null;
    final Logger logger = TaintLogger.i().getLogger();

    public JAXRSRestAPIMethodsHandler(String scopeFileName) {
        this.scopeFileName = scopeFileName;
    }

    @Override
    public void handleClass(IClass clazz, JAXApp app, F4FActions actions) {
        JaxRSResource classRes = app.getResource(clazz);
        for (IMethod method : classRes.getSupportedMethods()) {
            this.logger.info((Object)Messages.getString((String)"framework.processing.method", (Object[])new Object[]{method.getName().toString()}));
            ArrayList<IMethod> callStack = new ArrayList<IMethod>();
            if (clazz.isInterface()) {
                for (IClass c : method.getClassHierarchy().getImplementors(clazz.getReference())) {
                    if (c.getMethod(method.getSelector()) == null) continue;
                    callStack.add(c.getMethod(method.getSelector()));
                }
            } else {
                callStack.add(method);
            }
            this.handleRestAPI(app, method, callStack, actions);
        }
    }

    private void handleRestAPI(JAXApp app, IMethod method, ArrayList<IMethod> callStack, F4FActions actions) {
        Collection<IMethod> subResourceHttpMethods;
        if (!app.isSubResourceLocator(method)) {
            this.createSyntheticMethod(app, callStack, actions);
            return;
        }
        TypeReference returnType = method.getReturnType();
        IClass returnTypeClazz = method.getClassHierarchy().lookupClass(returnType);
        JaxRSResource classRes = app.getResource(returnTypeClazz);
        Collection<IMethod> collection = subResourceHttpMethods = classRes != null ? classRes.getSupportedMethods() : JAXUtils.getJAXRSHttpMethods(app.getApp(), returnTypeClazz);
        if (subResourceHttpMethods.size() == 0) {
            this.createSyntheticMethod(app, callStack, actions);
            return;
        }
        for (IMethod subResourceMethod : subResourceHttpMethods) {
            callStack.add(subResourceMethod);
            this.handleRestAPI(app, subResourceMethod, callStack, actions);
            int removeIndex = callStack.size() - 1;
            callStack.remove(removeIndex);
        }
    }

    private Local insertCallToReaderProvider(Object provider, IClass typeClass, HighLevelSyntheticMethod synthMethod) {
        if (provider instanceof MessageBodyReaderProvider) {
            MessageBodyReaderProvider readProvider = (MessageBodyReaderProvider)provider;
            this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{readProvider.getIClass().getName().toString()}));
            Local readProviderObject = synthMethod.newLocal(readProvider.getIClass());
            Object[] isReadableTaintedParams = new Param[readProvider.getIsReadableIMethod().getNumberOfParameters()];
            Arrays.fill(isReadableTaintedParams, null);
            isReadableTaintedParams[0] = readProviderObject;
            this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{readProvider.getIsReadableIMethod().getSignature()}));
            synthMethod.addCall(readProvider.getIsReadableIMethod(), JavaUtils.getMethodPosition((IMethod)readProvider.getIsReadableIMethod(), this.getSourceDirectoryList()), (Param[])isReadableTaintedParams);
            int count = readProvider.getReadFromIMethod().getNumberOfParameters();
            Object[] readFromTaintedParams = new Param[count];
            Arrays.fill(readFromTaintedParams, null);
            readFromTaintedParams[0] = readProviderObject;
            this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, count - 1}));
            readFromTaintedParams[count - 1] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
            this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, count - 2}));
            readFromTaintedParams[count - 2] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
            this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{readProvider.getReadFromIMethod().getSignature()}));
            return synthMethod.addCall(readProvider.getReadFromIMethod(), JavaUtils.getMethodPosition((IMethod)readProvider.getReadFromIMethod(), this.getSourceDirectoryList()), (Param[])readFromTaintedParams);
        }
        if (provider instanceof ContextResolverProvider) {
            ContextResolverProvider contextResolverProvider = (ContextResolverProvider)provider;
            this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{contextResolverProvider.getIClass().getName().toString()}));
            Local contextResolverProviderObject = synthMethod.newLocal(contextResolverProvider.getIClass());
            Object[] getContextTaintedParams = new Param[contextResolverProvider.getGetContextIMethod().getNumberOfParameters()];
            Arrays.fill(getContextTaintedParams, null);
            getContextTaintedParams[0] = contextResolverProviderObject;
            this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{contextResolverProvider.getGetContextIMethod().getSignature()}));
            return synthMethod.addCall(contextResolverProvider.getGetContextIMethod(), JavaUtils.getMethodPosition((IMethod)contextResolverProvider.getGetContextIMethod(), this.getSourceDirectoryList()), (Param[])getContextTaintedParams);
        }
        return null;
    }

    private void insertCallToWriterProvider(Object provider, IClass typeClass, HighLevelSyntheticMethod synthMethod, Local objInstance) {
        if (provider instanceof MessageBodyWriterProvider) {
            MessageBodyWriterProvider writeProvider = (MessageBodyWriterProvider)provider;
            this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{writeProvider.getIClass().getName().toString()}));
            Local writeProviderObject = synthMethod.newLocal(writeProvider.getIClass());
            Object[] isWritableTaintedParams = new Param[writeProvider.getIsWritableIMethod().getNumberOfParameters()];
            Arrays.fill(isWritableTaintedParams, null);
            isWritableTaintedParams[0] = writeProviderObject;
            this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{writeProvider.getIsWritableIMethod().getSignature()}));
            synthMethod.addCall(writeProvider.getIsWritableIMethod(), JavaUtils.getMethodPosition((IMethod)writeProvider.getIsWritableIMethod(), this.getSourceDirectoryList()), (Param[])isWritableTaintedParams);
            Object[] getSizeTaintedParams = new Param[writeProvider.getGetSizeIMethod().getNumberOfParameters()];
            Arrays.fill(getSizeTaintedParams, null);
            getSizeTaintedParams[0] = writeProviderObject;
            getSizeTaintedParams[1] = objInstance;
            this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{writeProvider.getGetSizeIMethod().getSignature()}));
            synthMethod.addCall(writeProvider.getGetSizeIMethod(), JavaUtils.getMethodPosition((IMethod)writeProvider.getGetSizeIMethod(), this.getSourceDirectoryList()), (Param[])getSizeTaintedParams);
            int count = writeProvider.getWriteToIMethod().getNumberOfParameters();
            Object[] writeToTaintedParams = new Param[count];
            Arrays.fill(writeToTaintedParams, null);
            writeToTaintedParams[0] = writeProviderObject;
            writeToTaintedParams[1] = objInstance;
            this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, count - 1}));
            writeToTaintedParams[count - 1] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
            this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, count - 2}));
            writeToTaintedParams[count - 2] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
            this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{writeProvider.getWriteToIMethod().getSignature()}));
            synthMethod.addCall(writeProvider.getWriteToIMethod(), JavaUtils.getMethodPosition((IMethod)writeProvider.getWriteToIMethod(), this.getSourceDirectoryList()), (Param[])writeToTaintedParams);
        }
    }

    private void addReadProvidersCall(JAXApp app, IMethod method, int paramIndex, Param[] methodParams, HighLevelSyntheticMethod synthMethod) {
        TypeReference type = method.getParameterType(paramIndex);
        IClass typeClass = method.getClassHierarchy().lookupClass(type);
        if (typeClass != null) {
            Object provider = app.getReadProvider(typeClass);
            if (provider == null) {
                provider = app.getContextResolverProvider(typeClass);
            }
            if (provider != null) {
                Local output = this.insertCallToReaderProvider(provider, typeClass, synthMethod);
                if (output != null) {
                    methodParams[paramIndex] = output;
                }
                return;
            }
        }
    }

    private void addWriteProvidersCall(JAXApp app, IMethod method, HighLevelSyntheticMethod synthMethod, Local objInstance) {
        MessageBodyWriterProvider provider;
        TypeReference type = method.getReturnType();
        IClass typeClass = method.getClassHierarchy().lookupClass(type);
        if (typeClass != null && (provider = app.getWriteProvider(typeClass)) != null) {
            this.insertCallToWriterProvider(provider, typeClass, synthMethod, objInstance);
            return;
        }
    }

    private String getPathValue(F4FApp app, Object element) {
        IClass c;
        AnnotationsReader.ElementValue val;
        String pathValue = null;
        Annotation annotation = JAXUtils.getAnnotation(app, element, "Ljavax/ws/rs/Path");
        if (annotation != null && annotation.getNamedArguments() != null && (val = (AnnotationsReader.ElementValue)annotation.getNamedArguments().get("value")) != null) {
            pathValue = val.toString();
        }
        if (pathValue == null && element instanceof IClass && (c = (IClass)element).getAllImplementedInterfaces() != null && c.getAllImplementedInterfaces().size() > 0) {
            for (IClass i : c.getAllImplementedInterfaces()) {
                pathValue = this.getPathValue(app, i);
                if (pathValue == null) continue;
                return pathValue;
            }
        }
        return pathValue;
    }

    private String generateName(F4FApp app, ArrayList<IMethod> callStack) {
        String name = "";
        if (callStack.size() > 0) {
            IMethod firstMethod = callStack.get(0);
            IClass fistClass = firstMethod.getDeclaringClass();
            name = name + this.getPathValue(app, fistClass);
            for (IMethod method : callStack) {
                String path = this.getPathValue(app, method);
                if (path == null) {
                    path = method.getName().toString();
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path != null && !path.isEmpty()) {
                    name = name + "_" + path;
                    continue;
                }
                name = name + "_";
            }
            if (name.isEmpty()) {
                name = "RestMethod";
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            name = name.replaceAll("\\{", "");
            name = name.replaceAll("\\}", "");
            name = JAXUtils.getJavaName(name);
            IMethod lastMethod = callStack.get(callStack.size() - 1);
            if (JAXUtils.hasAnnotation(app, lastMethod, "Ljavax/ws/rs/GET").booleanValue()) {
                name = "get_" + name;
            } else if (JAXUtils.hasAnnotation(app, lastMethod, "Ljavax/ws/rs/PUT").booleanValue()) {
                name = "put_" + name;
            } else if (JAXUtils.hasAnnotation(app, lastMethod, "Ljavax/ws/rs/POST").booleanValue()) {
                name = "post_" + name;
            } else if (JAXUtils.hasAnnotation(app, lastMethod, "Ljavax/ws/rs/DELETE").booleanValue()) {
                name = "delete_" + name;
            }
        }
        name = "AppScan.Synthetic.JAXRS." + name;
        name = name + "():void";
        return name;
    }

    private void handleContextElements(JAXApp app, HighLevelSyntheticMethod synthMethod, Local objInstance, IMethod method) {
        JaxRSResource classResource = app.getResource(method.getDeclaringClass());
        if (classResource != null) {
            Local element;
            Object[] getContextParams;
            Local readProviderObject;
            IClass typeClass;
            TypeReference type;
            for (IField field : classResource.getContextFields()) {
                ContextResolverProvider contextResolverProvider;
                type = field.getFieldTypeReference();
                if (type != null && (typeClass = method.getClassHierarchy().lookupClass(type)) != null && (contextResolverProvider = app.getContextResolverProvider(typeClass)) != null) {
                    this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{contextResolverProvider.getIClass().getName().toString()}));
                    readProviderObject = synthMethod.newLocal(contextResolverProvider.getIClass());
                    getContextParams = new Param[contextResolverProvider.getGetContextIMethod().getNumberOfParameters()];
                    Arrays.fill(getContextParams, null);
                    getContextParams[0] = readProviderObject;
                    this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{contextResolverProvider.getGetContextIMethod().getSignature()}));
                    element = synthMethod.addCall(contextResolverProvider.getGetContextIMethod(), JavaUtils.getMethodPosition((IMethod)contextResolverProvider.getGetContextIMethod(), this.getSourceDirectoryList()), (Param[])getContextParams);
                    this.logger.info((Object)Messages.getString((String)"framework.generate.write", (Object[])new Object[]{method.getDeclaringClass().getName().toString() + "." + field.getName().toString()}));
                    synthMethod.addInstanceVariableWrite(objInstance, field, (Param)element, null);
                    continue;
                }
                this.logger.info((Object)Messages.getString((String)"framework.taint.found", (Object[])new Object[]{PARAM_NAME + paramIndex}));
                this.logger.info((Object)Messages.getString((String)"framework.generate.write", (Object[])new Object[]{method.getDeclaringClass().getName().toString() + "." + field.getName().toString()}));
                synthMethod.addInstanceVariableWrite(objInstance, field, (Param)Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++)), null);
            }
            for (IMethod contextMethod : classResource.getContextMethods()) {
                ContextResolverProvider contextResolverProvider;
                type = contextMethod.getParameterType(1);
                if (type != null && (typeClass = contextMethod.getClassHierarchy().lookupClass(type)) != null && (contextResolverProvider = app.getContextResolverProvider(typeClass)) != null) {
                    this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{contextResolverProvider.getIClass().getName().toString()}));
                    readProviderObject = synthMethod.newLocal(contextResolverProvider.getIClass());
                    getContextParams = new Param[contextResolverProvider.getGetContextIMethod().getNumberOfParameters()];
                    Arrays.fill(getContextParams, null);
                    getContextParams[0] = readProviderObject;
                    this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{typeClass.getName().toString()}));
                    element = synthMethod.newLocal(typeClass);
                    this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{contextResolverProvider.getGetContextIMethod().getSignature()}));
                    element = synthMethod.addCall(contextResolverProvider.getGetContextIMethod(), JavaUtils.getMethodPosition((IMethod)contextResolverProvider.getGetContextIMethod(), this.getSourceDirectoryList()), (Param[])getContextParams);
                    Param[] methodParams = new Param[contextMethod.getNumberOfParameters()];
                    for (int i = 0; i < contextMethod.getNumberOfParameters(); ++i) {
                        this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, i}));
                        methodParams[i] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
                    }
                    methodParams[0] = objInstance;
                    methodParams[1] = element;
                    this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{contextMethod.getSignature()}));
                    synthMethod.addCall(contextMethod, JavaUtils.getMethodPosition((IMethod)contextMethod, this.getSourceDirectoryList()), methodParams);
                    continue;
                }
                Param[] methodParams = new Param[contextMethod.getNumberOfParameters()];
                for (int i = 0; i < contextMethod.getNumberOfParameters(); ++i) {
                    this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, i}));
                    methodParams[i] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
                }
                methodParams[0] = objInstance;
                this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{contextMethod.getSignature()}));
                synthMethod.addCall(contextMethod, JavaUtils.getMethodPosition((IMethod)contextMethod, this.getSourceDirectoryList()), methodParams);
            }
        }
    }

    private void createSyntheticMethod(JAXApp app, ArrayList<IMethod> callStack, F4FActions actions) {
        paramIndex = 0;
        String name = this.generateName(app.getApp(), callStack);
        this.logger.info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{name}));
        HighLevelSyntheticMethod synthMethod = HighLevelSyntheticMethod.make((String)name);
        Local objInstance = null;
        IMethod firstMethod = null;
        IMethod lastMethod = null;
        if (callStack.size() > 0) {
            firstMethod = callStack.get(0);
            lastMethod = callStack.get(callStack.size() - 1);
        }
        for (IMethod methodCall : callStack) {
            int i;
            this.logger.info((Object)Messages.getString((String)"framework.processing.method", (Object[])new Object[]{methodCall.getName().toString()}));
            if (objInstance == null) {
                this.logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{methodCall.getDeclaringClass().getName().toString()}));
                objInstance = synthMethod.newLocal(methodCall.getDeclaringClass());
            }
            this.handleContextElements(app, synthMethod, objInstance, methodCall);
            Param[] methodParams = new Param[methodCall.getNumberOfParameters()];
            for (i = 0; i < methodCall.getNumberOfParameters(); ++i) {
                this.logger.info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{PARAM_NAME + paramIndex, i}));
                methodParams[i] = Taint.taintWithParamName((String)(PARAM_NAME + paramIndex++));
            }
            methodParams[0] = objInstance;
            if (firstMethod == methodCall) {
                for (i = 1; i < methodCall.getNumberOfParameters(); ++i) {
                    this.addReadProvidersCall(app, methodCall, i, methodParams, synthMethod);
                }
            }
            FilePositionInfo posInfo = JavaUtils.getMethodPosition((IMethod)methodCall, this.getSourceDirectoryList());
            this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{methodCall.getSignature()}));
            objInstance = synthMethod.addCall(methodCall, posInfo, methodParams);
        }
        if (lastMethod != null) {
            this.addWriteProvidersCall(app, lastMethod, synthMethod, objInstance);
            if (objInstance != null) {
                Local printWriterObj = synthMethod.newLocal("java.io.PrintWriter");
                TypeReference rt = lastMethod.getReturnType();
                if (rt != null) {
                    IClass rtClass = lastMethod.getClassHierarchy().lookupClass(rt);
                    if (rtClass != null) {
                        String genericType = this.findGenericType(lastMethod);
                        if (genericType == null) {
                            if (rtClass.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                                this.serializeResource(app, lastMethod, synthMethod, rtClass, objInstance, printWriterObj, new HashSet<IClass>());
                            } else {
                                this.serializeSimpleObject(app, lastMethod, synthMethod, rt.getName().toString(), objInstance, printWriterObj, new HashSet<IClass>());
                            }
                        } else if (JAXUtils.doesExtendClass(rtClass, "Ljava/util/Collection").booleanValue()) {
                            IClass genClass = app.getApp().getIClass(genericType);
                            if (genClass != null) {
                                this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Collection.iterator():java.util.Iterator"}));
                                Local iteratorObj = synthMethod.addCall("java.util.Collection.iterator():java.util.Iterator", JavaUtils.getMethodPosition((IMethod)lastMethod, this.sourceDirectoryList), new Param[]{objInstance});
                                this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Iterator.next():java.lang.Object"}));
                                Local obj = synthMethod.addCall("java.util.Iterator.next():java.lang.Object", JavaUtils.getMethodPosition((IMethod)lastMethod, this.sourceDirectoryList), new Param[]{iteratorObj});
                                if (genClass.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                                    this.serializeResource(app, lastMethod, synthMethod, genClass, obj, printWriterObj, new HashSet<IClass>());
                                } else {
                                    this.serializeSimpleObject(app, lastMethod, synthMethod, genericType, obj, printWriterObj, new HashSet<IClass>());
                                }
                            } else {
                                this.serializeSimpleObject(app, lastMethod, synthMethod, genericType, objInstance, printWriterObj, new HashSet<IClass>());
                            }
                        } else {
                            this.serializeSimpleObject(app, lastMethod, synthMethod, rt.getName().toString(), objInstance, printWriterObj, new HashSet<IClass>());
                        }
                    } else {
                        this.serializeSimpleObject(app, lastMethod, synthMethod, rt.getName().toString(), objInstance, printWriterObj, new HashSet<IClass>());
                    }
                }
            }
        }
        this.logger.info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{synthMethod.getVdbSignature()}));
        actions.addHighLevelSyntheticMethod(synthMethod, true);
    }

    private String getPrintMethodVDBSignature(String type) {
        if (type.equals(TypeReference.IntName.toString())) {
            return "java.io.PrintWriter.print(int):void";
        }
        if (type.equals(TypeReference.BooleanName.toString())) {
            return "java.io.PrintWriter.print(boolean):void";
        }
        if (type.equals(TypeReference.CharName.toString())) {
            return "java.io.PrintWriter.print(char):void";
        }
        if (type.equals(TypeReference.LongName.toString())) {
            return "java.io.PrintWriter.print(long):void";
        }
        if (type.equals(TypeReference.FloatName.toString())) {
            return "java.io.PrintWriter.print(float):void";
        }
        if (type.equals(TypeReference.DoubleName.toString())) {
            return "java.io.PrintWriter.print(double):void";
        }
        if (type.equals("[" + TypeReference.CharName.toString())) {
            return "java.io.PrintWriter.print(char[]):void";
        }
        if (type.equals("Ljava/lang/String")) {
            return "java.io.PrintWriter.print(java.lang.String):void";
        }
        return "java.io.PrintWriter.print(java.lang.Object):void";
    }

    private String findGenericType(IMethod method) {
        if (method instanceof ShrikeCTMethod) {
            try {
                ClassTypeSignature cts;
                TypeSignature rts;
                MethodTypeSignature methodSignature = ((ShrikeCTMethod)method).getMethodTypeSignature();
                if (methodSignature != null && methodSignature.getReturnType() != null && (rts = methodSignature.getReturnType()) instanceof ClassTypeSignature && (cts = (ClassTypeSignature)rts).getTypeArguments() != null && cts.getTypeArguments().length == 1) {
                    TypeArgument firstType = cts.getTypeArguments()[0];
                    String javaName = JAXUtils.convertToSimpleName(firstType.toString());
                    return javaName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void serializeSimpleObject(JAXApp app, IMethod lastMethod, HighLevelSyntheticMethod synthMethod, String returnType, Local objInstance, Local printWriterObj, Set<IClass> serializedClasses) {
        this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{this.getPrintMethodVDBSignature(returnType)}));
        synthMethod.addCall(this.getPrintMethodVDBSignature(returnType), JavaUtils.getMethodPosition((IMethod)lastMethod, this.sourceDirectoryList), new Param[]{printWriterObj, objInstance});
    }

    private void serializeResource(JAXApp app, IMethod lastMethod, HighLevelSyntheticMethod synthMethod, IClass returnIClass, Local objInstance, Local printWriterObj, Set<IClass> serializedClasses) {
        if (returnIClass != null) {
            if (serializedClasses.contains(returnIClass)) {
                return;
            }
            serializedClasses.add(returnIClass);
            if (returnIClass.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                serializedClasses.add(returnIClass);
                for (IMethod getMethod : returnIClass.getDeclaredMethods()) {
                    String methodName = getMethod.getName().toString();
                    if (!methodName.startsWith("get") && !methodName.startsWith("is") || getMethod.getNumberOfParameters() != 1 || getMethod.getReturnType() == null || !getMethod.isPublic()) continue;
                    this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{getMethod.getSignature()}));
                    Local ret = synthMethod.addCall(getMethod, JavaUtils.getMethodPosition((IMethod)getMethod, this.getSourceDirectoryList()), new Param[]{objInstance});
                    TypeReference retType = getMethod.getReturnType();
                    if (retType == null) continue;
                    IClass retClass = getMethod.getClassHierarchy().lookupClass(retType);
                    if (retType.isClassType()) {
                        String genClassName;
                        if (JAXUtils.findInderface(retClass, "Ljava/util/Collection") != null && (genClassName = this.findGenericType(getMethod)) != null) {
                            IClass genClass = app.getApp().getIClass(genClassName);
                            if (genClass != null && JAXUtils.doesExtendClass(retClass, "Ljava/util/Collection").booleanValue()) {
                                this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Collection.iterator():java.util.Iterator"}));
                                Local iteratorObj = synthMethod.addCall("java.util.Collection.iterator():java.util.Iterator", JavaUtils.getMethodPosition((IMethod)lastMethod, this.sourceDirectoryList), new Param[]{ret});
                                this.logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Iterator.next():java.lang.Object"}));
                                Local obj = synthMethod.addCall("java.util.Iterator.next():java.lang.Object", JavaUtils.getMethodPosition((IMethod)lastMethod, this.sourceDirectoryList), new Param[]{iteratorObj});
                                if (retClass.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                                    this.serializeResource(app, lastMethod, synthMethod, retClass, obj, printWriterObj, serializedClasses);
                                    continue;
                                }
                                this.serializeSimpleObject(app, lastMethod, synthMethod, genClassName, obj, printWriterObj, serializedClasses);
                                continue;
                            }
                            this.serializeSimpleObject(app, lastMethod, synthMethod, retClass.getName().toString(), ret, printWriterObj, serializedClasses);
                        }
                        if (retClass.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                            this.serializeResource(app, lastMethod, synthMethod, retClass, ret, printWriterObj, serializedClasses);
                            continue;
                        }
                        this.serializeSimpleObject(app, lastMethod, synthMethod, retClass.getName().toString(), ret, printWriterObj, serializedClasses);
                        continue;
                    }
                    this.serializeSimpleObject(app, lastMethod, synthMethod, retType.getName().toString(), ret, printWriterObj, serializedClasses);
                }
                return;
            }
            this.serializeSimpleObject(app, lastMethod, synthMethod, returnIClass.getName().toString(), objInstance, printWriterObj, serializedClasses);
        }
    }

    public ArrayList<String> getSourceDirectoryList() {
        if (this.sourceDirectoryList == null) {
            this.sourceDirectoryList = JavaUtils.retrieveSourceDirectoryList((String)this.scopeFileName);
        }
        return this.sourceDirectoryList;
    }
}

