/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton;

import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LabeledString
extends Pair<String, ILabelSymbol> {
    protected LabeledString(String str, ILabelSymbol label) {
        super((Object)str, (Object)label);
    }

    public static LabeledString make(String str, ILabelSymbol label) {
        return new LabeledString(str, label);
    }

    public static LabeledString make(String str) {
        return new LabeledString(str, ILabelSymbol.BOTTOM);
    }

    public static LabeledString concat(LabeledString ... lstrs) {
        LabeledString r = LabeledString.make("");
        for (int i = 0; i < lstrs.length; ++i) {
            r = r.concat(lstrs[i]);
        }
        return r;
    }

    public static <T extends Collection<String>> T strings(Collection<LabeledString> lstrs, T result) {
        if (lstrs == null) {
            return null;
        }
        for (LabeledString lstr : lstrs) {
            result.add((String)lstr.getString());
        }
        return result;
    }

    public static Set<LabeledString> reduce(Collection<LabeledString> c) {
        if (c == null) {
            return null;
        }
        HashMap<String, ILabelSymbol> m = new HashMap<String, ILabelSymbol>();
        for (LabeledString ls : c) {
            String s = ls.getString();
            ILabelSymbol l = (ILabelSymbol)m.get(s);
            if (l == null) {
                l = ILabelSymbol.BOTTOM;
            }
            l = l.meet(ls.getLabel());
            m.put(s, l);
        }
        HashSet<LabeledString> r = new HashSet<LabeledString>();
        for (Map.Entry e : m.entrySet()) {
            LabeledString ls = LabeledString.make((String)e.getKey(), (ILabelSymbol)e.getValue());
            r.add(ls);
        }
        return r;
    }

    public String getString() {
        return (String)this.fst;
    }

    public ILabelSymbol getLabel() {
        return (ILabelSymbol)this.snd;
    }

    public LabeledString concat(LabeledString str) {
        return LabeledString.make(this.getString().concat(str.getString()), this.getLabel().meet(str.getLabel()));
    }

    public LabeledString concat(String str) {
        return LabeledString.make(this.getString().concat(str), this.getLabel());
    }

    public String toString() {
        return this.getString() + ":" + this.getLabel().toString();
    }
}

