/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.grammar.string.CFLReachability;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.ICFGSymbol;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.regex.string.StringPatternSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.StringSymbol;

public class CFGSymbol
implements ICFGSymbol,
ILanguageSymbol<IContextFreeGrammar> {
    private IContextFreeGrammar cfg;

    public CFGSymbol(IContextFreeGrammar cfg) {
        this.cfg = cfg;
    }

    @Override
    public IContextFreeGrammar getGrammar() {
        return this.cfg;
    }

    @Override
    public IContextFreeGrammar getLanguage() {
        return this.cfg;
    }

    @Override
    public String getName() {
        return this.cfg.toString();
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof StringPatternSymbol) {
            return false;
        }
        if (symbol instanceof StringSymbol) {
            StringSymbol ss = (StringSymbol)symbol;
            return CFLReachability.containsSome(this.cfg, ss.toCharSymbols(), AUtil.nullProgressMonitor);
        }
        if (symbol instanceof CFGSymbol) {
            CFGSymbol cfgSym = (CFGSymbol)symbol;
            if (this.cfg.equals(cfgSym.getGrammar())) {
                context.put(this, symbol);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof StringPatternSymbol) {
            StringPatternSymbol sps = (StringPatternSymbol)symbol;
            if (CFLReachability.containsSome(this.cfg, sps.getCompiledPattern(), AUtil.nullProgressMonitor)) {
                return true;
            }
            IAutomaton fst = Grammars.toAutomaton(this.cfg);
            return CFLReachability.containsSome(Grammars.toCFG(sps.getCompiledPattern()), fst, AUtil.nullProgressMonitor);
        }
        if (symbol instanceof StringSymbol) {
            StringSymbol ss = (StringSymbol)symbol;
            return CFLReachability.containsSome(this.cfg, ss.toCharSymbols(), AUtil.nullProgressMonitor);
        }
        if (symbol instanceof CFGSymbol) {
            CFGSymbol cfg2 = (CFGSymbol)symbol;
            IAutomaton fst2 = Grammars.toAutomaton(cfg2.getGrammar());
            if (CFLReachability.containsSome(this.cfg, fst2, AUtil.nullProgressMonitor)) {
                return true;
            }
            IAutomaton fst = Grammars.toAutomaton(this.cfg);
            return CFLReachability.containsSome(cfg2.getGrammar(), fst, AUtil.nullProgressMonitor);
        }
        return false;
    }

    public int hashCode() {
        return this.cfg.hashCode();
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        CFGSymbol cfgSym = (CFGSymbol)obj;
        return this.cfg.equals(cfgSym.cfg);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof CFGSymbol) {
            CFGSymbol cfgSym = (CFGSymbol)s;
            if (copier instanceof IGrammarCopier) {
                IGrammarCopier gCopier = (IGrammarCopier)copier;
                cfgSym.cfg = (IContextFreeGrammar)gCopier.copy(cfgSym.cfg);
            }
        }
        return s;
    }

    public String toString() {
        return "CFGSymbol(" + this.cfg.toString() + ")";
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return 0;
    }
}

