/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.tree;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.tree.IRTLComparator;
import com.ibm.wala.automaton.grammar.tree.ITreeGrammar;
import com.ibm.wala.automaton.grammar.tree.TreeGrammar;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.MatchContext;
import com.ibm.wala.automaton.tree.BinaryTree;
import com.ibm.wala.automaton.tree.BinaryTreeVariable;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeVariable;
import com.ibm.wala.automaton.tree.IParentBinaryTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RTLComparator
implements IRTLComparator {
    public static boolean debug = false;
    public static RTLComparator defaultComparator = new RTLComparator();

    @Override
    public int compare(ITreeGrammar tg1, ITreeGrammar tg2) {
        if (this.check(tg1, tg2)) {
            if (this.check(tg2, tg1)) {
                return 0;
            }
            return -1;
        }
        if (this.check(tg2, tg1)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean contains(ITreeGrammar g1, ITreeGrammar g2) {
        return this.check(g2, g1);
    }

    public boolean check(ITreeGrammar g1, ITreeGrammar g2) {
        Context ctx = new Context(g1, g2);
        return this.check((IBinaryTreeVariable)g1.getStartSymbol(), (IBinaryTreeVariable)g2.getStartSymbol(), ctx);
    }

    private boolean check(IBinaryTree t1, IBinaryTree t2, Context ctx) {
        this.trace("check", t1, t2, ctx);
        if (this.checkHyp(t1, t2, ctx)) {
            return true;
        }
        return this.checkAssum(t1, t2, ctx);
    }

    private boolean checkHyp(IBinaryTree t1, IBinaryTree t2, Context ctx) {
        this.trace("checkHyp", t1, t2, ctx);
        Subtype subtype = new Subtype(t1, t2);
        return ctx.contains(subtype);
    }

    private boolean checkAssum(IBinaryTree t1, IBinaryTree t2, Context ctx) {
        this.trace("checkAssum", t1, t2, ctx);
        Subtype subtype = new Subtype(t1, t2);
        Context ctx2 = ctx.dup();
        ctx2.add(subtype);
        if (this.check2(t1, t2, ctx2)) {
            ctx.addContext(ctx2);
            return true;
        }
        return false;
    }

    private boolean check2(IBinaryTree t1, IBinaryTree t2, Context ctx) {
        this.trace("check2(IBinaryTree,IBinaryTree)", t1, t2, ctx);
        HashSet<IBinaryTree> l2 = new HashSet<IBinaryTree>();
        l2.add(t2);
        return this.check2(t1, l2, ctx);
    }

    private boolean check2(Set<IBinaryTree> t1, Set<IBinaryTree> t2, Context ctx) {
        this.trace("check2(Set,Set)", t1, t2, ctx);
        switch (t1.size()) {
            case 0: {
                return this.checkEmpty(t1, t2, ctx);
            }
            case 1: {
                IBinaryTree u1 = this.pop(t1);
                return this.check2(u1, t2, ctx);
            }
        }
        return this.checkSplit(t1, t2, ctx);
    }

    private boolean check2(IBinaryTree t1, Set<IBinaryTree> t2, Context ctx) {
        this.trace("check2(IBinaryTree,Set)", t1, t2, ctx);
        if (t1 instanceof IBinaryTreeVariable) {
            Set<IBinaryTree> l1 = ctx.getLeftTrees((IBinaryTreeVariable)t1);
            return this.check2(l1, t2, ctx);
        }
        if (t1 instanceof IParentBinaryTree) {
            return this.checkRec((IParentBinaryTree)t1, t2, ctx);
        }
        return this.checkLeaf(t1, t2, ctx);
    }

    private boolean checkEmpty(Set<IBinaryTree> t1, Set<IBinaryTree> t2, Context ctx) {
        this.trace("checkEmpty", t1, t2, ctx);
        if (t1.isEmpty()) {
            Subtype subtype = new Subtype(t1, t2);
            ctx.add(subtype);
            return true;
        }
        return false;
    }

    private boolean checkSplit(Set<IBinaryTree> t1, Set<IBinaryTree> t2, Context ctx) {
        this.trace("checkSplit", t1, t2, ctx);
        HashSet<IBinaryTree> tl1 = new HashSet<IBinaryTree>(t1);
        IBinaryTree hd1 = this.pop(tl1);
        Context ctx2 = ctx.dup();
        if (this.check2(hd1, t2, ctx2) && this.check2(tl1, t2, ctx2)) {
            ctx.addContext(ctx2);
            return true;
        }
        return false;
    }

    private boolean checkLeaf(IBinaryTree t1, Set<IBinaryTree> t2, Context ctx) {
        this.trace("checkLeaf", t1, t2, ctx);
        if (!(t1 instanceof IParentBinaryTree)) {
            t2 = ctx.getRightTrees(t2);
            this.trace("checkLeaf'", t1, t2, ctx);
            for (IBinaryTree s : t2) {
                if (s instanceof IParentBinaryTree) continue;
                Subtype subtype = new Subtype(t1, t2);
                ctx.add(subtype);
                return true;
            }
        }
        return false;
    }

    private boolean checkRec(IParentBinaryTree t1, Set<IBinaryTree> t2, Context ctx) {
        this.trace("checkRec", (IBinaryTree)t1, t2, ctx);
        ISymbol label1 = t1.getLabel();
        IBinaryTree left1 = t1.getLeft();
        IBinaryTree right1 = t1.getRight();
        t2 = ctx.getRightTrees(t2);
        this.trace("checkRec'", (IBinaryTree)t1, t2, ctx);
        HashSet<IParentBinaryTree> l2 = new HashSet<IParentBinaryTree>();
        for (IBinaryTree s : t2) {
            ISymbol label2;
            if (!(s instanceof IParentBinaryTree) || !(label2 = s.getLabel()).matches(label1, ctx.getMatchContext())) continue;
            l2.add((IParentBinaryTree)s);
        }
        this.trace("checkRec''", (IBinaryTree)t1, l2, ctx);
        if (l2.isEmpty()) {
            return false;
        }
        HashSet<IParentBinaryTree> a = new HashSet<IParentBinaryTree>();
        HashSet<IParentBinaryTree> b = new HashSet<IParentBinaryTree>(l2);
        Context ctx2 = ctx.dup();
        while (true) {
            if (!this.checkRec(left1, right1, a, b, ctx2)) {
                return false;
            }
            if (b.isEmpty()) break;
            IParentBinaryTree t = this.pop(b);
            a.add(t);
        }
        ctx.addContext(ctx2);
        return true;
    }

    private boolean checkRec(IBinaryTree left1, IBinaryTree right1, Set<IParentBinaryTree> a, Set<IParentBinaryTree> b, Context ctx) {
        this.trace("checkRec'''", left1, a, ctx);
        this.trace("checkRec'''", right1, b, ctx);
        Context ctx2 = ctx.dup();
        for (IParentBinaryTree s : a) {
            IBinaryTree left2 = s.getLeft();
            if (!this.check(left1, left2, ctx2)) continue;
            ctx.addContext(ctx2);
            return true;
        }
        for (IParentBinaryTree s : b) {
            IBinaryTree right2 = s.getRight();
            if (!this.check(right1, right2, ctx2)) continue;
            ctx.addContext(ctx2);
            return true;
        }
        return false;
    }

    private void trace(String msg, IBinaryTree t1, IBinaryTree t2, Context ctx) {
        HashSet<IBinaryTree> l1 = new HashSet<IBinaryTree>();
        l1.add(t1);
        HashSet<IBinaryTree> l2 = new HashSet<IBinaryTree>();
        l2.add(t2);
        this.trace(msg, l1, l2, ctx);
    }

    private void trace(String msg, IBinaryTree t1, Set<? extends IBinaryTree> t2, Context ctx) {
        HashSet<IBinaryTree> l1 = new HashSet<IBinaryTree>();
        l1.add(t1);
        this.trace(msg, l1, t2, ctx);
    }

    private void trace(String msg, Set<? extends IBinaryTree> t1, Set<? extends IBinaryTree> t2, Context ctx) {
        this.trace(msg + ": " + this.traceSymbolString(t1) + " <: " + this.traceSymbolString(t2));
        this.trace(ctx.toString());
    }

    private void trace(String msg) {
        if (debug) {
            System.err.println(msg);
        }
    }

    private String traceSymbolString(Set<? extends ISymbol> l) {
        if (l.isEmpty()) {
            return "{}";
        }
        StringBuffer buff = new StringBuffer();
        Iterator<? extends ISymbol> i = l.iterator();
        while (i.hasNext()) {
            ISymbol s = i.next();
            buff.append(s);
            if (!i.hasNext()) continue;
            buff.append("|");
        }
        return buff.toString();
    }

    private <T extends IBinaryTree> T pop(Set<T> trees) {
        Iterator<T> i = trees.iterator();
        if (i.hasNext()) {
            IBinaryTree t = (IBinaryTree)i.next();
            i.remove();
            return (T)t;
        }
        return null;
    }

    public boolean isEmpty(ITreeGrammar tg) {
        TreeGrammar emptyPattern = new TreeGrammar((IBinaryTreeVariable)new BinaryTreeVariable("G"), new IProductionRule[]{new ProductionRule((IVariable)new BinaryTreeVariable("G"), (ISymbol)BinaryTree.LEAF)});
        return this.contains(emptyPattern, tg);
    }

    private static class Context {
        public final ITreeGrammar left;
        public final ITreeGrammar right;
        private final Set<Subtype> set;
        private final List<Subtype> stackTrace;
        private final IMatchContext matchContext;

        public Context(ITreeGrammar g1, ITreeGrammar g2) {
            this(g1, g2, new HashSet<Subtype>(), new ArrayList<Subtype>());
        }

        public Context(ITreeGrammar g1, ITreeGrammar g2, Set<Subtype> set, List<Subtype> stackTrace) {
            this.left = g1;
            this.right = g2;
            this.set = set;
            this.stackTrace = stackTrace;
            this.matchContext = new MatchContext();
        }

        public Set<IBinaryTree> getLeftTrees(IBinaryTreeVariable v) {
            return this.getLeftTrees(v, new HashSet<IBinaryTreeVariable>());
        }

        public Set<IBinaryTree> getLeftTrees(IBinaryTreeVariable v, Set<IBinaryTreeVariable> history) {
            if (history.contains(v)) {
                return new HashSet<IBinaryTree>();
            }
            history.add(v);
            Set<IBinaryTree> s = this.collectTrees(this.left.getRules(v));
            HashSet<IBinaryTree> ss = new HashSet<IBinaryTree>();
            for (IBinaryTree t : s) {
                if (t instanceof IBinaryTreeVariable) {
                    ss.addAll(this.getLeftTrees((IBinaryTreeVariable)t, history));
                    continue;
                }
                ss.add(t);
            }
            return ss;
        }

        public Set<IBinaryTree> getRightTrees(IBinaryTreeVariable v) {
            return this.getRightTrees(v, new HashSet<IBinaryTreeVariable>());
        }

        public Set<IBinaryTree> getRightTrees(IBinaryTreeVariable v, Set<IBinaryTreeVariable> history) {
            if (history.contains(v)) {
                return new HashSet<IBinaryTree>();
            }
            history.add(v);
            Set<IBinaryTree> s = this.collectTrees(this.right.getRules(v));
            HashSet<IBinaryTree> ss = new HashSet<IBinaryTree>();
            for (IBinaryTree t : s) {
                if (t instanceof IBinaryTreeVariable) {
                    ss.addAll(this.getRightTrees((IBinaryTreeVariable)t, history));
                    continue;
                }
                ss.add(t);
            }
            return ss;
        }

        public Set<IBinaryTree> getLeftTrees(Set<IBinaryTree> trees) {
            return this.getLeftTrees(trees, new HashSet<IBinaryTreeVariable>());
        }

        public Set<IBinaryTree> getLeftTrees(Set<IBinaryTree> trees, Set<IBinaryTreeVariable> history) {
            HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
            for (IBinaryTree t : trees) {
                if (t instanceof IBinaryTreeVariable) {
                    s.addAll(this.getLeftTrees((IBinaryTreeVariable)t, history));
                    continue;
                }
                s.add(t);
            }
            return s;
        }

        public Set<IBinaryTree> getRightTrees(Set<IBinaryTree> trees) {
            return this.getRightTrees(trees, new HashSet<IBinaryTreeVariable>());
        }

        public Set<IBinaryTree> getRightTrees(Set<IBinaryTree> trees, Set<IBinaryTreeVariable> history) {
            HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
            for (IBinaryTree t : trees) {
                if (t instanceof IBinaryTreeVariable) {
                    s.addAll(this.getRightTrees((IBinaryTreeVariable)t, history));
                    continue;
                }
                s.add(t);
            }
            return s;
        }

        private Set<IBinaryTree> collectTrees(Set<IProductionRule> rules) {
            HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
            for (IProductionRule rule : rules) {
                s.add((IBinaryTree)rule.getRight(0));
            }
            return s;
        }

        public IMatchContext getMatchContext() {
            return this.matchContext;
        }

        public void add(Subtype ty) {
            this.set.add(ty);
        }

        public boolean contains(Subtype ty) {
            return this.set.contains(ty);
        }

        public Iterator<Subtype> iterator() {
            return this.set.iterator();
        }

        public void addContext(Context ctx) {
            Iterator<Subtype> i = ctx.iterator();
            while (i.hasNext()) {
                Subtype subtype = i.next();
                this.add(subtype);
            }
        }

        public void addTrace(Subtype subtype) {
            this.stackTrace.add(0, subtype);
        }

        public void popTrace() {
            this.stackTrace.remove(0);
        }

        public Iterator<Subtype> stackTraceIterator() {
            return this.stackTrace.iterator();
        }

        public String toString() {
            return "#context:" + this.set.toString();
        }

        public Context dup() {
            return new Context(this.left, this.right, new HashSet<Subtype>(this.set), new ArrayList<Subtype>(this.stackTrace));
        }
    }

    private static class Subtype {
        public Set<IBinaryTree> left;
        public Set<IBinaryTree> right;

        public Subtype(IBinaryTree t1, IBinaryTree t2) {
            HashSet<IBinaryTree> l1 = new HashSet<IBinaryTree>();
            HashSet<IBinaryTree> l2 = new HashSet<IBinaryTree>();
            l1.add(t1);
            l2.add(t2);
            this.left = l1;
            this.right = l2;
        }

        public Subtype(IBinaryTree t1, Set<IBinaryTree> t2) {
            HashSet<IBinaryTree> l1 = new HashSet<IBinaryTree>();
            l1.add(t1);
            this.left = l1;
            this.right = t2;
        }

        public Subtype(Set<IBinaryTree> t1, Set<IBinaryTree> t2) {
            this.left = t1;
            this.right = t2;
        }

        public String toString() {
            return this.left + " <: " + this.right;
        }

        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Subtype ty = (Subtype)obj;
            return this.left.equals(ty.left) && this.right.equals(ty.right);
        }
    }
}

