/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.parser;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.regex.string.CharSetPatternFactory;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.regex.string.VariableReferencePattern;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ParserUtil {
    private int lineno = 0;
    private InputStream inputStream;
    private AUtil.IDebugPrinter err = AUtil.getDebugPrinter();
    private Stack<Integer> ch = new Stack();
    public int inStringPattern = -1;
    public int inCharSetPattern = -1;
    public boolean charSetBegin = true;
    public boolean isComplementCharSet = false;
    public boolean inIteration = false;
    public Object yylval = null;
    static final char[] specials = new char[]{'{', '}', '(', ')', '[', ']', '|', '*', '+', '~', '!', '?'};
    static final Map<String, IPattern> charMap = new HashMap<String, IPattern>();

    public ParserUtil() {
    }

    public ParserUtil(InputStream is) {
        this.setInputStream(is);
    }

    public void printError(String msg) {
        this.err.println(msg);
    }

    public int getLineNumber() {
        return this.lineno;
    }

    public void setInputStream(InputStream is) {
        this.lineno = 0;
        this.ch.clear();
        this.inputStream = is;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String readCharsUntil(String eos) {
        StringBuffer buff = new StringBuffer();
        int c = this.getch();
        while (c > 0 && buff.indexOf(eos) < 0) {
            buff.append((char)c);
            c = this.getch();
        }
        this.ungetch(c);
        return buff.substring(0, buff.length() - eos.length());
    }

    public String readChars(String chars, int n) {
        StringBuffer buff = new StringBuffer();
        int c = this.getch();
        while (c > 0 && chars.indexOf(c) >= 0) {
            buff.append((char)c);
            c = this.getch();
            if (n <= 0 || --n != 0) continue;
        }
        this.ungetch(c);
        return buff.toString();
    }

    public String readDigits() {
        return this.readDigits(0);
    }

    public String readDigits(int n) {
        return this.readChars("0123456789", n);
    }

    public String readHexDigits() {
        return this.readHexDigits(0);
    }

    public String readHexDigits(int n) {
        return this.readChars("0123456789abcdefABCDEF", n);
    }

    public String readOctalDigits() {
        return this.readOctalDigits(0);
    }

    public String readOctalDigits(int n) {
        return this.readChars("01234567", n);
    }

    public int getch() {
        int c = 0;
        if (this.ch.isEmpty()) {
            try {
                c = this.inputStream.read();
            }
            catch (IOException e) {
                throw new Error(e.getMessage());
            }
        } else {
            c = this.ch.pop();
        }
        if (c == 10) {
            ++this.lineno;
        }
        return c;
    }

    public void ungetch(int c) {
        if (c == 10) {
            --this.lineno;
        }
        this.ch.push(c);
    }

    private static boolean isPatternSpecialChar(char c) {
        for (int i = 0; i < specials.length; ++i) {
            if (c != specials[i]) continue;
            return true;
        }
        return false;
    }

    public IPattern charRange(char c1, char c2) {
        RangeSymbol range = null;
        range = new RangeSymbol(c1, c2);
        SymbolPattern pat = new SymbolPattern(range);
        return pat;
    }

    public IPattern charRange(Character[] cs) {
        char c1 = cs[0].charValue();
        char c2 = cs[1].charValue();
        return this.charRange(c1, c2);
    }

    public int yylexForIteration() {
        int c = this.getch();
        if ((char)c == ',') {
            return 44;
        }
        if ((char)c == '}') {
            this.inIteration = false;
            return 125;
        }
        this.ungetch(c);
        String str = this.readDigits();
        this.yylval = Integer.parseInt(str);
        return 261;
    }

    public int yylexForCharSetPattern() {
        int lookahead;
        this.yylval = null;
        int c = this.getch();
        if (c < 0) {
            return 0;
        }
        if ((char)c == '^' && this.charSetBegin && !this.isComplementCharSet) {
            this.isComplementCharSet = true;
            this.yylval = new SymbolPattern(new CharSymbol((char)c));
            return c;
        }
        if ((char)c == ']') {
            if (this.charSetBegin) {
                this.yylval = new SymbolPattern(new CharSymbol(']'));
            } else {
                --this.inCharSetPattern;
                return 259;
            }
        }
        if ((char)c == '-') {
            if (this.charSetBegin) {
                this.yylval = new SymbolPattern(new CharSymbol('-'));
            } else {
                int lookahead2 = this.getch();
                if ((char)lookahead2 == ']') {
                    this.ungetch(93);
                    this.yylval = new SymbolPattern(new CharSymbol('-'));
                    return 257;
                }
                this.yyerror("Unreachable code.");
            }
        }
        if ((char)c == '&') {
            int c2 = this.getch();
            if ((char)c2 == '&') {
                int c3 = this.getch();
                if ((char)c3 == '[') {
                    return 260;
                }
                this.ungetch(c3);
            }
            this.ungetch(c2);
        }
        this.ungetch(c);
        int ret = this.yylexForCharacter();
        if (this.charSetBegin) {
            this.charSetBegin = false;
        }
        if ((char)(lookahead = this.getch()) == '-') {
            lookahead = this.getch();
            if ((char)lookahead == ']') {
                this.ungetch(93);
                this.ungetch(45);
                return ret;
            }
            RangeSymbol rs = new RangeSymbol((CharSymbol)((SymbolPattern)this.yylval).getSymbol(), new CharSymbol((char)lookahead));
            this.yylval = new SymbolPattern(rs);
            return 258;
        }
        this.ungetch(lookahead);
        return ret;
    }

    private String readPPattern() {
        int c = this.getch();
        StringBuffer buff = new StringBuffer();
        if (c == 123) {
            c = this.getch();
            while (c != 125 && c > 0) {
                buff.append((char)c);
                c = this.getch();
            }
        }
        return buff.toString();
    }

    public int yylexForStringPattern() {
        this.yylval = null;
        int c = this.getch();
        if (c < 0) {
            return 0;
        }
        if (!ParserUtil.isPatternSpecialChar((char)c)) {
            this.ungetch(c);
            return this.yylexForCharacter();
        }
        if ((char)c == '(') {
            int c2 = this.getch();
            if ((char)c2 == '?') {
                int c3 = this.getch();
                if ((char)c3 == ':') {
                    return 262;
                }
                if ((char)c3 == '!') {
                    return 263;
                }
                if ((char)c3 == '=') {
                    return 264;
                }
                if ((char)c3 == '<') {
                    int c4 = this.getch();
                    if ((char)c4 == '!') {
                        return 266;
                    }
                    if ((char)c4 == '=') {
                        return 265;
                    }
                    this.ungetch(c4);
                } else if ((char)c3 == '>') {
                    return 267;
                }
                this.ungetch(c3);
            }
            this.ungetch(c2);
            return 40;
        }
        String s = Character.toString((char)c);
        if (charMap.containsKey(s)) {
            this.yylval = charMap.get(s);
            return 257;
        }
        return c;
    }

    private int yylexForCharacter() {
        int c = this.getch();
        String s = Character.toString((char)c);
        if (c == 92) {
            c = this.getch();
            if (c > 0) {
                s = s + Character.toString((char)c);
            }
            if ((char)c != '0' && Character.isDigit((char)c)) {
                this.yylval = new VariableReferencePattern(new Variable(Character.toString((char)c)));
            } else if (charMap.containsKey(s)) {
                this.yylval = charMap.get(s);
            } else if (s.equals("\\p")) {
                String p = this.readPPattern();
                this.yylval = charMap.get("\\p{" + p + "}");
            } else if (s.equals("\\x")) {
                String n = this.readHexDigits(2);
                int i = Integer.parseInt(n, 16);
                this.yylval = new SymbolPattern(new CharSymbol((char)i));
            } else if (s.equals("\\u")) {
                String n = this.readHexDigits(4);
                int i = Integer.parseInt(n, 16);
                this.yylval = new SymbolPattern(new CharSymbol((char)i));
            } else if (s.equals("\\0")) {
                String n = this.readOctalDigits(3);
                int i = Integer.parseInt(n, 8);
                this.yylval = new SymbolPattern(new CharSymbol((char)i));
            } else if (ParserUtil.isPatternSpecialChar((char)c)) {
                this.yylval = new SymbolPattern(new CharSymbol((char)c));
            } else if (s.equals("\\Q")) {
                String str = this.readCharsUntil("\\E");
                this.yylval = ConcatenationPattern.make(str.toCharArray());
            } else {
                System.err.println("warning: should not escape the character '" + (char)c + "'");
                this.yylval = new SymbolPattern(new CharSymbol((char)c));
            }
        } else {
            this.yylval = charMap.containsKey(s) ? charMap.get(s) : new SymbolPattern(new CharSymbol((char)c));
        }
        return 257;
    }

    public void yyerror(String msg) {
        Object t = this.yylval == null ? "" : this.yylval;
        System.err.println("line " + this.getLineNumber() + "(before " + t + "): " + msg);
    }

    static {
        charMap.put("\\n", new SymbolPattern(new CharSymbol('\n')));
        charMap.put("\\r", new SymbolPattern(new CharSymbol('\r')));
        charMap.put("\\t", new SymbolPattern(new CharSymbol('\t')));
        charMap.put("\\f", new SymbolPattern(new CharSymbol('\f')));
        charMap.put("\\a", new SymbolPattern(new CharSymbol('\u0007')));
        charMap.put("\\e", new SymbolPattern(new CharSymbol('\u001b')));
        charMap.put("\\\\", new SymbolPattern(new CharSymbol('\\')));
        charMap.put("\\.", new SymbolPattern(new CharSymbol('.')));
        charMap.put(".", SymbolPattern.ANY_CHAR_PATTERN);
        charMap.put("\\w", SymbolPattern.ANY_WORD_PATTERN);
        charMap.put("\\W", SymbolPattern.NOT_WORD_PATTERN);
        charMap.put("\\d", SymbolPattern.ANY_DIGIT_PATTERN);
        charMap.put("\\D", SymbolPattern.NOT_DIGIT_PATTERN);
        charMap.put("\\s", SymbolPattern.ANY_SPACE_PATTERN);
        charMap.put("\\S", SymbolPattern.NOT_SPACE_PATTERN);
        charMap.put("\\p{Lower}", new SymbolPattern(new RangeSymbol('a', 'z')));
        charMap.put("\\p{Upper}", new SymbolPattern(new RangeSymbol('A', 'Z')));
        charMap.put("\\p{ASCII}", new SymbolPattern(new RangeSymbol('\u0000', '\u007f')));
        charMap.put("\\p{Alpha}", SymbolPattern.ANY_ALPHA_PATTERN);
        charMap.put("\\p{Digit}", SymbolPattern.ANY_DIGIT_PATTERN);
        charMap.put("\\p{Alnum}", UnionPattern.make(SymbolPattern.ANY_DIGIT_PATTERN, SymbolPattern.ANY_ALPHA_PATTERN));
        charMap.put("\\p{Punct}", SymbolPattern.PUNCT_PATTERN);
        charMap.put("\\p{Graph}", UnionPattern.make(Arrays.asList(SymbolPattern.ANY_DIGIT_PATTERN, SymbolPattern.ANY_ALPHA_PATTERN, SymbolPattern.PUNCT_PATTERN)));
        charMap.put("\\p{Print}", UnionPattern.make(Arrays.asList(SymbolPattern.ANY_DIGIT_PATTERN, SymbolPattern.ANY_ALPHA_PATTERN, SymbolPattern.PUNCT_PATTERN, new SymbolPattern(new CharSymbol(' ')))));
        charMap.put("\\p{Blank}", UnionPattern.make(new char[]{' ', '\t'}));
        charMap.put("\\p{Cntrl}", UnionPattern.make(new SymbolPattern(new RangeSymbol('\u0000', '\u001f')), new SymbolPattern(new CharSymbol('\u007f'))));
        charMap.put("\\p{XDigit}", SymbolPattern.ANY_HEX_DIGIT_PATTERN);
        charMap.put("\\p{Space}", SymbolPattern.ANY_SPACE_PATTERN);
        charMap.put("\\p{javaLowerCase}", new SymbolPattern(new RangeSymbol('a', 'z')));
        charMap.put("\\p{javaUpperCase}", new SymbolPattern(new RangeSymbol('A', 'Z')));
        charMap.put("\\p{javaWhitespace}", SymbolPattern.ANY_SPACE_PATTERN);
        charMap.put("\\p{Pe}", CharSetPatternFactory.make("Pe"));
        charMap.put("\\p{Pi}", CharSetPatternFactory.make("Pi"));
        charMap.put("\\p{Pf}", CharSetPatternFactory.make("Pf"));
        charMap.put("\\p{Po}", CharSetPatternFactory.make("Po"));
        charMap.put("\\p{Ps}", CharSetPatternFactory.make("Ps"));
        charMap.put("\\p{S}", CharSetPatternFactory.make("S"));
    }
}

