/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.AbstractPattern;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCopier;
import com.ibm.wala.automaton.regex.string.IPatternVisitor;
import com.ibm.wala.automaton.regex.string.IterationPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import java.util.Arrays;

public class SymbolPattern
extends AbstractPattern
implements IPattern {
    public static IPattern ANY_CHAR_PATTERN = new SymbolPattern(new RangeSymbol('\u0000', '\uffff'));
    public static IPattern ANY_STRING_PATTERN = new IterationPattern(ANY_CHAR_PATTERN, 0, -1);
    public static IPattern ANY_ALPHA_PATTERN = new UnionPattern(new SymbolPattern(new RangeSymbol('a', 'z')), new SymbolPattern(new RangeSymbol('A', 'Z')));
    public static IPattern ANY_SPACE_PATTERN = UnionPattern.make(Arrays.asList(new SymbolPattern(new CharSymbol(' ')), new SymbolPattern(new RangeSymbol('\t', '\r'))));
    public static IPattern NOT_SPACE_PATTERN = UnionPattern.make(Arrays.asList(new SymbolPattern(new RangeSymbol('\u0000', '\b')), new SymbolPattern(new RangeSymbol('\u000e', '\u001f')), new SymbolPattern(new RangeSymbol('!', '\uffff'))));
    public static IPattern ANY_DIGIT_PATTERN = new SymbolPattern(new RangeSymbol('0', '9'));
    public static IPattern NOT_DIGIT_PATTERN = new UnionPattern(new SymbolPattern(new RangeSymbol('\u0000', '/')), new SymbolPattern(new RangeSymbol(':', '\uffff')));
    public static IPattern ANY_WORD_PATTERN = UnionPattern.make(Arrays.asList(ANY_ALPHA_PATTERN, ANY_DIGIT_PATTERN, new SymbolPattern(new CharSymbol('_'))));
    public static IPattern NOT_WORD_PATTERN = UnionPattern.make(Arrays.asList(new SymbolPattern(new RangeSymbol('\u0000', '/')), new SymbolPattern(new RangeSymbol(':', '@')), new SymbolPattern(new RangeSymbol('[', '^')), new SymbolPattern(new CharSymbol('`')), new SymbolPattern(new RangeSymbol('{', '\uffff'))));
    public static IPattern PUNCT_PATTERN = UnionPattern.make("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".toCharArray());
    public static IPattern ANY_HEX_DIGIT_PATTERN = UnionPattern.make(Arrays.asList(ANY_DIGIT_PATTERN, new SymbolPattern(new RangeSymbol('a', 'f')), new SymbolPattern(new RangeSymbol('A', 'F'))));
    private ISymbol symbol;

    public static IPattern make(ISymbol s) {
        return new SymbolPattern(s);
    }

    public static IPattern make(char c) {
        return new SymbolPattern(new CharSymbol(c));
    }

    public static IPattern make(String s) {
        return new SymbolPattern(new StringSymbol(s));
    }

    public SymbolPattern(ISymbol symbol) {
        this.symbol = symbol;
    }

    public SymbolPattern(String symbol) {
        this(new StringSymbol(symbol));
    }

    public SymbolPattern(char c) {
        this(new CharSymbol(c));
    }

    public ISymbol getSymbol() {
        return this.symbol;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SymbolPattern p = (SymbolPattern)obj;
        return this.getSymbol().equals(p.getSymbol());
    }

    public String toString() {
        return this.symbol.toString();
    }

    @Override
    public void traverse(IPatternVisitor visitor) {
        visitor.onVisit(this);
        visitor.onLeave(this);
    }

    @Override
    public IPattern copy(IPatternCopier copier) {
        return copier.copy(this, null);
    }

    public static IPattern toCharSequencePattern(char[] cs) {
        AbstractPattern pat = null;
        for (int i = cs.length - 1; i >= 0; --i) {
            SymbolPattern sp = new SymbolPattern(new CharSymbol(cs[i]));
            pat = pat == null ? sp : new ConcatenationPattern(sp, pat);
        }
        return pat;
    }

    public static IPattern toCharSequencePattern(SymbolPattern symp) {
        return SymbolPattern.toCharSequencePattern(symp.getSymbol().getName().toCharArray());
    }

    public static IPattern toCharSequencePattern(String str) {
        return SymbolPattern.toCharSequencePattern(str.toCharArray());
    }

    public IPattern toCharSequencePattern() {
        return SymbolPattern.toCharSequencePattern(this);
    }
}

