/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.tree;

import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.tree.IBinaryTree;

public class StateBinaryTree
implements IBinaryTree,
IState {
    final String SEPARATOR = ":";
    private IBinaryTree tree;
    private IState state;

    public StateBinaryTree(IBinaryTree tree, IState s) {
        this.tree = tree;
        this.state = s;
    }

    public StateBinaryTree(IState s, IBinaryTree tree) {
        this(tree, s);
    }

    public IBinaryTree getTree() {
        return this.tree;
    }

    public IState getState() {
        return this.state;
    }

    @Override
    public ISymbol getLabel() {
        return this.tree.getLabel();
    }

    @Override
    public String getName() {
        return this.state.getName() + ":" + this.tree.getName();
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        StateBinaryTree t = (StateBinaryTree)obj;
        return (this.tree == null ? t.tree == null : this.tree.equals(t.tree)) && this.state.equals(t.state);
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof StateBinaryTree) {
            StateBinaryTree t = (StateBinaryTree)symbol;
            if (this.state.equals(t.state)) {
                return this.tree == null ? t.tree == null : this.tree.matches(t.tree, context);
            }
            return false;
        }
        return this.tree == null ? symbol == null : this.tree.matches(symbol, context);
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext context) {
        if (symbol instanceof StateBinaryTree) {
            StateBinaryTree t = (StateBinaryTree)symbol;
            if (this.state.equals(t.state)) {
                return this.tree == null ? t.tree == null : this.tree.possiblyMatches(t.tree, context);
            }
            return false;
        }
        return this.tree == null ? symbol == null : this.tree.possiblyMatches(symbol, context);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        if (this.tree != null) {
            this.tree.traverse(visitor);
        }
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof StateBinaryTree) {
            StateBinaryTree t = (StateBinaryTree)s;
            if (this.tree != null) {
                t.tree = (IBinaryTree)t.tree.copy(copier);
            }
            if (copier instanceof IStateCopier) {
                IStateCopier scopier = (IStateCopier)((Object)copier);
                t.state = t.state.copy(scopier);
            }
        }
        return s;
    }

    @Override
    public IState copy(IStateCopier copier) {
        return (IState)((Object)this.copy((ISymbolCopier)((Object)copier)));
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.tree == null ? 0 : this.tree.size();
    }

    public String toString() {
        return this.state.toString() + "(" + this.tree + ")";
    }
}

