/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet<T>
implements Set<T> {
    private ConcurrentHashMap<T, Object> M = new ConcurrentHashMap();

    public ConcurrentHashSet() {
    }

    public ConcurrentHashSet(Collection<T> c) {
        this.addAll((Collection<? extends T>)c);
    }

    @Override
    public boolean add(T e) {
        this.M.put(e, null);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.M.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.M.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Set s = this.M.keySet();
        for (Object e : c) {
            if (s.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.M.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return ((ConcurrentHashMap.KeySetView)this.M.keySet()).iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.M.containsKey(o)) {
            this.M.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            if (!this.remove(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : this.M.keySet()) {
            if (c.contains(e) || !this.remove(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public int size() {
        return this.M.size();
    }

    @Override
    public Object[] toArray() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.M.keySet())).toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return ((ConcurrentHashMap.CollectionView)((Object)this.M.keySet())).toArray(a);
    }
}

