/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class HashMapSet<V, T>
implements Set<T>,
Cloneable {
    private static final long serialVersionUID = 1L;
    private HashMap<V, HashSet<T>> elements;

    public HashMapSet() {
        this.elements = new HashMap();
    }

    public HashMapSet(int initialCapacity, float loadFactor) {
        this.elements = new HashMap(initialCapacity, loadFactor);
    }

    public HashMapSet(Collection<? extends T> rules) {
        this();
        this.addAll(rules);
    }

    protected abstract V getKey(T var1);

    public Set<T> getSet(V v) {
        return Collections.unmodifiableSet(this.getModifiableSet(v));
    }

    private Set<T> getModifiableSet(V v) {
        HashSet<Object> rs = this.elements.get(v);
        if (rs == null) {
            rs = new HashSet();
            this.elements.put((HashSet<T>)v, rs);
        }
        return rs;
    }

    public Set<V> keySet() {
        return this.elements.keySet();
    }

    @Override
    public boolean add(T e) {
        return this.getModifiableSet(this.getKey(e)).add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T r : c) {
            if (!this.add(r)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public boolean contains(Object o) {
        Object r = o;
        Set<T> rs = this.getSet(this.getKey(r));
        return rs.contains(r);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Map.Entry<V, HashSet<T>> e : this.elements.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        LinkedList<Iterator<T>> iters = new LinkedList<Iterator<T>>();
        for (Map.Entry<V, HashSet<T>> e : this.elements.entrySet()) {
            iters.add(e.getValue().iterator());
        }
        if (iters.isEmpty()) {
            return Collections.emptySet().iterator();
        }
        final Iterator ii = iters.iterator();
        return new Iterator<T>(){
            Iterator<T> cur;
            {
                this.cur = (Iterator)ii.next();
            }

            @Override
            public boolean hasNext() {
                if (this.cur.hasNext()) {
                    return true;
                }
                while (ii.hasNext()) {
                    this.cur = (Iterator)ii.next();
                    if (!this.cur.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                return this.cur.next();
            }

            @Override
            public void remove() {
                this.cur.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        Object v = o;
        Set<T> s = this.getModifiableSet(this.getKey(v));
        if (s.remove(o)) {
            if (s.isEmpty()) {
                this.elements.remove(this.getKey(v));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : new HashSet(c)) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int i = 0;
        for (Map.Entry<V, HashSet<T>> e : this.elements.entrySet()) {
            i += e.getValue().size();
        }
        return i;
    }

    @Override
    public Object[] toArray() {
        Object[] objs = new Object[this.size()];
        return this.toArray((U[])objs);
    }

    @Override
    public <U> U[] toArray(U[] objs) {
        int i = 0;
        for (T r : this) {
            objs[i] = r;
            ++i;
        }
        return objs;
    }

    public Object clone() {
        try {
            HashMapSet s = (HashMapSet)super.clone();
            s.elements = (HashMap)this.elements.clone();
            for (Map.Entry<HashSet, HashSet<T>> entry : s.elements.entrySet()) {
                entry.setValue((HashSet)entry.getValue().clone());
            }
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        if (this.size() != c.size()) {
            return false;
        }
        return this.containsAll(c) && c.containsAll(this);
    }
}

