/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.automaton.util.collections.BoxingIntIterator;
import com.ibm.wala.automaton.util.collections.IntArrayIterator;
import com.ibm.wala.automaton.util.collections.IntSequence;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntVector;
import java.util.Arrays;
import java.util.Iterator;

public class SimpleIntSequence
implements IntVector,
IntSequence {
    int[] store;
    int size;

    public SimpleIntSequence() {
        this(16);
    }

    public SimpleIntSequence(int initialCapacity) {
        this.store = new int[initialCapacity];
        this.size = 0;
    }

    public SimpleIntSequence(int[] src) {
        this(src.length);
        this.append(src);
    }

    public int get(int x) {
        if (x >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.store[x];
    }

    public int getMaxIndex() {
        return this.size - 1;
    }

    void expand(int newcapacity) {
        int[] old = this.store;
        this.store = new int[newcapacity];
        System.arraycopy(old, 0, this.store, 0, old.length);
    }

    public void set(int x, int value) {
        if (x >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.store[x] = value;
    }

    @Override
    public IntSequence append(int val) {
        if (this.size >= this.store.length) {
            this.expand(this.size + this.size / 2);
        }
        this.store[this.size++] = val;
        return this;
    }

    @Override
    public IntSequence append(int[] vals) {
        int vl = vals.length;
        if (this.size + vl - 1 >= this.store.length) {
            this.expand(vl + this.store.length);
        }
        System.arraycopy(vals, 0, this.store, this.size, vl);
        this.size += vl;
        return this;
    }

    @Override
    public int[] toArray() {
        int[] arr = new int[this.size];
        System.arraycopy(this.store, 0, arr, 0, this.size);
        return arr;
    }

    public int[] peekStore() {
        return this.store;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] subSequenceAsArray(int start, int end) {
        int l = end - start;
        if (l < 0 || end > this.size || end < 0 || start < 0) {
            throw new IndexOutOfBoundsException();
        }
        int[] arr = new int[l];
        System.arraycopy(this.store, start, arr, 0, l);
        return arr;
    }

    @Override
    public IntSequence subSequence(int start, int end) {
        return new SimpleIntSequence(this.subSequenceAsArray(start, end));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new BoxingIntIterator(this.toArray());
    }

    @Override
    public IntIterator intIterator() {
        return new IntArrayIterator(this.toArray());
    }

    protected Object clone() throws CloneNotSupportedException {
        return new SimpleIntSequence(this.store);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SimpleIntSequence) {
            SimpleIntSequence seq = (SimpleIntSequence)obj;
            return Arrays.equals(this.store, seq.store);
        }
        if (obj instanceof IntSequence) {
            IntSequence seq = (IntSequence)obj;
            if (this.size() != seq.size()) {
                return false;
            }
            return Arrays.equals(this.store, seq.toArray());
        }
        return false;
    }

    public String toString() {
        return this.store.toString();
    }
}

