/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.demandpa.alg.BudgetExceededException;
import com.ibm.wala.demandpa.alg.IDemandPointerAnalysis;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.cha.IClassHierarchy;

public abstract class AbstractDemandPointsTo
implements IDemandPointerAnalysis {
    protected final CallGraph cg;
    protected final HeapModel heapModel;
    protected final MemoryAccessMap mam;
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    protected int numNodesTraversed;
    private int traversalBudget = Integer.MAX_VALUE;

    public int getTraversalBudget() {
        return this.traversalBudget;
    }

    protected void setTraversalBudget(int traversalBudget) {
        this.traversalBudget = traversalBudget;
    }

    public AbstractDemandPointsTo(CallGraph cg, HeapModel model, MemoryAccessMap mam, IClassHierarchy cha, AnalysisOptions options) {
        this.cg = cg;
        this.heapModel = model;
        this.mam = mam;
        this.cha = cha;
        this.options = options;
    }

    @Override
    public HeapModel getHeapModel() {
        return this.heapModel;
    }

    protected void incrementNumNodesTraversed() {
        if (this.numNodesTraversed > this.traversalBudget) {
            throw new BudgetExceededException();
        }
        ++this.numNodesTraversed;
    }

    protected void setNumNodesTraversed(int traversed) {
        this.numNodesTraversed = traversed;
    }

    public int getNumNodesTraversed() {
        return this.numNodesTraversed;
    }

    @Override
    public CallGraph getBaseCallGraph() {
        return this.cg;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

