/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph;

import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.config.SetOfClasses;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class ShallowAnalysisScope
implements Serializable {
    private static final long serialVersionUID = -3256390509887654321L;
    private final SetOfClasses exclusions;
    private final List<String> moduleLinesList;
    private final List<String> ldrImplLinesList;

    public ShallowAnalysisScope(SetOfClasses exclusions, List<String> moduleLinesList, List<String> ldrImplLinesList) {
        if (moduleLinesList == null) {
            throw new IllegalArgumentException("null moduleLinesList");
        }
        if (ldrImplLinesList == null) {
            throw new IllegalArgumentException("null ldrImplLinesList");
        }
        this.exclusions = exclusions;
        this.moduleLinesList = moduleLinesList;
        this.ldrImplLinesList = ldrImplLinesList;
    }

    public AnalysisScope toAnalysisScope() throws IOException {
        AnalysisScope analysisScope = AnalysisScope.createJavaAnalysisScope();
        analysisScope.setExclusions(this.exclusions);
        for (String moduleLine : this.moduleLinesList) {
            AnalysisScopeReader.processScopeDefLine(analysisScope, this.getClass().getClassLoader(), moduleLine);
        }
        for (String ldrLine : this.ldrImplLinesList) {
            AnalysisScopeReader.processScopeDefLine(analysisScope, this.getClass().getClassLoader(), ldrLine);
        }
        return analysisScope;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String moduleLine : this.moduleLinesList) {
            result.append(moduleLine);
            result.append("\n");
        }
        return result.toString();
    }
}

