/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSAConversionInstruction
extends SSAInstruction {
    private final int result;
    private final int val;
    private final TypeReference fromType;
    private final TypeReference toType;

    protected SSAConversionInstruction(int iindex, int result, int val, TypeReference fromType, TypeReference toType) {
        super(iindex);
        this.result = result;
        this.val = val;
        this.fromType = fromType;
        this.toType = toType;
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = conversion(" + this.toType.getName() + ") " + this.getValueString(symbolTable, this.val);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitConversion(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getToType() {
        return this.toType;
    }

    public TypeReference getFromType() {
        return this.fromType;
    }

    @Override
    public int getUse(int j) {
        assert (j == 0);
        return this.val;
    }

    @Override
    public int hashCode() {
        return 6311 * this.result ^ this.val;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

