/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.andromeda.cg.AbstractTICallGraph;
import com.ibm.wala.andromeda.cg.AccuracyLevel;
import com.ibm.wala.andromeda.cg.CgTargetsCache;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.cg.util.SALogger;
import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.cg.util.UserLog;
import com.ibm.wala.andromeda.frameworks.FrameworkSupport;
import com.ibm.wala.andromeda.harness.TaintRunner;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.util.SignatureUtil;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACache;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TICallGraph
extends AbstractTICallGraph
implements CallGraph,
Iterable<CGNode> {
    private static final boolean VISUALIZE_CG = false;
    private static final Logger logger = SALogger.logger;
    private final int appPolymorphism;
    private final int libPolymorphism;
    private final boolean appGuess;
    private final boolean app2libGuess;
    private final boolean libGuess;
    private static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    private static final int WIPE_SOFT_CACHE_INTERVAL = 10000;
    private final int initialExpansionBound;
    private static int wipeCount = 0;
    protected boolean DEBUG = false;
    protected final SlowSparseNumberedGraph<CGNode> g = SlowSparseNumberedGraph.make();
    protected final IClassHierarchy cha;
    protected final Map<MethodReference, CGNode[]> mr2node = HashMapFactory.make();
    private final OfflineSpecification offline;
    protected final AnalysisOptions options = new AnalysisOptions();
    protected Set<SCGNode> entrypointNodes;
    private boolean isBuilt = false;
    protected final Map<Selector, Map<IClass, Set<CallSite>>> unresolvedSites = HashMapFactory.make();
    private final ILangServices langServices;
    protected final Set<CGNode> visitedForSuccessors = HashSetFactory.make();
    protected final int sizeBound;
    protected Collection<CGNode> leaves;
    private final CgTargetsCache cgTargetsCache;
    private static final String THREAD_START_SIG = "java.lang.Thread.start()V";

    public TICallGraph(IClassHierarchy cha, IEntrypointLocator entrypointLocator, OfflineSpecification offline, ILangServices langServices, AnalysisCache cache, AccuracyLevel accuracyLevel) {
        this(cha, entrypointLocator, offline, langServices, cache, accuracyLevel, VirtualResolutionOptions.defaultOptions());
    }

    public TICallGraph(IClassHierarchy cha, IEntrypointLocator entrypointLocator, OfflineSpecification offline, ILangServices langServices, AnalysisCache cache, AccuracyLevel accuracyLevel, VirtualResolutionOptions resolutionOptions) {
        super(cache);
        this.appPolymorphism = resolutionOptions.appPolymorphism;
        this.libPolymorphism = resolutionOptions.libPolymorphism;
        this.appGuess = resolutionOptions.appGuess;
        this.app2libGuess = resolutionOptions.app2libGuess;
        this.libGuess = resolutionOptions.libGuess;
        this.cha = cha;
        this.langServices = langServices;
        this.offline = offline;
        this.sizeBound = accuracyLevel.getMaxCallGraphSize();
        this.initialExpansionBound = accuracyLevel.getInitialExpansionBound();
        this.cgTargetsCache = new CgTargetsCache(cha);
        Util.addDefaultSelectors((AnalysisOptions)this.options, (IClassHierarchy)cha);
        this.build(entrypointLocator);
    }

    public TICallGraph(IClassHierarchy ch, IEntrypointLocator entrypointLocator, ILangServices langSpecificServices, ILanguageSpecificServicesForFastanalysis fastLangServices, AnalysisCache cache, AccuracyLevel accuracyLevel) {
        this(ch, entrypointLocator, OfflineSpecification.loadDefaultSpec(ch, langSpecificServices, fastLangServices), langSpecificServices, cache, accuracyLevel);
    }

    private void printStorelessGraph() {
        Set<CGNode> targetNodes;
        CallSiteReference callSiteRef;
        Iterator itCallSites;
        LinkedList<CGNode> workingList = new LinkedList<CGNode>();
        LinkedList<CGNode> visitedList = new LinkedList<CGNode>();
        for (CGNode node : this) {
            workingList.add(node);
        }
        while (!workingList.isEmpty()) {
            CGNode node;
            node = (CGNode)workingList.remove();
            visitedList.add(node);
            itCallSites = node.iterateCallSites();
            while (itCallSites.hasNext()) {
                callSiteRef = (CallSiteReference)itCallSites.next();
                targetNodes = this.getPossibleTargets(node, callSiteRef);
                for (CGNode targetNode : targetNodes) {
                    if (workingList.contains(targetNode) || visitedList.contains(targetNode)) continue;
                    workingList.add(targetNode);
                }
            }
        }
        UserLog.logger.info((Object)"GRAPH DUMP START:");
        for (CGNode node : this) {
            UserLog.logger.info((Object)("Node:" + node.toString()));
            itCallSites = node.iterateCallSites();
            while (itCallSites.hasNext()) {
                callSiteRef = (CallSiteReference)itCallSites.next();
                UserLog.logger.info((Object)("\tCallSite:" + callSiteRef.toString()));
                targetNodes = this.getPossibleTargets(node, callSiteRef);
                for (CGNode targetNode : targetNodes) {
                    UserLog.logger.info((Object)("\t\tNode:" + targetNode.toString()));
                }
            }
        }
        UserLog.logger.info((Object)"GRAPH DUMP END");
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public Collection<CGNode> getEntrypointNodes() {
        HashSet result = HashSetFactory.make();
        for (SCGNode n : this.entrypointNodes) {
            result.add(n);
        }
        return result;
    }

    public CGNode getFakeRootNode() {
        return null;
    }

    public CGNode getNode(IMethod method, Context c) {
        CGNode[] nodes = this.mr2node.get(method.getReference());
        if (nodes == null) {
            return null;
        }
        for (CGNode node : nodes) {
            if (!node.getContext().equals(c)) continue;
            return node;
        }
        return null;
    }

    public Set<CGNode> getNodes(MethodReference m) {
        CGNode[] nodes = this.mr2node.get(m);
        if (nodes == null) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        for (CGNode node : nodes) {
            result.add(node);
        }
        return result;
    }

    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        this.computeSuccessorsIfNeeded(node);
        return this.getPossibleTargets(node, site).size();
    }

    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        this.computeSuccessorsIfNeeded(src);
        ArrayList<CallSiteReference> result = new ArrayList<CallSiteReference>();
        SCGNode caller = (SCGNode)src;
        Iterator it = src.iterateCallSites();
        while (it.hasNext()) {
            CallSiteReference site = (CallSiteReference)it.next();
            if (!caller.getPossibleTargets(site).contains(target)) continue;
            result.add(site);
        }
        return result.iterator();
    }

    public void removeNodeAndEdges(CGNode N) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void addNode(CGNode n) {
        assert (n instanceof SCGNode);
        this.g.addNode((Object)n);
        this.registerNode((SCGNode)n);
    }

    public boolean containsNode(CGNode N) {
        return this.g.containsNode((Object)N);
    }

    public int getNumberOfNodes() {
        return this.g.getNumberOfNodes();
    }

    @Override
    public Iterator<CGNode> iterator() {
        return this.g.iterator();
    }

    public void removeNode(CGNode n) {
        Assertions.UNREACHABLE();
    }

    public void addEdge(CGNode src, CGNode dst) {
        this.g.addEdge((Object)src, (Object)dst);
    }

    public int getPredNodeCount(CGNode N) {
        return this.g.getPredNodeCount((Object)N);
    }

    public Iterator<CGNode> getPredNodes(CGNode N) {
        return this.g.getPredNodes((Object)N);
    }

    public int getSuccNodeCount(CGNode N) {
        this.computeSuccessorsIfNeeded(N);
        return this.g.getSuccNodeCount((Object)N);
    }

    public Iterator<CGNode> getSuccNodes(CGNode N) {
        this.computeSuccessorsIfNeeded(N);
        return this.g.getSuccNodes((Object)N);
    }

    public boolean hasEdge(CGNode src, CGNode dst) {
        Assertions.UNREACHABLE();
        return false;
    }

    public void removeAllIncidentEdges(CGNode node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeEdge(CGNode src, CGNode dst) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeIncomingEdges(CGNode node) throws UnsupportedOperationException {
        Assertions.UNREACHABLE();
    }

    public void removeOutgoingEdges(CGNode node) throws UnsupportedOperationException {
        this.g.removeOutgoingEdges((Object)node);
    }

    public int getMaxNumber() {
        return this.g.getMaxNumber();
    }

    public CGNode getNode(int number) {
        return (CGNode)this.g.getNode(number);
    }

    public int getNumber(CGNode n) {
        return this.g.getNumber((Object)n);
    }

    public Iterator<CGNode> iterateNodes(IntSet s) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getPredNodeNumbers(CGNode node) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getSuccNodeNumbers(CGNode node) {
        Assertions.UNREACHABLE();
        return null;
    }

    public String toString() {
        return this.g.toString();
    }

    protected void registerNode(SCGNode node) {
        MethodReference reference = node.getMethod().getReference();
        CGNode[] nodes = this.mr2node.get(reference);
        if (nodes == null) {
            nodes = new CGNode[1];
            this.mr2node.put(reference, nodes);
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null) {
                nodes[i] = node;
                return;
            }
            if (!nodes[i].equals((Object)node)) continue;
            return;
        }
        CGNode[] newNodes = new CGNode[nodes.length + 1];
        System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
        this.mr2node.put(reference, newNodes);
        newNodes[nodes.length] = node;
    }

    public boolean isEligibleMethod(IMethod m) {
        return m != null && (!m.isNative() || m.isSynthetic());
    }

    public AnalysisCache getAnalysisCache() {
        return this.analysisCache;
    }

    public MethodTargetSelector getMethodTargetSelector() {
        return this.options.getMethodTargetSelector();
    }

    private void build(IEntrypointLocator entrypointLocator) {
        if (this.langServices.doClearAllCaches()) {
            ReferenceCleanser.registerClassHierarchy((IClassHierarchy)this.cha);
            ReferenceCleanser.registerCache((AnalysisCache)this.getAnalysisCache());
        }
        Set<IMethod> entrypoints = entrypointLocator.locateEntrypoints(this.cha);
        if (UserLog.logger.isDebugEnabled()) {
            UserLog.logger.info((Object)("Entrypoints: " + entrypoints.size()));
            for (IMethod m : entrypoints) {
                UserLog.logger.debug((Object)("\t" + m.getSignature()));
            }
        }
        this.expandToFixedPoint(entrypoints);
        this.isBuilt = true;
    }

    protected void expandToFixedPoint(Set<IMethod> entrypoints) {
        this.entrypointNodes = this.createEntrypointNodes(entrypoints);
        LinkedList<Pair> worklist = new LinkedList<Pair>();
        for (SCGNode node : this.entrypointNodes) {
            if (this.g.containsNode((Object)node)) continue;
            this.g.addNode((Object)node);
            this.registerNode(node);
            worklist.addLast(Pair.make((Object)((Object)node), (Object)0));
        }
        HashMap targetCache = HashMapFactory.make();
        while (!worklist.isEmpty()) {
            if (++wipeCount > 10000) {
                SSACache ssaCache;
                wipeCount = 0;
                if (this.langServices.doClearAllCaches()) {
                    ReferenceCleanser.clearSoftCaches();
                } else if (this.langServices.doClearSSACache() && (ssaCache = this.analysisCache.getSSACache()) != null) {
                    ssaCache.wipe();
                }
            }
            Pair curPair = (Pair)worklist.removeFirst();
            SCGNode curNode = (SCGNode)((Object)curPair.fst);
            if ((Integer)curPair.snd >= this.initialExpansionBound || !this.langServices.mayLeadToSource(((SCGNode)((Object)curPair.fst)).getMethod())) continue;
            this.visitedForSuccessors.add(curNode);
            Map<CallSiteReference, Set<IMethod>> callees = this.computeTargets(curNode, this.getAnalysisCache(), targetCache);
            for (Map.Entry<CallSiteReference, Set<IMethod>> entry : callees.entrySet()) {
                Set<IMethod> s;
                CallSiteReference site = entry.getKey();
                MethodReference mr = curNode.getMethod().getReference();
                IMethod syntheticTarget = null;
                if (TaintRunner.USE_FRAMEWORKS) {
                    syntheticTarget = FrameworkSupport.getSyntheticTarget(mr, site);
                }
                if (syntheticTarget == null) {
                    s = entry.getValue();
                    for (IMethod possibleThreadStartMethod : s) {
                        if (!possibleThreadStartMethod.getSignature().equals(THREAD_START_SIG)) continue;
                        String RUN_METHOD_NAME = "run";
                        String RUN_METHOD_DESCRIPTOR = "()V";
                        MethodReference declaredTarget = site.getDeclaredTarget();
                        MethodReference overloadedRunMethodReference = MethodReference.findOrCreate((TypeReference)declaredTarget.getDeclaringClass(), (String)"run", (String)"()V");
                        IMethod overloadedRunMethod = this.getIMethodFromMethodReference(overloadedRunMethodReference);
                        s.add(overloadedRunMethod);
                    }
                } else {
                    s = Collections.singleton(syntheticTarget);
                }
                if (s.isEmpty()) {
                    IMethod resolution = this.cha.resolveMethod(site.getDeclaredTarget());
                    if (resolution == null) continue;
                    Map m = MapUtil.findOrCreateMap(this.unresolvedSites, (Object)resolution.getSelector());
                    Set sites = MapUtil.findOrCreateSet((Map)m, (Object)this.resolveTargetClass(curNode, site));
                    sites.add(new CallSite(site, (CGNode)curNode));
                    continue;
                }
                for (IMethod c : s) {
                    if (!this.isEligibleMethod(c)) continue;
                    SCGNode n = new SCGNode(c);
                    if (!this.g.containsNode((Object)n)) {
                        if (this.getNumberOfNodes() >= this.sizeBound) continue;
                        this.g.addNode((Object)n);
                        this.registerNode(n);
                        worklist.addLast(Pair.make((Object)((Object)n), (Object)(this.cha.getScope().isApplicationLoader(c.getDeclaringClass().getClassLoader()) ? 0 : (Integer)curPair.snd + 1)));
                        this.g.addEdge((Object)curNode, (Object)n);
                        curNode.addTarget(site, n);
                        continue;
                    }
                    this.g.addEdge((Object)curNode, (Object)n);
                    curNode.addTarget(site, n);
                }
            }
        }
    }

    protected void computeSuccessorsIfNeeded(CGNode N) {
        if (this.isOnDemandExpansionEnabled() && !this.visitedForSuccessors.contains(N)) {
            this.visitedForSuccessors.add(N);
            HashMap targetCache = HashMapFactory.make();
            Map<CallSiteReference, Set<IMethod>> callees = this.computeTargets(N, this.getAnalysisCache(), targetCache);
            for (Map.Entry<CallSiteReference, Set<IMethod>> entry : callees.entrySet()) {
                CallSiteReference site = entry.getKey();
                Set<IMethod> s = entry.getValue();
                if (s.isEmpty()) {
                    IMethod resolution = this.cha.resolveMethod(site.getDeclaredTarget());
                    if (resolution == null) continue;
                    Map m = MapUtil.findOrCreateMap(this.unresolvedSites, (Object)resolution.getSelector());
                    Set sites = MapUtil.findOrCreateSet((Map)m, (Object)this.resolveTargetClass((SCGNode)N, site));
                    sites.add(new CallSite(site, N));
                    continue;
                }
                for (IMethod c : s) {
                    if (!this.isEligibleMethod(c)) continue;
                    SCGNode n = new SCGNode(c);
                    if (!this.g.containsNode((Object)n)) {
                        if (this.getNumberOfNodes() >= this.sizeBound) continue;
                        this.g.addNode((Object)n);
                        this.registerNode(n);
                        this.g.addEdge((Object)N, (Object)n);
                        N.addTarget(site, (CGNode)n);
                        continue;
                    }
                    this.g.addEdge((Object)N, (Object)n);
                    N.addTarget(site, (CGNode)n);
                }
            }
        }
    }

    protected boolean isOnDemandExpansionEnabled() {
        return true;
    }

    protected IClass resolveTargetClass(CGNode node, CallSiteReference site) {
        TypeAbstraction[] typeAbstractions;
        IClass result;
        IClass iClass = result = site.isStatic() ? this.cha.lookupClass(site.getDeclaredTarget().getDeclaringClass()) : null;
        if (result == null && (typeAbstractions = (TypeAbstraction[])this.node2ta.get(node)) != null) {
            int use;
            SSAAbstractInvokeInstruction call;
            SSAAbstractInvokeInstruction[] calls;
            IR ir = node.getIR();
            try {
                calls = ir.getCalls(site);
            }
            catch (IllegalArgumentException e) {
                calls = null;
            }
            if (calls != null && calls.length == 1 && (call = calls[0]).getNumberOfUses() > 0 && (use = call.getUse(0)) >= 0 && use < typeAbstractions.length) {
                TypeAbstraction receiver = typeAbstractions[use];
                if (receiver instanceof PointType) {
                    result = ((PointType)receiver).getIClass();
                } else if (receiver instanceof ConeType) {
                    result = ((ConeType)receiver).getType();
                }
            }
        }
        IClass declaredTarget = this.cha.lookupClass(site.getDeclaredTarget().getDeclaringClass());
        if (result == null || declaredTarget != null && this.cha.isAssignableFrom(result, declaredTarget)) {
            result = declaredTarget;
        }
        return result;
    }

    protected Set<SCGNode> createEntrypointNodes(Set<IMethod> entrypoints) {
        HashSet ret = HashSetFactory.make((int)entrypoints.size());
        for (IMethod m : entrypoints) {
            if (!this.isEligibleMethod(m)) {
                throw new IllegalStateException("entrypoint is ineligible: " + m);
            }
            SCGNode node = new SCGNode(m);
            ret.add(node);
        }
        return ret;
    }

    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        assert (this.isBuilt);
        assert (node instanceof SCGNode);
        this.computeSuccessorsIfNeeded(node);
        SCGNode n = (SCGNode)node;
        return n.getPossibleTargets(site);
    }

    private Set<IMethod> computeTargets(CGNode node, CallSiteReference site, AnalysisCache analysisCache, Map<Pair<MethodReference, IClass>, Collection<IMethod>> cache) {
        boolean guess;
        int polymorphism;
        TypeAbstraction receiver = null;
        if (site.isDispatch()) {
            receiver = this.typeOfReceiver(node, site);
        }
        IMethod declaredTarget = this.getClassHierarchy().resolveMethod(site.getDeclaredTarget());
        TaintAnalysisCache.setCallGraph(this);
        if (declaredTarget != null && (this.offline.hasSpecForMethod(declaredTarget) || this.offline.isExcluded(declaredTarget))) {
            return Collections.emptySet();
        }
        if (declaredTarget != null && this.isApplication(declaredTarget.getDeclaringClass())) {
            polymorphism = this.appPolymorphism;
            guess = this.appGuess;
        } else if (this.isApplication(node.getMethod().getDeclaringClass())) {
            polymorphism = this.libPolymorphism;
            guess = this.app2libGuess;
        } else {
            polymorphism = this.libPolymorphism;
            guess = this.libGuess;
        }
        IMethod ignoreTarget = this.isDelegationCall(node, site) ? node.getMethod() : null;
        HashSet retBeforeFilter = HashSetFactory.make();
        Iterator<IMethod> targets = this.cgTargetsCache.getTargets(receiver, site);
        while (targets.hasNext() && retBeforeFilter.size() < polymorphism) {
            IMethod next = targets.next();
            if (next == ignoreTarget) continue;
            retBeforeFilter.add(next);
        }
        if (retBeforeFilter.size() == polymorphism && targets.hasNext() && !guess) {
            return Collections.emptySet();
        }
        HashSet ret = HashSetFactory.make();
        for (IMethod m : retBeforeFilter) {
            if (this.offline.hasSpecForMethod(m) || this.offline.isTerminatingMethod(m)) continue;
            ret.add(m);
        }
        return ret;
    }

    private boolean isDelegationCall(CGNode node, CallSiteReference site) {
        return site.getDeclaredTarget().equals((Object)node.getMethod().getReference());
    }

    private TypeAbstraction typeOfReceiver(CGNode node, CallSiteReference site) {
        int index;
        IR ir;
        IntSet s;
        if (this.langServices.doUseTypeInference() && (s = (ir = node.getIR()).getCallInstructionIndices(site)) != null && s.size() == 1 && (index = s.intIterator().next()) > -1) {
            try {
                SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)ir.getInstructions()[index];
                return this.getType(node, call.getReceiver());
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
        }
        return null;
    }

    protected Map<CallSiteReference, Set<IMethod>> computeTargets(CGNode node, AnalysisCache analysisCache, Map<Pair<MethodReference, IClass>, Collection<IMethod>> cache) {
        Collection sites;
        IMethod m = node.getMethod();
        HashMap result = HashMapFactory.make();
        try {
            sites = CodeScanner.getCallSites((IMethod)m);
        }
        catch (InvalidClassFileException e) {
            logger.warn((Object)("Can't compute targets for method " + m + " reason: " + e.getMessage()));
            sites = null;
        }
        catch (EmptyStackException e) {
            logger.warn((Object)("Can't compute targets for method " + m + " reason: " + e.getMessage()));
            sites = null;
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)("Can't compute targets for method " + m + " reason: " + e.getMessage()));
            sites = null;
        }
        catch (NullPointerException e) {
            logger.warn((Object)("Can't compute targets for method " + m + " reason: " + e.getMessage()));
            sites = null;
        }
        catch (UnimplementedError e) {
            logger.warn((Object)("Can't compute targets for method " + m + " reason: " + e.getMessage()));
            sites = null;
        }
        catch (RuntimeException e) {
            logger.warn((Object)("Can't compute targets for method " + m + " reason: " + e.getMessage()));
            sites = null;
        }
        catch (AssertionError e) {
            logger.warn((Object)("Can't compute targets for method " + m + " reason: " + ((Throwable)((Object)e)).getMessage()));
            sites = null;
        }
        if (sites != null) {
            for (CallSiteReference site : sites) {
                try {
                    Set s = MapUtil.findOrCreateSet((Map)result, (Object)site);
                    s.addAll(this.computeTargets(node, site, analysisCache, cache));
                }
                catch (EmptyStackException e) {
                    logger.warn((Object)("Can't compute targets for site " + site + " reason: " + e.getMessage()));
                }
                catch (IndexOutOfBoundsException e) {
                    logger.warn((Object)("Can't compute targets for site " + site + " reason: " + e.getMessage()));
                }
                catch (NullPointerException e) {
                    logger.warn((Object)("Can't compute targets for site " + site + " reason: " + e.getMessage()));
                }
                catch (UnimplementedError e) {
                    logger.warn((Object)("Can't compute targets for site " + site + " reason: " + e.getMessage()));
                }
                catch (RuntimeException e) {
                    logger.warn((Object)("Can't compute targets for site " + site + " reason: " + e.getMessage()));
                }
                catch (AssertionError e) {
                    logger.warn((Object)("Can't compute targets for site " + site + " reason: " + ((Throwable)((Object)e)).getMessage()));
                }
            }
        }
        return result;
    }

    public static IMethod chooseOneFromIntersection(Collection<IMethod> c1, Collection<IMethod> c2) {
        Collection<IMethod> smaller = c1.size() < c2.size() ? c1 : c2;
        Collection<IMethod> bigger = smaller == c1 ? c2 : c1;
        for (IMethod m : smaller) {
            if (!bigger.contains(m)) continue;
            return m;
        }
        return null;
    }

    private boolean isApplication(IClass klass) {
        return this.cha.getScope().isApplicationLoader(this.cha.getLoader(klass.getClassLoader().getReference()));
    }

    public Set<CallSite> scanForCalls(Set<Pair<IClass, Selector>> c) {
        HashSet result = HashSetFactory.make();
        for (Pair<IClass, Selector> p : c) {
            IMethod method;
            if (p == null || (method = ((IClass)p.fst).getMethod((Selector)p.snd)) == null) continue;
            MethodReference mr = method.getReference();
            Set<CGNode> nodes = this.getNodes(mr);
            if (nodes.isEmpty()) {
                Map<IClass, Set<CallSite>> sitesByClasses = this.unresolvedSites.get(p.snd);
                if (sitesByClasses == null) continue;
                for (Map.Entry<IClass, Set<CallSite>> entry : sitesByClasses.entrySet()) {
                    IClass klass = entry.getKey();
                    if (!this.areCompatible((IClass)p.fst, klass)) continue;
                    Set<CallSite> s = entry.getValue();
                    result.addAll(s);
                }
                continue;
            }
            for (CGNode N : nodes) {
                IClass klass = N.getMethod().getDeclaringClass();
                if (!this.areCompatible((IClass)p.fst, klass)) continue;
                Iterator<CGNode> predIter = this.getPredNodes(N);
                while (predIter.hasNext()) {
                    CGNode pred = predIter.next();
                    Iterator<CallSiteReference> possibleSites = this.getPossibleSites(pred, N);
                    while (possibleSites.hasNext()) {
                        result.add(new CallSite(possibleSites.next(), pred));
                    }
                }
            }
        }
        return result;
    }

    private boolean areCompatible(IClass A, IClass B) {
        boolean result = this.cha.isAssignableFrom(A, B);
        if (!result && this.langServices.doAllowLooseResolution()) {
            result = this.cha.isAssignableFrom(B, A);
        }
        return result;
    }

    public Set<CallSite> getCallSites(String sig) {
        IClass declaringClass = SignatureUtil.getDeclaringClass((String)sig, (IClassHierarchy)this.getClassHierarchy());
        if (declaringClass == null) {
            return Collections.emptySet();
        }
        HashSet matches = HashSetFactory.make();
        Collection selectors = SignatureUtil.sig2Selectors((String)sig, (IClassHierarchy)this.getClassHierarchy(), (Language)this.langServices.getLanguage());
        for (Selector s : selectors) {
            matches.add(Pair.make((Object)declaringClass, (Object)s));
        }
        return this.scanForCalls(matches);
    }

    public Set<CallSite> scanForCalls(Collection<IMethod> methods) {
        HashSet c = HashSetFactory.make();
        for (IMethod m : methods) {
            c.add(Pair.make((Object)m.getDeclaringClass(), (Object)m.getSelector()));
        }
        return this.scanForCalls(c);
    }

    public static TICallGraph buildCG(final IMethod m, VirtualResolutionOptions options, OfflineSpecification spec, ILangServices langServices, AccuracyLevel accuracyLevel) {
        return new TICallGraph(m.getClassHierarchy(), new IEntrypointLocator(){

            @Override
            public Set<IMethod> locateEntrypoints(IClassHierarchy cha) {
                return Collections.singleton(m);
            }
        }, spec, langServices, new AnalysisCache(), accuracyLevel, options);
    }

    public Collection<CGNode> getLeaves() {
        if (this.leaves == null) {
            this.leaves = HashSetFactory.make();
            Iterator<CGNode> nodesIter = this.iterator();
            while (nodesIter.hasNext()) {
                this.leaves.add(nodesIter.next());
            }
            for (CGNode n : this) {
                Iterator<CGNode> predsIter = this.getPredNodes(n);
                while (predsIter.hasNext()) {
                    this.leaves.remove(predsIter.next());
                }
            }
        }
        return this.leaves;
    }

    public OfflineSpecification getSpecification() {
        return this.offline;
    }

    public ILangServices getLanguageSpecificServices() {
        return this.langServices;
    }

    public Map<Selector, Map<IClass, Set<CallSite>>> getUnresolvedCalls() {
        return this.unresolvedSites;
    }

    public IMethod getIMethodFromMethodReference(MethodReference mr) {
        for (CGNode n : this) {
            if (!n.getMethod().getReference().equals((Object)mr)) continue;
            return n.getMethod();
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public CGNode getFakeWorldClinitNode() {
        return null;
    }

    public class SCGNode
    extends NodeWithNumber
    implements CGNode {
        public final IMethod m;
        protected final SparseVector<IntSet> targets = new SparseVector();

        public SCGNode(IMethod m) {
            this.m = m;
            if (m.isNative()) assert (m.isSynthetic()) : "unexpected native method " + m;
        }

        public boolean addTarget(CallSiteReference site, CGNode target) {
            int n;
            int pc = site.getProgramCounter();
            MutableSharedBitVectorIntSet s = (MutableSharedBitVectorIntSet)this.targets.get(pc);
            if (s == null) {
                s = new MutableSharedBitVectorIntSet();
                this.targets.set(pc, (Object)s);
            }
            if (s.contains(n = this.getCallGraph().getNumber(target))) {
                return false;
            }
            s.add(n);
            this.getCallGraph().addEdge(this, target);
            return true;
        }

        public boolean removeTarget(CallSiteReference site, CGNode successor) {
            int pc = site.getProgramCounter();
            MutableSharedBitVectorIntSet s = (MutableSharedBitVectorIntSet)this.targets.get(pc);
            return s.remove(this.getCallGraph().getNumber(successor));
        }

        public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG() {
            Assertions.UNREACHABLE();
            return null;
        }

        public Context getContext() {
            return Everywhere.EVERYWHERE;
        }

        public DefUse getDU() {
            return this.getCallGraph().getDU(this.getMethod(), this.getContext());
        }

        public IR getIR() {
            return this.getCallGraph().getIR(this.getMethod(), this.getContext());
        }

        public TICallGraph getCallGraph() {
            return TICallGraph.this;
        }

        public IMethod getMethod() {
            return this.m;
        }

        public Iterator<CallSiteReference> iterateCallSites() {
            if (this.getIR() == null) {
                return EmptyIterator.instance();
            }
            return this.getIR().iterateCallSites();
        }

        public Iterator<NewSiteReference> iterateNewSites() {
            Assertions.UNREACHABLE();
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m == null ? 0 : this.m.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SCGNode other = (SCGNode)((Object)obj);
            return !(this.m == null ? other.m != null : !this.m.equals(other.m));
        }

        public IClassHierarchy getClassHierarchy() {
            return this.m.getClassHierarchy();
        }

        public String toString() {
            return "SCGNode: " + this.m;
        }

        public Set<CGNode> getPossibleTargets(CallSiteReference site) {
            IntSet s = (IntSet)this.targets.get(site.getProgramCounter());
            if (s == null) {
                return Collections.emptySet();
            }
            HashSet h = HashSetFactory.make((int)s.size());
            IntIterator it = s.intIterator();
            while (it.hasNext()) {
                h.add(this.getCallGraph().getNode(it.next()));
            }
            return h;
        }

        public TypeAbstraction[] getTypeAbstractions() {
            return (TypeAbstraction[])TICallGraph.this.node2ta.get((Object)this);
        }
    }

    public static class VirtualResolutionOptions {
        private final int appPolymorphism;
        private final int libPolymorphism;
        private final boolean appGuess;
        private final boolean app2libGuess;
        private final boolean libGuess;
        private static final VirtualResolutionOptions defaultOptions = new VirtualResolutionOptions(5, 1, true, false, false);

        public VirtualResolutionOptions(int appPolymorphism, int libPolymorphism, boolean appGuess, boolean app2libGuess, boolean libGuess) {
            this.appPolymorphism = appPolymorphism;
            this.libPolymorphism = libPolymorphism;
            this.appGuess = appGuess;
            this.app2libGuess = app2libGuess;
            this.libGuess = libGuess;
        }

        public static VirtualResolutionOptions defaultOptions() {
            return defaultOptions;
        }

        public int getAppPolymorphism() {
            return this.appPolymorphism;
        }

        public int getLibPolymorphism() {
            return this.libPolymorphism;
        }

        public boolean isAppGuess() {
            return this.appGuess;
        }

        public boolean isApp2libGuess() {
            return this.app2libGuess;
        }

        public boolean isLibGuess() {
            return this.libGuess;
        }
    }
}

