/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.core.DomainAnalyzer;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PropagationSystem<T, K> {
    private final DomainAnalyzer<T, K> analyzer;
    private final boolean DEBUG = false;
    private final boolean VERBOSE = true;

    public PropagationSystem(DomainAnalyzer<T, K> analyzer) {
        this.analyzer = analyzer;
    }

    public AbstractNumberedLabeledGraph<Variable, IPropagationWitness> run() throws InvalidClassFileException {
        HashSet discovered = HashSetFactory.make();
        for (T element : this.analyzer.getDependenceMap().getElements()) {
            discovered.add(element);
        }
        while (!discovered.isEmpty()) {
            Iterator iter = discovered.iterator();
            discovered = HashSetFactory.make();
            while (iter.hasNext()) {
                Set<T> dependentsOnCurrent;
                Object current = iter.next();
                System.out.println(current);
                if (!this.analyzer.analyze(current) || (dependentsOnCurrent = this.analyzer.getDependenceMap().getDependents(current)) == null) continue;
                discovered.addAll(dependentsOnCurrent);
            }
        }
        return this.analyzer.getDomainMapping();
    }
}

