/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.incremental;

import com.ibm.wala.andromeda.cg.AccuracyLevel;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.incremental.ChangeSet;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IncrementalSCG
extends TICallGraph {
    private static final boolean DEBUG = true;
    private Map<Selector, Map<IClass, Set<CallSite>>> callSiteBindings;
    private boolean isOnDemandExpansionEnabled = true;

    public IncrementalSCG(IClassHierarchy cha, IEntrypointLocator entrypointLocator, OfflineSpecification offline, ILangServices langServices, AnalysisCache cache, AccuracyLevel accuracyLevel) {
        super(cha, entrypointLocator, offline, langServices, cache, accuracyLevel);
    }

    public IncrementalSCG(IClassHierarchy cha, IEntrypointLocator locator, OfflineSpecification spec, ILangServices langServices, AnalysisCache analysisCache, AccuracyLevel accLevel, TICallGraph.VirtualResolutionOptions virtualResolutionOptions) {
        super(cha, locator, spec, langServices, analysisCache, accLevel, virtualResolutionOptions);
    }

    public void adapt(ChangeSet C) {
        block4: for (ChangeSet.Entry e : C) {
            ChangeSet.EntryLevel level = e.getLevel();
            assert (level == ChangeSet.EntryLevel.CALL_GRAPH || level == ChangeSet.EntryLevel.TAINT_ANALYSIS) : "ERROR: expected change level to be either call graph or taint analysis!";
            if (!e.getLevel().equals((Object)ChangeSet.EntryLevel.CALL_GRAPH)) continue;
            switch (e.type()) {
                case METHOD: {
                    this.handleMethodUpate(e);
                    continue block4;
                }
                case CLASS: {
                    this.handleClassUpdate(e);
                    continue block4;
                }
            }
            Assertions.UNREACHABLE((String)"ERROR: expected change to be relative to either a class or a method!");
        }
    }

    private void handleMethodUpate(ChangeSet.Entry e) {
        assert (e instanceof ChangeSet.MethodEntry);
        ChangeSet.MethodEntry me = (ChangeSet.MethodEntry)e;
        MethodReference mr = me.getMethod();
        IClass c = this.cha.lookupClass(mr.getDeclaringClass());
        assert (c != null);
        IMethod m = c.getMethod(mr.getSelector());
        switch (e.getKind()) {
            case ADDITION: {
                this.handleNodeAddition(m);
                break;
            }
            case REMOVAL: {
                TICallGraph.SCGNode toRemove = (TICallGraph.SCGNode)this.getNode(m, (Context)Everywhere.EVERYWHERE);
                assert (toRemove != null);
                this.handleNodeRemoval(toRemove);
                break;
            }
            case MODIFICATION: {
                TICallGraph.SCGNode modified = (TICallGraph.SCGNode)this.getNode(m, (Context)Everywhere.EVERYWHERE);
                assert (modified != null);
                this.handleNodeRemoval(modified);
                this.handleNodeAddition(m);
                break;
            }
            default: {
                Assertions.UNREACHABLE();
            }
        }
    }

    private void handleNodeAddition(IMethod m) {
        IClass c = m.getDeclaringClass();
        TICallGraph.SCGNode N = new TICallGraph.SCGNode(m);
        this.addNode(N);
        this.computeSuccessorsIfNeeded(N);
        Map<IClass, Set<CallSite>> M = this.callSiteBindings.get(m.getSelector());
        if (M != null) {
            for (IClass declaredClass : M.keySet()) {
                Set<CallSite> sites;
                if (!this.cha.isAssignableFrom(declaredClass, c) || (sites = M.get(declaredClass)) == null || sites.size() <= 0) continue;
                this.connect(sites, N);
            }
        }
    }

    @Override
    protected boolean isOnDemandExpansionEnabled() {
        return this.isOnDemandExpansionEnabled;
    }

    private void handleNodeRemoval(CGNode n) {
        this.isOnDemandExpansionEnabled = false;
        Iterator2Set predecessors = Iterator2Collection.toSet(this.getPredNodes(n));
        for (CGNode pred : predecessors) {
            Iterator<CallSiteReference> sitesIter = this.getPossibleSites(pred, n);
            while (sitesIter.hasNext()) {
                CallSiteReference site = sitesIter.next();
                if (this.getNumberOfTargets(pred, site) != 1) continue;
                Map m = MapUtil.findOrCreateMap((Map)this.unresolvedSites, (Object)n.getMethod().getSelector());
                Set S = MapUtil.findOrCreateSet((Map)m, (Object)this.resolveTargetClass(pred, site));
                S.add(new CallSite(site, pred));
            }
        }
        HashSet worklist = HashSetFactory.make();
        HashSet visited = HashSetFactory.make();
        worklist.add(n);
        while (!worklist.isEmpty()) {
            Iterator iter = worklist.iterator();
            worklist = HashSetFactory.make();
            while (iter.hasNext()) {
                CGNode current = (CGNode)iter.next();
                if (!visited.add(current)) continue;
                Iterator2Set successors = Iterator2Collection.toSet(this.getSuccNodes(current));
                for (CGNode successor : successors) {
                    Iterator<CallSiteReference> it = this.getPossibleSites(current, successor);
                    while (it.hasNext()) {
                        CallSiteReference site = it.next();
                        ((TICallGraph.SCGNode)current).removeTarget(site, successor);
                    }
                    this.g.removeEdge((Object)current, (Object)successor);
                    if (this.getPredNodeCount(successor) != 0 || visited.contains(successor)) continue;
                    worklist.add(successor);
                }
                this.g.removeIncomingEdges((Object)current);
                this.g.removeNode((Object)current);
                this.analysisCache.invalidate(current.getMethod(), current.getContext());
                System.out.println("INFO: Call-graph node '" + current.getMethod().getName() + "' removed.");
                this.updateState(current);
            }
        }
        this.isOnDemandExpansionEnabled = true;
    }

    private void updateState(CGNode current) {
        if (this.mr2node != null) {
            MethodReference mr = current.getMethod().getReference();
            CGNode[] nodes = (CGNode[])this.mr2node.get(mr);
            CGNode[] modifiedNodes = new CGNode[nodes.length - 1];
            int currentIndex = 0;
            for (int index = 0; index < nodes.length; ++index) {
                if (nodes[index] == current) continue;
                modifiedNodes[currentIndex++] = nodes[index];
            }
            this.mr2node.put(mr, modifiedNodes);
        }
        if (this.node2ta != null) {
            this.node2ta.remove(current);
        }
        if (this.entrypointNodes != null) {
            this.entrypointNodes.remove(current);
        }
        if (this.visitedForSuccessors != null) {
            this.visitedForSuccessors.remove(current);
        }
        if (this.leaves != null) {
            this.leaves.remove(current);
        }
    }

    private void connect(Set<CallSite> S, TICallGraph.SCGNode n) {
        for (CallSite c : S) {
            CGNode predNode = c.getNode();
            this.g.addEdge((Object)predNode, (Object)n);
            ((TICallGraph.SCGNode)predNode).addTarget(c.getSite(), n);
            System.out.println("INFO: Call-graph edge '" + predNode.getMethod().getName() + "' ---> '" + n.getMethod().getName() + "' added.");
        }
    }

    private void addNode(TICallGraph.SCGNode n) {
        if (!this.g.containsNode((Object)n)) {
            this.g.addNode((Object)n);
            this.registerNode(n);
            System.out.println("INFO: Call-graph node '" + n.getMethod().getName() + "' added.");
        }
    }

    private void handleClassUpdate(ChangeSet.Entry e) {
        Assertions.UNREACHABLE((String)"ERROR: cannot process a class entry!");
    }

    @Override
    protected Map<CallSiteReference, Set<IMethod>> computeTargets(CGNode node, AnalysisCache analysisCache, Map<Pair<MethodReference, IClass>, Collection<IMethod>> cache) {
        Map<CallSiteReference, Set<IMethod>> result = super.computeTargets(node, analysisCache, cache);
        if (result.keySet() != null) {
            for (CallSiteReference site : result.keySet()) {
                Map M = MapUtil.findOrCreateMap(this.getCallSiteBindings(), (Object)site.getDeclaredTarget().getSelector());
                IClass c = this.resolveTargetClass(node, site);
                if (c == null) continue;
                Set S = MapUtil.findOrCreateSet((Map)M, (Object)c);
                S.add(new CallSite(site, node));
            }
        }
        return result;
    }

    private Map<Selector, Map<IClass, Set<CallSite>>> getCallSiteBindings() {
        if (this.callSiteBindings == null) {
            this.callSiteBindings = HashMapFactory.make();
        }
        return this.callSiteBindings;
    }
}

