/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.jsp;

import com.ibm.wala.andromeda.jsp.JSPFileInfo;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LineInfo {
    private final JSPFileInfo sourceFile;
    private final Map<Integer, Set<Integer>> jspToJavaMappings = HashMapFactory.make();
    private final Map<Integer, Set<Integer>> javaToJSPMappings;

    public LineInfo(int inputStartLine, JSPFileInfo fileSectionEntry, int repeatCount, int outputStartLine, int outputLineIncrement) {
        this.sourceFile = fileSectionEntry;
        this.buildMappingsTable(inputStartLine, repeatCount, outputStartLine, outputLineIncrement);
        this.javaToJSPMappings = MapUtil.inverseMap(this.jspToJavaMappings);
    }

    private void buildMappingsTable(int inputStartLine, int repeatCount, int outputStartLine, int outputLineIncrement) {
        int inputLine = inputStartLine;
        int outputLine = outputStartLine;
        for (int index = 0; index < repeatCount; ++index) {
            HashSet image = HashSetFactory.make((int)outputLineIncrement);
            for (int listIndex = 0; listIndex < outputLineIncrement; ++listIndex) {
                image.add(outputLine + listIndex);
            }
            this.jspToJavaMappings.put(inputLine, image);
            ++inputLine;
            outputLine += outputLineIncrement;
        }
    }

    public Map<Integer, Set<Integer>> getJavaToJSPMappings() {
        return this.javaToJSPMappings;
    }

    public Map<Integer, Set<Integer>> getJSPToJavaMappings() {
        return this.jspToJavaMappings;
    }

    public JSPFileInfo getSourceFile() {
        return this.sourceFile;
    }

    private static int getRepeatCount(String inputSide) {
        int repeatCount = 1;
        if (inputSide.indexOf(44) >= 0) {
            repeatCount = Integer.parseInt(inputSide.substring(inputSide.indexOf(44) + 1));
        }
        return repeatCount;
    }

    private static int getInputStartLine(String inputSide) {
        int inputStartLine = -1;
        inputStartLine = inputSide.indexOf(35) >= 0 ? Integer.parseInt(inputSide.substring(0, inputSide.indexOf(35))) : (inputSide.indexOf(44) >= 0 ? Integer.parseInt(inputSide.substring(0, inputSide.indexOf(44))) : Integer.parseInt(inputSide));
        return inputStartLine;
    }

    private static Pair<JSPFileInfo, Integer> getInputFile(String inputSide, Map<Integer, JSPFileInfo> sourceFilesByID, int lastFileID) {
        int inputFileID = -1;
        if (inputSide.indexOf(35) >= 0) {
            inputFileID = inputSide.indexOf(44) >= 0 ? Integer.parseInt(inputSide.substring(inputSide.indexOf(35) + 1, inputSide.indexOf(44))) : Integer.parseInt(inputSide.substring(inputSide.indexOf(35) + 1));
        }
        int fileID = inputFileID < 0 ? lastFileID : inputFileID;
        return Pair.make((Object)sourceFilesByID.get(fileID), (Object)fileID);
    }

    private static int getOutputStartLine(String outputSide) {
        if (outputSide.indexOf(44) >= 0) {
            return Integer.parseInt(outputSide.substring(0, outputSide.indexOf(44)));
        }
        return Integer.parseInt(outputSide);
    }

    private static int getOutputLineIncrement(String outputSide) {
        if (outputSide.indexOf(44) >= 0) {
            return Integer.parseInt(outputSide.substring(outputSide.indexOf(44) + 1));
        }
        return 1;
    }

    public static Pair<LineInfo, Integer> parse(String rawLineInfo, Map<Integer, JSPFileInfo> sourceFilesByID, int lastFileID) {
        assert (rawLineInfo.indexOf(58) >= 0);
        String inputSide = rawLineInfo.substring(0, rawLineInfo.indexOf(58));
        String outputSide = rawLineInfo.substring(rawLineInfo.indexOf(58) + 1);
        int inputStartLine = LineInfo.getInputStartLine(inputSide);
        Pair<JSPFileInfo, Integer> fileSectionEntryAndLastFileID = LineInfo.getInputFile(inputSide, sourceFilesByID, lastFileID);
        int repeatCount = LineInfo.getRepeatCount(inputSide);
        int outputStartLine = LineInfo.getOutputStartLine(outputSide);
        int outputLineIncrement = LineInfo.getOutputLineIncrement(outputSide);
        return Pair.make((Object)new LineInfo(inputStartLine, (JSPFileInfo)fileSectionEntryAndLastFileID.fst, repeatCount, outputStartLine, outputLineIncrement), (Object)fileSectionEntryAndLastFileID.snd);
    }
}

