/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.lang;

import com.ibm.wala.andromeda.cg.EntrypointLocator;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JavaServices
implements ILangServices {
    @Override
    public String getOfflineSpecificationFile() {
        return "dat/offline.java.dat";
    }

    @Override
    public Language getLanguage() {
        return Language.JAVA;
    }

    @Override
    public boolean doClearAllCaches() {
        return true;
    }

    @Override
    public boolean doUseTypeInference() {
        return true;
    }

    @Override
    public IEntrypointLocator getEntrypointLocator(final IClassHierarchy cha) {
        final HashSet c = HashSetFactory.make();
        for (IClassLoader l : cha.getLoaders()) {
            if (!cha.getScope().isApplicationLoader(l)) continue;
            c.add(l);
        }
        return EntrypointLocator.makeLocator(new Predicate<IClass>(){

            public boolean test(IClass o) {
                return c.contains(cha.getLoader(o.getClassLoader().getReference()));
            }
        }, EntrypointLocator.getDefaultMethodFilter(), cha);
    }

    @Override
    public boolean doAllowLooseResolution() {
        return false;
    }

    @Override
    public String resolveSourceFile(String clsName) {
        String prettyClsName = clsName.substring(clsName.lastIndexOf(46) + 1);
        return prettyClsName.concat(".java");
    }

    @Override
    public boolean mayLeadToSource(IMethod m) {
        if (m.getClassHierarchy().getScope().isApplicationLoader(m.getDeclaringClass().getClassLoader())) {
            return true;
        }
        return !m.getDeclaringClass().getName().toString().startsWith("Ljava/lang/");
    }

    @Override
    public boolean doClearSSACache() {
        return true;
    }

    @Override
    public boolean isStringish(IClass c) {
        return ZeroXInstanceKeys.isStringish((IClass)c);
    }

    @Override
    public Collection<CallSiteReference> getCallSiteRefs(CGNode n) {
        Collection result = null;
        try {
            result = CodeScanner.getCallSites((IMethod)n.getMethod());
        }
        catch (InvalidClassFileException invalidClassFileException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Collection<FieldReference> getFieldsRead(CGNode n) {
        Collection result = null;
        try {
            result = CodeScanner.getFieldsRead((IMethod)n.getMethod());
        }
        catch (InvalidClassFileException invalidClassFileException) {
            // empty catch block
        }
        return result;
    }

    public Set<String> getTargetNames(CallGraph cg, CallSite cs, SSAAbstractInvokeInstruction invoke) {
        Assertions.UNREACHABLE((String)"Only in JS for now");
        return null;
    }
}

