/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.java.translator;

import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.stringAnalysis.callgraph.InterReachingDefs;
import com.ibm.wala.stringAnalysis.java.translator.JavaRegexParser;
import com.ibm.wala.stringAnalysis.translator.IRegexParser;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RepositoryUtil {
    public static final boolean enableConstantPropagation = Boolean.valueOf(System.getProperty("com.ibm.wala.stringAnalysis.enableConstantPropagationForSignatureFilter", "true"));
    private static Map<String, String> constSignatures = new HashMap<String, String>();
    private static final IRegexParser regexParser;

    private static boolean isConstantString(int recv, CGNode node, InterReachingDefs rd) {
        if (enableConstantPropagation) {
            return RepositoryUtil.isPropagatedConstantString(recv, node, rd);
        }
        return RepositoryUtil.isSimpleConstantString(recv, node);
    }

    private static boolean isSimpleConstantString(int recv, CGNode node) {
        Value val = node.getIR().getSymbolTable().getValue(recv);
        if (val != null) {
            SSAGetInstruction getInst;
            if (val.isStringConstant()) {
                return true;
            }
            SSAInstruction recvDef = node.getDU().getDef(recv);
            if (recvDef instanceof SSAGetInstruction && (getInst = (SSAGetInstruction)recvDef).isStatic()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isPropagatedConstantString(int recv, CGNode node, InterReachingDefs rd) {
        if (rd == null) {
            return false;
        }
        Collection lpkeys = rd.getDefs(node, recv);
        if (lpkeys == null || lpkeys.isEmpty()) {
            return false;
        }
        for (LocalPointerKey lpkey : lpkeys) {
            if (RepositoryUtil.isSimpleConstantString(lpkey.getValueNumber(), lpkey.getNode())) continue;
            return false;
        }
        return true;
    }

    public static String filterConstSignature(String sig, SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        int recv;
        if (constSignatures.containsKey(sig) && RepositoryUtil.isConstantString(recv = invoke.getReceiver(), ctx.getCGNode(), ctx.getReachingDefs())) {
            return constSignatures.get(sig);
        }
        return sig;
    }

    public static Set<String> getSignature(SSAAbstractInvokeInstruction invoke, TranslationContext ctx, ITranslatorRepository<?> repository) {
        HashSet<String> s = new HashSet<String>();
        String signature = invoke.getDeclaredTarget().getSignature();
        if (repository.hasSignature(signature)) {
            s.add(RepositoryUtil.filterConstSignature(signature, invoke, ctx));
        } else {
            Set nodes = ctx.getCallGraph().getNodes(invoke.getDeclaredTarget());
            if (nodes.isEmpty()) {
                s.add(RepositoryUtil.filterConstSignature(signature, invoke, ctx));
            } else {
                for (CGNode node : nodes) {
                    String sig = node.getMethod().getSignature();
                    s.add(RepositoryUtil.filterConstSignature(sig, invoke, ctx));
                }
            }
        }
        return s;
    }

    public static IRegexParser getRegexParser() {
        return regexParser;
    }

    static {
        constSignatures.put("java.lang.String.indexOf(I)I", "#const.java.lang.String.indexOf(I)I");
        constSignatures.put("java.lang.String.indexOf(Ljava/lang/String;)I", "#const.java.lang.String.indexOf(Ljava/lang/String;)I");
        constSignatures.put("java.lang.String.equals(Ljava/lang/Object;)Z", "#const.java.lang.String.equals(Ljava/lang/Object;)Z");
        regexParser = new IRegexParser(){
            JavaRegexParser parser = new JavaRegexParser();

            public IPattern parse(String str) {
                return this.parser.parse(str);
            }
        };
    }
}

