/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.auth.handlers;

import com.ibm.appscan.cli.cloud.auth.Messages;
import com.ibm.appscan.cli.cloud.auth.providers.AuthenticationProvider;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class EntitlementHandler
implements SaaSConstants {
    private IConsole m_console = CommonCLICore.getIOConsole();
    private AuthenticationProvider m_authProvider = AuthenticationProvider.getInstance();
    private HttpClient m_httpClient = new HttpClient();
    private Map<String, String> m_request_headers = this.m_authProvider.getAuthorizationHeader();
    private String m_request_url = this.m_authProvider.getServer() + "/api/v4/Account/TenantInfo";

    public boolean hasSASTEntitlement() throws IOException, JSONException {
        HttpResponse response = this.m_httpClient.get(this.m_request_url, this.m_request_headers, null);
        if (response.isSuccess()) {
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            String subscriptionType = object.optString("ActiveTechnologies");
            if (subscriptionType == null || subscriptionType.contains("StaticAnalyzer")) {
                return true;
            }
            CommonCLICore.getLogManager().log(new Message(4, Messages.getMessage("no.sast.entitlement", new Object[0])));
            return false;
        }
        this.m_console.println(Messages.getMessage("entitlement.check.connection.error", new Object[0]));
        CommonCLICore.getLogManager().log(new Message(4, Messages.getMessage("entitlement.check.connection.error", new Object[0])));
        return false;
    }

    public boolean hasOpenSourceEntitlement() throws IOException, JSONException {
        HttpResponse response = this.m_httpClient.get(this.m_request_url, this.m_request_headers, null);
        if (response.isSuccess()) {
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            String subscriptionType = object.optString("ActiveTechnologies");
            if (subscriptionType.contains("ScaAnalyzer")) {
                return true;
            }
            CommonCLICore.getLogManager().log(new Message(4, Messages.getMessage("no.opensource.entitlement", new Object[0])));
            return false;
        }
        this.m_console.println(Messages.getMessage("entitlement.check.connection.error", new Object[0]));
        CommonCLICore.getLogManager().log(new Message(4, Messages.getMessage("entitlement.check.connection.error", new Object[0])));
        return false;
    }
}

